/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.init.DefaultDriverAdapter;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.handler.DataRowHandler;
import org.anyline.data.handler.EntityHandler;
import org.anyline.data.handler.MapHandler;
import org.anyline.data.handler.ResultSetHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.runtime.JDBCRuntime;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.AutoPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.data.util.ThreadConfig;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.Join;
import org.anyline.entity.PageNavi;
import org.anyline.exception.SQLQueryException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.ColumnType;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public abstract class DefaultJDBCAdapter
extends DefaultDriverAdapter
implements JDBCAdapter {
    protected static final Logger log = LoggerFactory.getLogger(DefaultJDBCAdapter.class);
    @Autowired(required=false)
    protected DMListener dmListener;
    @Autowired(required=false)
    protected DDListener ddListener;

    public DMListener getListener() {
        return this.dmListener;
    }

    @Autowired(required=false)
    public void setListener(DMListener listener) {
        this.dmListener = listener;
    }

    protected JdbcTemplate jdbc(DataRuntime runtime) {
        Object processor = runtime.getProcessor();
        return (JdbcTemplate)processor;
    }

    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        boolean result = false;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        Run run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign((boolean)false, (boolean)false, (String)prepare.getTable(), (ConfigStore)configs, (String[])conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return false;
        }
        if (null != this.dmListener) {
            this.dmListener.beforeExists(runtime, random, run);
        }
        long fr = System.currentTimeMillis();
        Map<String, Object> map = this.map(runtime, random, configs, run);
        result = null == map ? false : BasicUtil.parseBoolean((Object)map.get("IS_EXISTS"), (Boolean)false);
        Long millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterExists(runtime, random, run, true, result, millis.longValue());
        }
        return result;
    }

    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        List runs = this.buildQuerySequence(runtime, next, names);
        if (null != runs && runs.size() > 0) {
            Run run = (Run)runs.get(0);
            if (!run.isValid()) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][sequence:" + names);
                }
                return new DataRow();
            }
            DataSet set = this.select(runtime, random, true, null, null, run);
            if (set.size() > 0) {
                return set.getRow(0);
            }
        }
        return new DataRow();
    }

    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        long count = -1L;
        Long fr = System.currentTimeMillis();
        Run run = null;
        if (null == random) {
            random = this.random(runtime);
        }
        boolean cmd_success = false;
        ACTION.SWITCH swt = InterceptorProxy.prepareCount((DataRuntime)runtime, (String)random, (RunPrepare)prepare, (ConfigStore)configs, (String[])conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign((boolean)false, (boolean)false, (String)prepare.getTable(), (ConfigStore)configs, (String[])conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        if (null != this.dmListener) {
            this.dmListener.beforeCount(runtime, random, run);
        }
        if ((swt = InterceptorProxy.beforeCount((DataRuntime)runtime, (String)random, (Run)run)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        fr = System.currentTimeMillis();
        count = this.count(runtime, random, run);
        cmd_success = true;
        if (null != this.dmListener) {
            this.dmListener.afterCount(runtime, random, run, cmd_success, count, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterCount((DataRuntime)runtime, (String)random, (Run)run, (boolean)cmd_success, (long)count, (long)(System.currentTimeMillis() - fr));
        return count;
    }

    public long count(DataRuntime runtime, String random, Run run) {
        long total = 0L;
        DataSet set = this.select(runtime, random, false, null, null, run, run.getTotalQuery(), run.getValues());
        total = set.getInt(0, "CNT", 0);
        return total;
    }

    @Override
    public DataRow row(boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas, ResultSet rs) {
        DataRow row = new DataRow();
        try {
            Column column;
            String name;
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            if (!system && (null == metadatas || metadatas.isEmpty())) {
                for (i = 1; i <= qty; ++i) {
                    name = rsmd.getColumnName(i);
                    if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                    column = metadatas.get(name);
                    column = this.column(runtime, column, rsmd, i);
                    metadatas.put(name.toUpperCase(), column);
                }
            }
            for (i = 1; i <= qty; ++i) {
                name = rsmd.getColumnLabel(i);
                if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                column = metadatas.get(name.toUpperCase());
                Object value = this.read(runtime, column, rs.getObject(name), null);
                row.put(false, name, value);
            }
            row.setMetadata(metadatas);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[\u5c01\u88c5\u7ed3\u679c\u96c6][result:fail][msg:{}]", (Object)e.toString());
        }
        return row;
    }

    protected boolean stream(StreamHandler handler, ResultSet rs, ConfigStore configs, boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas) {
        try {
            if (handler instanceof ResultSetHandler) {
                return ((ResultSetHandler)handler).read(rs);
            }
            if (handler instanceof DataRowHandler) {
                DataRowHandler dataRowHandler = (DataRowHandler)handler;
                DataRow row = this.row(system, runtime, metadatas, rs);
                if (!dataRowHandler.read(row)) {
                    return false;
                }
            } else if (handler instanceof EntityHandler) {
                DataRow row;
                EntityHandler entityHandler;
                Class clazz = configs.entityClass();
                if (null != clazz && !(entityHandler = (EntityHandler)handler).read((row = this.row(system, runtime, metadatas, rs)).entity(clazz, new String[0]))) {
                    return false;
                }
            } else if (handler instanceof MapHandler) {
                MapHandler mh = (MapHandler)handler;
                ResultSetMetaData rsmd = rs.getMetaData();
                int cols = rsmd.getColumnCount();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= cols; ++i) {
                    map.put(rsmd.getColumnLabel(i), rs.getObject(i));
                }
                if (!mh.read(map)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected DataSet select(DataRuntime runtime, String random, final boolean system, String table, ConfigStore configs, Run run, String sql, List<Object> values) {
        DataSet set;
        block21: {
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
                }
                log.error("\u672a\u6307\u5b9aSQL");
                return new DataSet();
            }
            if (null != configs) {
                configs.add(run);
            }
            long fr = System.currentTimeMillis();
            if (null == random) {
                random = this.random(runtime);
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:select][sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param(values)});
            }
            set = new DataSet();
            LinkedHashMap<Object, Object> columns = new LinkedHashMap();
            if (!system && ThreadConfig.check((String)runtime.getKey()).IS_AUTO_CHECK_METADATA() && null != table) {
                columns = this.columns(runtime, random, false, new Table(table), false);
            }
            try {
                final DataRuntime rt = runtime;
                final long[] mid = new long[]{System.currentTimeMillis()};
                final boolean[] process = new boolean[]{false};
                final LinkedHashMap metadatas = new LinkedHashMap();
                metadatas.putAll(columns);
                set.setMetadata(metadatas);
                JdbcTemplate jdbc = this.jdbc(runtime);
                StreamHandler _handler = null;
                if (null != configs) {
                    _handler = configs.stream();
                }
                long[] count = new long[]{0L};
                StreamHandler handler = _handler;
                if (null != handler) {
                    jdbc.query(con -> {
                        PreparedStatement ps = con.prepareStatement(sql, 1003, 1007);
                        ps.setFetchSize(handler.size());
                        ps.setFetchDirection(1000);
                        if (null != values && values.size() > 0) {
                            int idx = 0;
                            for (Object value : values) {
                                ps.setObject(++idx, value);
                            }
                        }
                        return ps;
                    }, rs -> {
                        if (!process[0]) {
                            lArray[0] = System.currentTimeMillis();
                            blArray[0] = true;
                        }
                        this.stream(handler, rs, configs, system, runtime, metadatas);
                        lArray2[0] = count[0] + 1L;
                    });
                } else {
                    if (null != values && values.size() > 0) {
                        jdbc.query(sql, values.toArray(), new RowCallbackHandler(){

                            public void processRow(ResultSet rs) throws SQLException {
                                if (!process[0]) {
                                    mid[0] = System.currentTimeMillis();
                                    process[0] = true;
                                }
                                DataRow row = DefaultJDBCAdapter.this.row(system, rt, (LinkedHashMap<String, Column>)metadatas, rs);
                                set.add(row);
                            }
                        });
                    } else {
                        jdbc.query(sql, new RowCallbackHandler(){

                            public void processRow(ResultSet rs) throws SQLException {
                                if (!process[0]) {
                                    mid[0] = System.currentTimeMillis();
                                    process[0] = true;
                                }
                                DataRow row = DefaultJDBCAdapter.this.row(system, rt, (LinkedHashMap<String, Column>)metadatas, rs);
                                set.add(row);
                            }
                        });
                    }
                    count[0] = set.size();
                }
                if (!process[0]) {
                    mid[0] = System.currentTimeMillis();
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L) {
                    slow = true;
                    if (mid[0] - fr > SLOW_SQL_MILLIS) {
                        log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, mid[0] - fr, sql, LogUtil.param(values)});
                        if (null != this.dmListener) {
                            this.dmListener.slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, (Object)set, mid[0] - fr);
                        }
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
                }
                set.setDatalink(runtime.datasource());
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], count[0]});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block21;
                log.error("{}[{}][action:select][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param(values)});
            }
        }
        return set;
    }

    public DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run) {
        String sql = run.getFinalQuery();
        if (BasicUtil.isEmpty((Object)sql)) {
            return new DataSet();
        }
        List values = run.getValues();
        return this.select(runtime, random, system, table, configs, run, sql, values);
    }

    protected DataRow row(DataRuntime runtime, boolean system, LinkedHashMap<String, Column> metadatas, ResultSet rs) {
        DataRow row = new DataRow();
        try {
            Column column;
            String name;
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            if (!system && metadatas.isEmpty()) {
                for (i = 1; i <= qty; ++i) {
                    name = rsmd.getColumnName(i);
                    if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                    column = metadatas.get(name);
                    column = this.column(runtime, column, rsmd, i);
                    metadatas.put(name.toUpperCase(), column);
                }
            }
            for (i = 1; i <= qty; ++i) {
                name = rsmd.getColumnLabel(i);
                if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                column = metadatas.get(name.toUpperCase());
                Object value = this.read(runtime, column, rs.getObject(name), null);
                row.put(false, name, value);
            }
            row.setMetadata(metadatas);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[\u5c01\u88c5\u7ed3\u679c\u96c6][result:fail][msg:{}]", (Object)e.toString());
        }
        return row;
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        ArrayList<Map<String, Object>> maps = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        Run run = null;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareQuery((DataRuntime)runtime, (String)random, (RunPrepare)prepare, (ConfigStore)configs, (String[])conditions)) == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        Long fr = System.currentTimeMillis();
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
            String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            String src = "";
            src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
            tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign((boolean)false, (boolean)false, (String)src, (ConfigStore)configs, (String[])conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn(tmp);
        }
        if (run.isValid()) {
            swt = InterceptorProxy.beforeQuery((DataRuntime)runtime, (String)random, (Run)run, null);
            if (swt == ACTION.SWITCH.BREAK) {
                return new ArrayList<Map<String, Object>>();
            }
            if (null != this.dmListener) {
                this.dmListener.beforeQuery(runtime, random, run, -1L);
            }
            maps = this.maps(runtime, random, configs, run);
            cmd_success = true;
        } else {
            maps = new ArrayList();
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, maps, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery((DataRuntime)runtime, (String)random, (Run)run, (boolean)cmd_success, maps, null, (long)(System.currentTimeMillis() - fr));
        return maps;
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        List maps;
        block16: {
            maps = null;
            if (null == random) {
                random = this.random(runtime);
            }
            if (null != configs) {
                configs.add(run);
            }
            String sql = run.getFinalQuery();
            List values = run.getValues();
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
                }
                log.error("\u672a\u6307\u5b9aSQL");
                return new ArrayList<Map<String, Object>>();
            }
            long fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:select][sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
            }
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                StreamHandler _handler = null;
                if (null != configs) {
                    _handler = configs.stream();
                }
                long[] count = new long[]{0L};
                boolean[] process = new boolean[]{false};
                StreamHandler handler = _handler;
                long[] mid = new long[]{System.currentTimeMillis()};
                if (null != handler) {
                    jdbc.query(con -> {
                        PreparedStatement ps = con.prepareStatement(sql, 1003, 1007);
                        ps.setFetchSize(handler.size());
                        ps.setFetchDirection(1000);
                        if (null != values && values.size() > 0) {
                            int idx = 0;
                            for (Object value : values) {
                                ps.setObject(++idx, value);
                            }
                        }
                        return ps;
                    }, rs -> {
                        if (!process[0]) {
                            lArray[0] = System.currentTimeMillis();
                            blArray[0] = true;
                        }
                        this.stream(handler, rs, configs, true, runtime, null);
                        lArray2[0] = count[0] + 1L;
                    });
                    maps = new ArrayList();
                } else {
                    maps = null != values && values.size() > 0 ? jdbc.queryForList(sql, values.toArray()) : jdbc.queryForList(sql);
                    mid[0] = System.currentTimeMillis();
                    count[0] = maps.size();
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && mid[0] - fr > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, mid[0] - fr, sql, LogUtil.param((List)values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, maps, mid[0] - fr);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
                }
                maps = this.process(runtime, maps);
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], count});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block16;
                log.error("{}[{}][action:select][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)values)});
            }
        }
        return maps;
    }

    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long fr;
        List values;
        String sql;
        Map map;
        block9: {
            map = null;
            sql = run.getFinalExists();
            values = run.getValues();
            if (null != configs) {
                configs.add(run);
            }
            fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:select][sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
            }
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                map = null != values && values.size() > 0 ? jdbc.queryForMap(sql, values.toArray()) : jdbc.queryForMap(sql);
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw e;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block9;
                log.error("{}[{}][action:select][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e, sql, LogUtil.param((List)values)});
            }
        }
        Long millis = System.currentTimeMillis() - fr;
        boolean slow = false;
        long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
        if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
            slow = true;
            log.warn("{}[slow cmd][action:exists][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)values)});
            if (null != this.dmListener) {
                this.dmListener.slow(runtime, random, ACTION.DML.EXISTS, run, sql, values, null, true, (Object)map, millis.longValue());
            }
        }
        if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)(map == null ? 0 : 1), (int)34)});
        }
        return map;
    }

    protected void batch(JdbcTemplate jdbc, String sql, int batch, final int vol, final List<Object> values) {
        int size = values.size();
        final int line = size / vol;
        jdbc.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                for (int p = 1; p <= vol; ++p) {
                    ps.setObject(p, values.get(vol * i + p - 1));
                }
            }

            public int getBatchSize() {
                return line;
            }
        });
    }

    public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        int result;
        block16: {
            result = 0;
            if (!run.isValid()) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
                }
                return -1L;
            }
            String sql = null;
            sql = run.getFinalUpdate();
            if (BasicUtil.isEmpty((Object)sql)) {
                log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)dest);
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List values = run.getValues();
            int batch = run.getBatch();
            long fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                if (batch > 1) {
                    log.info("{}[action:batch update][sql:\n{}\n]\n[param size:{}]", new Object[]{random, sql, values.size()});
                } else {
                    log.info("{}[action:update][sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
                }
            }
            long millis = -1L;
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (batch > 1) {
                    this.batch(jdbc, sql, batch, run.getVol(), values);
                } else {
                    result = jdbc.update(sql, values.toArray());
                }
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:update][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.UPDATE, run, sql, values, null, true, (Object)result, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:update][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    SQLUpdateException ex = new SQLUpdateException("update\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block16;
                log.error("{}[{}][action:update][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)run.getUpdateColumns(), (List)values)});
            }
        }
        return result;
    }

    public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, boolean checkPrimary, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, checkPrimary, columns);
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, final String[] pks) {
        long cnt;
        block16: {
            cnt = 0L;
            if (!run.isValid()) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][action:insert][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + run.getTable() + "]");
                }
                return -1L;
            }
            final String sql = run.getFinalInsert();
            if (BasicUtil.isEmpty((Object)sql)) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][action:insert][dest:{}]", (Object)run.getTable());
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            int batch = run.getBatch();
            final List values = run.getValues();
            long fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                if (batch > 1) {
                    log.info("{}[action:batch insert][sql:\n{}\n]\n[param size:{}]", new Object[]{random, sql, values.size()});
                } else {
                    log.info("{}[action:insert][sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
                }
            }
            long millis = -1L;
            GeneratedKeyHolder keyholder = null;
            JdbcTemplate jdbc = this.jdbc(runtime);
            try {
                if (batch > 1) {
                    this.batch(jdbc, sql, batch, run.getVol(), values);
                } else {
                    keyholder = new GeneratedKeyHolder();
                    cnt = jdbc.update(new PreparedStatementCreator(){

                        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                            PreparedStatement ps = null;
                            ps = null != pks && pks.length > 0 ? con.prepareStatement(sql, pks) : con.prepareStatement(sql, 1);
                            int idx = 0;
                            if (null != values) {
                                for (Object obj : values) {
                                    ps.setObject(++idx, obj);
                                }
                            }
                            return ps;
                        }
                    }, (KeyHolder)keyholder);
                }
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:insert][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.INSERT, run, sql, values, null, true, (Object)cnt, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:insert][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((long)cnt, (int)34)});
                }
                this.identity(runtime, random, data, (KeyHolder)keyholder);
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block16;
                log.error("{}[{}][action:insert][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)run.getInsertColumns(), (List)values)});
            }
        }
        return cnt;
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks, boolean simple) {
        List values;
        String sql;
        long cnt;
        block17: {
            cnt = 0L;
            if (null == random) {
                random = this.random(runtime);
            }
            if (!run.isValid()) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][action:insert][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + run.getTable() + "]");
                }
                return -1L;
            }
            sql = run.getFinalInsert();
            if (BasicUtil.isEmpty((Object)sql)) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][action:insert][dest:{}]", (Object)run.getTable());
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            values = run.getValues();
            long fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:insert][sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
            }
            long millis = -1L;
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == values || values.isEmpty()) {
                    cnt = jdbc.update(sql);
                } else {
                    int size = values.size();
                    Object[] params = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        params[i] = values.get(i);
                    }
                    cnt = jdbc.update(sql, params);
                }
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:insert][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.INSERT, run, sql, values, null, true, (Object)cnt, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:insert][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((long)cnt, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block17;
                log.error("{}[{}][action:insert][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)run.getInsertColumns(), (List)values)});
            }
        }
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:insert][sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)run.getInsertColumns(), (List)values)});
        }
        return cnt;
    }

    public long save(DataRuntime runtime, String random, String dest, Object data, boolean checkPrimary, List<String> columns) {
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("save\u7a7a\u6570\u636e");
            }
            log.error("save\u7a7a\u6570\u636e");
            return -1L;
        }
        if (data instanceof Collection) {
            Collection items = (Collection)data;
            long cnt = 0L;
            for (Object item : items) {
                cnt += this.save(runtime, random, dest, item, checkPrimary, columns);
            }
            return cnt;
        }
        return this.saveObject(runtime, random, dest, data, checkPrimary, columns);
    }

    protected long saveCollection(DataRuntime runtime, String random, String dest, Collection<?> data, boolean checkPrimary, List<String> columns) {
        long cnt = 0L;
        return cnt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long saveObject(DataRuntime runtime, String random, String dest, Object data, boolean checkPrimary, List<String> columns) {
        if (null == data) {
            return 0L;
        }
        boolean isNew = this.checkIsNew(data);
        if (isNew) {
            return this.insert(runtime, random, dest, data, checkPrimary, columns);
        }
        Boolean override = this.checkOverride(data);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == override) return this.update(runtime, random, dest, data, null, columns);
        DefaultTablePrepare prepare = new DefaultTablePrepare(dest);
        Map<String, Object> pvs = this.checkPv(data);
        DefaultConfigStore stores = new DefaultConfigStore(new String[0]);
        for (String k : pvs.keySet()) {
            stores.and(k, pvs.get(k));
        }
        boolean exists = this.exists(runtime, random, (RunPrepare)prepare, (ConfigStore)stores, new String[0]);
        if (!exists) return this.insert(runtime, random, dest, data, checkPrimary, columns);
        if (override.booleanValue()) {
            return this.update(runtime, random, dest, data, null, columns);
        }
        log.warn("[\u8df3\u8fc7\u66f4\u65b0][\u6570\u636e\u5df2\u5b58\u5728:{}({})]", (Object)dest, (Object)BeanUtil.map2json(pvs));
        return 0L;
    }

    protected Boolean checkOverride(Object obj) {
        Boolean result = null;
        if (null != obj && obj instanceof DataRow) {
            result = ((DataRow)obj).getOverride();
        }
        return result;
    }

    protected Map<String, Object> checkPv(Object obj) {
        HashMap<String, Object> pvs = new HashMap<String, Object>();
        if (null != obj && obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            List ks = row.getPrimaryKeys();
            for (String k : ks) {
                pvs.put(k, row.get(k));
            }
        }
        return pvs;
    }

    protected boolean checkIsNew(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            return row.isNew();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return !BasicUtil.isNotEmpty(map.get(ConfigTable.DEFAULT_PRIMARY_KEY)) && !BasicUtil.isNotEmpty(map.get(ConfigTable.DEFAULT_PRIMARY_KEY.toLowerCase())) && !BasicUtil.isNotEmpty(map.get(ConfigTable.DEFAULT_PRIMARY_KEY.toUpperCase()));
        }
        Map values = EntityAdapterProxy.primaryValues((Object)obj);
        for (Map.Entry entry : values.entrySet()) {
            if (!BasicUtil.isNotEmpty(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        long result = -1L;
        boolean cmd_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareExecute((DataRuntime)runtime, (String)random, (RunPrepare)prepare, (ConfigStore)configs, (String[])conditions)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        Run run = this.buildExecuteRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign((boolean)false, (boolean)false, (String)prepare.getTable(), (ConfigStore)configs, (String[])conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeExecute((DataRuntime)runtime, (String)random, (Run)run);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeExecute(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.execute(runtime, random, configs, run);
        cmd_success = true;
        if (null != this.dmListener) {
            this.dmListener.afterExecute(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterExecute((DataRuntime)runtime, (String)random, (Run)run, (boolean)cmd_success, (long)result, (long)(System.currentTimeMillis() - fr));
        return result;
    }

    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, String sql, List<Object> values) {
        SimpleRun run = new SimpleRun();
        StringBuilder builder = run.getBuilder();
        builder.append(sql);
        run.setValues(values);
        Object first = values.get(0);
        if (first instanceof Collection) {
            ArrayList list = new ArrayList();
            for (Object object : values) {
                Collection col = (Collection)object;
                list.addAll(col);
            }
            run.setValues(list);
        }
        run.setBatch(batch);
        String[] strs = sql.split("");
        int vol = 0;
        for (String str : strs) {
            if (!str.equals("?")) continue;
            ++vol;
        }
        run.setVol(vol);
        long l = this.execute(runtime, random, configs, (Run)run);
        return l;
    }

    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        int result;
        block13: {
            result = -1;
            String sql = run.getFinalExecute();
            List values = run.getValues();
            long fr = System.currentTimeMillis();
            int batch = run.getBatch();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                if (batch > 1) {
                    log.info("{}[action:batch execute][sql:\n{}\n]\n[param size:{}]", new Object[]{random, sql, values.size()});
                } else {
                    log.info("{}[action:execute][sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
                }
            }
            if (null != configs) {
                configs.add(run);
            }
            long millis = -1L;
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (batch > 1) {
                    this.batch(jdbc, sql, batch, run.getVol(), values);
                    result = 0;
                } else {
                    result = null != values && values.size() > 0 ? jdbc.update(sql, values.toArray()) : jdbc.update(sql);
                }
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:execute][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.EXECUTE, run, sql, values, null, true, (Object)result, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:execute][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw e;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block13;
                log.error("{}[{}][action:execute][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"SQL\u6267\u884c\u5f02\u5e38:", (int)33) + e, sql, LogUtil.param((List)values)});
            }
        }
        return result;
    }

    public boolean execute(DataRuntime runtime, String random, final Procedure procedure) {
        boolean result;
        block11: {
            result = false;
            ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
            boolean cmd_success = false;
            List list = new ArrayList();
            final List inputs = procedure.getInputs();
            final List outputs = procedure.getOutputs();
            long fr = System.currentTimeMillis();
            String sql = " {";
            boolean returnIndex = false;
            if (procedure.hasReturn()) {
                sql = sql + "? = ";
                returnIndex = true;
            }
            sql = sql + "call " + procedure.getName() + "(";
            final int sizeIn = inputs.size();
            final int sizeOut = outputs.size();
            int size = sizeIn + sizeOut;
            for (int i = 0; i < size; ++i) {
                sql = sql + "?";
                if (i >= size - 1) continue;
                sql = sql + ",";
            }
            sql = sql + ")}";
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:procedure][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, sql, LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
            long millis = -1L;
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                list = (List)jdbc.execute(sql, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                    public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                        Parameter param;
                        int i;
                        ArrayList<Object> result = new ArrayList<Object>();
                        int returnIndex = 0;
                        if (procedure.hasReturn()) {
                            returnIndex = 1;
                            cs.registerOutParameter(1, 12);
                        }
                        for (i = 1; i <= sizeIn; ++i) {
                            param = (Parameter)inputs.get(i - 1);
                            Object value = param.getValue();
                            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                                value = null;
                            }
                            cs.setObject(i + returnIndex, value, (int)param.getType());
                        }
                        for (i = 1; i <= sizeOut; ++i) {
                            param = (Parameter)outputs.get(i - 1);
                            if (null == param.getValue()) {
                                cs.registerOutParameter(i + sizeIn + returnIndex, (int)param.getType());
                                continue;
                            }
                            cs.setObject(i + sizeIn + returnIndex, param.getValue(), (int)param.getType());
                        }
                        cs.execute();
                        if (procedure.hasReturn()) {
                            result.add(cs.getObject(1));
                        }
                        if (sizeOut > 0) {
                            for (i = 1; i <= sizeOut; ++i) {
                                Object output = cs.getObject(sizeIn + returnIndex + i);
                                result.add(output);
                            }
                        }
                        return result;
                    }
                });
                cmd_success = true;
                procedure.setResult(list);
                result = true;
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[slow cmd][action:procedure][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)inputs), LogUtil.param(list)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, sql, inputs, list, true, (Object)result, millis);
                    }
                }
                if (null != this.dmListener) {
                    this.dmListener.afterExecute(runtime, random, procedure, result, millis);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:procedure][\u6267\u884c\u8017\u65f6:{}ms]\n[output param:{}]", new Object[]{random, millis, list});
                }
            }
            catch (Exception e) {
                result = false;
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    SQLUpdateException ex = new SQLUpdateException("execute\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block11;
                log.error("{}[{}][action:procedure][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
        }
        return result;
    }

    public DataSet querys(DataRuntime runtime, String random, final Procedure procedure, final PageNavi navi) {
        DataSet set;
        block11: {
            set = null;
            final List inputs = procedure.getInputs();
            final List outputs = procedure.getOutputs();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:procedure][sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
            final String rdm = random;
            long millis = -1L;
            try {
                ACTION.SWITCH swt = InterceptorProxy.prepareQuery((DataRuntime)runtime, (String)random, (Procedure)procedure, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                swt = InterceptorProxy.beforeQuery((DataRuntime)runtime, (String)random, (Procedure)procedure, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, procedure);
                }
                final DataRuntime rt = runtime;
                JdbcTemplate jdbc = this.jdbc(runtime);
                long fr = System.currentTimeMillis();
                set = (DataSet)jdbc.execute(new CallableStatementCreator(){

                    public CallableStatement createCallableStatement(Connection conn) throws SQLException {
                        Parameter param;
                        int i;
                        String sql = "{call " + procedure.getName() + "(";
                        int sizeIn = inputs.size();
                        int sizeOut = outputs.size();
                        int size = sizeIn + sizeOut;
                        for (int i2 = 0; i2 < size; ++i2) {
                            sql = sql + "?";
                            if (i2 >= size - 1) continue;
                            sql = sql + ",";
                        }
                        sql = sql + ")}";
                        CallableStatement cs = conn.prepareCall(sql);
                        for (i = 1; i <= sizeIn; ++i) {
                            param = (Parameter)inputs.get(i - 1);
                            Object value = param.getValue();
                            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                                value = null;
                            }
                            cs.setObject(i, value, (int)param.getType());
                        }
                        for (i = 1; i <= sizeOut; ++i) {
                            param = (Parameter)outputs.get(i - 1);
                            if (null == param.getValue()) {
                                cs.registerOutParameter(i + sizeIn, (int)param.getType());
                                continue;
                            }
                            cs.setObject(i, param.getValue(), (int)param.getType());
                        }
                        return cs;
                    }
                }, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                    public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                        ResultSet rs = cs.executeQuery();
                        DataSet set = new DataSet();
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int cols = rsmd.getColumnCount();
                        for (int i = 1; i <= cols; ++i) {
                            set.addHead(rsmd.getColumnLabel(i));
                        }
                        long mid = System.currentTimeMillis();
                        int index = 0;
                        long first = -1L;
                        long last = -1L;
                        if (null != navi) {
                            first = navi.getFirstRow();
                            last = navi.getLastRow();
                        }
                        while (rs.next()) {
                            if (first == -1L || (long)index >= first && (long)index <= last) {
                                DataRow row = new DataRow();
                                for (int i = 1; i <= cols; ++i) {
                                    row.put(false, rsmd.getColumnLabel(i), rs.getObject(i));
                                }
                                set.addRow(row);
                            }
                            if (first == -1L || (long)(++index) <= last && (first != 0L || last != 0L)) continue;
                        }
                        if (null != navi) {
                            navi.setTotalRow((long)index);
                            set.setNavi(navi);
                        }
                        set.setDatalink(rt.datasource());
                        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                            log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{rdm, System.currentTimeMillis() - mid, set.size()});
                        }
                        return set;
                    }
                });
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check((String)runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[slow cmd][action:procedure][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, millis, procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, procedure.getName(), inputs, outputs, true, (Object)set, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[action:procedure][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)millis);
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block11;
                log.error("{}[{}][action:procedure][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
        }
        return set;
    }

    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        if (null == prepare) {
            prepare = new DefaultTablePrepare();
        }
        EntitySet<T> list = null;
        Long fr = System.currentTimeMillis();
        Run run = null;
        boolean cmd_success = false;
        PageNavi navi = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        swt = InterceptorProxy.prepareQuery((DataRuntime)runtime, (String)random, (RunPrepare)prepare, (ConfigStore)configs, (String[])conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        if (BasicUtil.isEmpty((Object)prepare.getDataSource()) && !(prepare instanceof TextPrepare) && !(prepare instanceof XMLPrepare)) {
            prepare.setDataSource(EntityAdapterProxy.table(clazz, (boolean)true));
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
            String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign((boolean)false, (boolean)false, (String)clazz.getName(), (ConfigStore)configs, (String[])conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn(tmp);
        }
        navi = run.getPageNavi();
        long total = 0L;
        if (run.isValid()) {
            if (null != navi) {
                if (null != this.dmListener) {
                    this.dmListener.beforeTotal(runtime, random, run);
                }
                fr = System.currentTimeMillis();
                if (navi.getCalType() == 1 && navi.getLastRow() == 0L) {
                    total = 1L;
                } else if (navi.getTotalRow() == 0L) {
                    total = this.count(runtime, random, run);
                    navi.setTotalRow(total);
                } else {
                    total = navi.getTotalRow();
                }
                if (null != this.dmListener) {
                    this.dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
            }
        }
        fr = System.currentTimeMillis();
        if (run.isValid()) {
            if (null == navi || total > 0L) {
                swt = InterceptorProxy.beforeQuery((DataRuntime)runtime, (String)random, (Run)run, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new EntitySet();
                }
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, run, total);
                }
                fr = System.currentTimeMillis();
                list = this.select(runtime, random, clazz, run.getTable(), configs, run);
                cmd_success = false;
            } else {
                list = new EntitySet();
            }
        } else {
            list = new EntitySet<T>();
        }
        list.setNavi(navi);
        if (null != navi && navi.isLazy()) {
            PageLazyStore.setTotal((String)navi.getLazyKey(), (long)navi.getTotalRow());
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, (EntitySet)list, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery((DataRuntime)runtime, (String)random, (Run)run, (boolean)cmd_success, (Object)list, (PageNavi)navi, (long)(System.currentTimeMillis() - fr));
        return list;
    }

    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, String table, ConfigStore configs, Run run) {
        EntitySet set = new EntitySet();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null != configs) {
            configs.entityClass(clazz);
        }
        DataSet rows = this.select(runtime, random, false, table, configs, run);
        for (DataRow row : rows) {
            Object entity = null;
            entity = EntityAdapterProxy.hasAdapter(clazz) ? EntityAdapterProxy.entity(clazz, (Map)row, null) : row.entity(clazz, new String[0]);
            set.add(entity);
        }
        return set;
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, String table, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, key, values);
    }

    public long delete(DataRuntime runtime, String random, String dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    public long truncate(DataRuntime runtime, String random, String table) {
        List runs = this.buildTruncateRun(runtime, table = DataSourceUtil.parseDataSource((String)table));
        if (null != runs && runs.size() > 0) {
            DefaultTextPrepare prepare = new DefaultTextPrepare(((Run)runs.get(0)).getFinalUpdate());
            return (int)this.execute(runtime, random, (RunPrepare)prepare, null, new String[0]);
        }
        return -1L;
    }

    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        if (null != run && run instanceof TableRun) {
            TableRun r = (TableRun)run;
            this.fillDeleteRunContent(runtime, r);
        }
    }

    protected void fillDeleteRunContent(DataRuntime runtime, TableRun run) {
        List joins;
        AutoPrepare prepare = (AutoPrepare)run.getPrepare();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        if (null != run.getSchema()) {
            SQLUtil.delimiter((StringBuilder)builder, (String)run.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)run.getTable(), (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)prepare.getAlias())) {
            builder.append("  ").append(prepare.getAlias());
        }
        if (null != (joins = prepare.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                if (null != join.getSchema()) {
                    SQLUtil.delimiter((StringBuilder)builder, (String)join.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)join.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                if (BasicUtil.isNotEmpty((Object)join.getAlias())) {
                    builder.append("  ").append(join.getAlias());
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        builder.append("\nWHERE 1=1\n\t");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result = -1L;
        boolean cmd_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        swt = InterceptorProxy.beforeDelete((DataRuntime)runtime, (String)random, (Run)run);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeDelete(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        long millis = -1L;
        result = this.execute(runtime, random, configs, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterDelete(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterDelete((DataRuntime)runtime, (String)random, (Run)run, (boolean)cmd_success, (long)result, (long)millis);
        return result;
    }

    public Database database(DataRuntime runtime, String random, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        Database database = null;
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List runs = this.buildQueryDatabaseRun(runtime, name);
                    if (null != runs) {
                        Run run;
                        DataSet set;
                        int idx = 0;
                        Iterator iterator = runs.iterator();
                        while (iterator.hasNext() && null == (database = this.database(runtime, idx++, true, set = this.select(runtime, random, true, null, null, run = (Run)iterator.next()).toUpperKey()))) {
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[database][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[database][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, database, System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[database][result:fail][msg:{}]", (Object)e.toString());
        }
        return database;
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap databases = new LinkedHashMap();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List runs = this.buildQueryDatabaseRun(runtime);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, null, run).toUpperKey();
                            databases = this.databases(runtime, idx++, true, databases, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, databases.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
        }
        return databases;
    }

    private void tableMap(DataRuntime runtime, boolean greedy, String random, String catalog, String schema) {
        Map names = CacheProxy.names((String)catalog, (String)schema);
        if (null == names || names.isEmpty()) {
            if (null == random) {
                random = this.random(runtime);
            }
            DriverAdapter adapter = runtime.getAdapter();
            LinkedHashMap<Object, Object> tables = new LinkedHashMap();
            boolean sys = false;
            try {
                List runs = this.buildQueryTableRun(runtime, greedy, null, null, null, null);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                        tables = this.tables(runtime, idx++, true, catalog, schema, (LinkedHashMap)null, set);
                        CacheProxy.name(tables);
                        sys = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!sys) {
                try {
                    tables = this.tables(runtime, true, (LinkedHashMap)null, catalog, schema, null, null);
                    CacheProxy.name(tables);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String pattern, String types, boolean strut) {
        List list = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String origin;
            long fr;
            block34: {
                String[] tps;
                block33: {
                    fr = System.currentTimeMillis();
                    Table search = new Table();
                    if (null == catalog || null == schema) {
                        Table tmp = new Table();
                        if (!greedy) {
                            this.checkSchema(runtime, tmp);
                        }
                        if (null == catalog) {
                            catalog = tmp.getCatalog();
                        }
                        if (null == schema) {
                            schema = tmp.getSchema();
                        }
                    }
                    if (null == (origin = CacheProxy.name((boolean)greedy, (String)catalog, (String)schema, (String)pattern)) && ConfigTable.IS_METADATA_IGNORE_CASE) {
                        this.tableMap(runtime, greedy, random, catalog, schema);
                        origin = CacheProxy.name((boolean)greedy, (String)catalog, (String)schema, (String)pattern);
                    }
                    if (null == origin) {
                        origin = pattern;
                    }
                    search.setName(origin);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    tps = null;
                    if (null != types) {
                        tps = types.toUpperCase().trim().split(",");
                    }
                    try {
                        List runs = this.buildQueryTableRun(runtime, greedy, catalog, schema, origin, types);
                        if (null != runs) {
                            int idx = 0;
                            for (Object run : runs) {
                                DataSet set = this.select(runtime, random, true, (String)null, null, (Run)run).toUpperKey();
                                list = this.tables(runtime, idx++, true, catalog, schema, list, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block33;
                        log.warn("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                if (list.size() == 0) {
                    try {
                        list = this.tables(runtime, true, list, catalog, schema, origin, tps);
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[tables][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                boolean comment = false;
                for (Table table : list) {
                    if (!BasicUtil.isNotEmpty((Object)table.getComment())) continue;
                    comment = true;
                    break;
                }
                if (!comment) {
                    try {
                        List runs = this.buildQueryTableCommentRun(runtime, catalog, schema, null, types);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                                list = this.comments(runtime, idx++, true, catalog, schema, list, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block34;
                        log.info("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[tables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, origin, types, list.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)origin)) {
                ArrayList<Table> tmp = new ArrayList<Table>();
                for (Table item : list) {
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)origin)) continue;
                    tmp.add(item);
                }
                list = tmp;
            }
            if (strut) {
                List<T> columns = this.columns(runtime, random, greedy, catalog, schema, pattern);
                for (Table table : list) {
                    String tName = table.getName();
                    String tCatalog = table.getCatalog();
                    String tSchema = table.getSchema();
                    LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
                    table.setColumns(cols);
                    for (Column column : columns) {
                        if (!tName.equalsIgnoreCase(column.getTableName(false))) continue;
                        String cCatalog = column.getCatalog();
                        String cSchema = column.getSchema();
                        if ((null != cCatalog || null != tCatalog) && (null == cCatalog || !cCatalog.equalsIgnoreCase(tCatalog)) || (null != cSchema || null != tSchema) && (null == cSchema || !cSchema.equalsIgnoreCase(tSchema))) continue;
                        cols.put(column.getName().toUpperCase(), column);
                    }
                    columns.removeAll(cols.values());
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[tables][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    private <T extends Table> boolean contains(List<T> tables, T table) {
        boolean contains = false;
        if (null != table && null != tables) {
            for (Table tab : tables) {
                if (tab.getCatalog() != table.getCatalog() || tab.getSchema() != table.getSchema() || !table.getName().equalsIgnoreCase(tab.getName())) continue;
                return true;
            }
        }
        return contains;
    }

    private <T extends Table> List<T> merge(List<T> tables, LinkedHashMap<String, T> maps) {
        boolean contains = false;
        if (null != tables && null != maps) {
            for (Table table : maps.values()) {
                if (this.contains(tables, table)) continue;
                tables.add(table);
            }
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, String catalog, String schema, String pattern, String types, boolean strut) {
        LinkedHashMap<String, Table> tables = new LinkedHashMap<String, Table>();
        List list = this.tables(runtime, random, false, catalog, schema, pattern, types);
        for (Table table : list) {
            tables.put(table.getName().toUpperCase(), table);
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        DataSource ds = null;
        Connection con = null;
        try {
            JdbcTemplate jdbc = this.jdbc(runtime);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet set = dbmd.getTables(catalog, schema, pattern, types);
            if (null == tables) {
                tables = new LinkedHashMap();
            }
            Map keys = this.keys(set);
            while (set.next()) {
                String tableName = this.string(keys, "TABLE_NAME", set);
                if (BasicUtil.isEmpty((Object)tableName)) {
                    tableName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)tableName)) continue;
                Table table = (Table)tables.get(tableName.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new Table();
                    tables.put(tableName.toUpperCase(), table);
                }
                table.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
                table.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), schema}));
                table.setName(tableName);
                table.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), table.getType()}));
                table.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), table.getComment()}));
                table.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), table.getTypeCat()}));
                table.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), table.getTypeName()}));
                table.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), table.getSelfReferencingColumn()}));
                table.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), table.getRefGeneration()}));
                tables.put(tableName.toUpperCase(), table);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        DataSource ds = null;
        Connection con = null;
        try {
            JdbcTemplate jdbc = this.jdbc(runtime);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet set = dbmd.getTables(catalog, schema, pattern, types);
            if (null == tables) {
                tables = new ArrayList<T>();
            }
            Map keys = this.keys(set);
            while (set.next()) {
                String tableName = this.string(keys, "TABLE_NAME", set);
                if (BasicUtil.isEmpty((Object)tableName)) {
                    tableName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)tableName)) continue;
                catalog = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CATALOG", set), this.string(keys, "TABLE_CAT", set), catalog});
                schema = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), schema});
                Table table = this.table(tables, catalog, schema, tableName);
                boolean contains = true;
                if (null == table) {
                    if (!create) continue;
                    table = new Table();
                    contains = false;
                }
                table.setCatalog(catalog);
                table.setSchema(schema);
                table.setName(tableName);
                table.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), table.getType()}));
                table.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), table.getComment()}));
                table.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), table.getTypeCat()}));
                table.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), table.getTypeName()}));
                table.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), table.getSelfReferencingColumn()}));
                table.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), table.getRefGeneration()}));
                if (contains) continue;
                tables.add(table);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name;
            Table table;
            String _catalog = row.getString("TABLE_CATALOG");
            String _schema = row.getString(new String[]{"TABLE_SCHEMA", "TABSCHEMA", "SCHEMA_NAME"});
            if (null == _catalog) {
                _catalog = catalog;
            }
            if (null == _schema) {
                _schema = schema;
            }
            if (null == (table = (Table)tables.get((name = row.getString(new String[]{"TABLE_NAME", "NAME", "TABNAME"})).toUpperCase()))) {
                table = new Table();
            }
            table.setCatalog(_catalog);
            table.setSchema(_schema);
            table.setName(name);
            table.setEngine(row.getString("ENGINE"));
            table.setComment(row.getString(new String[]{"TABLE_COMMENT", "COMMENTS", "COMMENT"}));
            tables.put(name.toUpperCase(), table);
        }
        return tables;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String name;
            Table table;
            String _catalog = row.getString("TABLE_CATALOG");
            String _schema = row.getString(new String[]{"TABLE_SCHEMA", "TABSCHEMA", "SCHEMA_NAME"});
            if (null == _catalog) {
                _catalog = catalog;
            }
            if (null == _schema) {
                _schema = schema;
            }
            if (null == (table = this.table(tables, _catalog, _schema, name = row.getString(new String[]{"TABLE_NAME", "NAME", "TABNAME"})))) {
                table = new Table();
            }
            table.setCatalog(_catalog);
            table.setSchema(_schema);
            table.setName(name);
            table.setEngine(row.getString("ENGINE"));
            table.setComment(row.getString(new String[]{"TABLE_COMMENT", "COMMENTS"}));
            tables.add(table);
        }
        return tables;
    }

    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        List<String> list;
        block11: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List runs = this.buildQueryDDLRun(runtime, table);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, null, run).toUpperKey();
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                } else {
                    LinkedHashMap columns = this.columns(runtime, random, false, table, true);
                    table.setColumns(columns);
                    table.setTags(this.tags(runtime, random, false, table));
                    PrimaryKey pk = this.primary(runtime, random, false, table);
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.setPrimaryKey(Boolean.valueOf(true));
                        }
                    }
                    table.setPrimaryKey(pk);
                    table.setIndexs(this.indexs(runtime, random, false, table, null));
                    runs = this.buildCreateRun(runtime, table);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        table.setDdls(list);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block11;
                log.info("{}[table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<Object, Object> views = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            LinkedHashMap<String, Object> tmps;
            String[] tps;
            long fr;
            block25: {
                fr = System.currentTimeMillis();
                View search = new View();
                if (null == catalog || null == schema) {
                    View tmp = new View();
                    if (!greedy) {
                        this.checkSchema(runtime, (Table)tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                search.setName(pattern);
                search.setCatalog(catalog);
                search.setSchema(schema);
                tps = null;
                tps = null != types ? types.toUpperCase().trim().split(",") : new String[]{"VIEW"};
                DataRow view_map = CacheProxy.getViewMaps((String)runtime.datasource());
                if (null != pattern) {
                    if (view_map.isEmpty()) {
                        LinkedHashMap<String, T> all = this.views(runtime, random, greedy, catalog, schema, null, types);
                        if (!greedy) {
                            for (View view : all.values()) {
                                if (!(catalog + "_" + schema).equals(view.getCatalog() + "_" + view.getSchema())) continue;
                                view_map.put(view.getName(greedy).toUpperCase(), (Object)view.getName(greedy));
                            }
                        }
                    }
                    pattern = view_map.containsKey(search.getName(greedy).toUpperCase()) ? view_map.getString(search.getName(greedy).toUpperCase()) : search.getName(greedy);
                }
                try {
                    List runs = this.buildQueryViewRun(runtime, greedy, catalog, schema, pattern, types);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                            views = this.views(runtime, idx++, true, catalog, schema, views, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block25;
                    log.warn("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (null == views || views.size() == 0) {
                try {
                    tmps = this.views(runtime, true, null, catalog, schema, pattern, tps);
                    for (String key : tmps.keySet()) {
                        View item;
                        if (views.containsKey(key.toUpperCase()) || null == (item = (View)tmps.get(key)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                        views.put(key.toUpperCase(), item);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[views][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[views][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, views.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                tmps = new LinkedHashMap();
                List keys = BeanUtil.getMapKeys(views);
                for (String key : keys) {
                    View item = (View)views.get(key);
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)pattern)) continue;
                    tmps.put(name.toUpperCase(), item);
                }
                views = tmps;
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[views][result:fail][msg:{}]", (Object)e.toString());
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, String catalog, String schema, String pattern, String ... types) throws Exception {
        DataSource ds = null;
        Connection con = null;
        try {
            JdbcTemplate jdbc = this.jdbc(runtime);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet set = dbmd.getTables(catalog, schema, pattern, new String[]{"VIEW"});
            if (null == views) {
                views = new LinkedHashMap();
            }
            Map keys = this.keys(set);
            while (set.next()) {
                String viewName = this.string(keys, "TABLE_NAME", set);
                if (BasicUtil.isEmpty((Object)viewName)) {
                    viewName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)viewName)) continue;
                View view = (View)views.get(viewName.toUpperCase());
                if (null == view) {
                    if (!create) continue;
                    view = new View();
                    views.put(viewName.toUpperCase(), view);
                }
                view.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
                view.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), schema}));
                view.setName(viewName);
                view.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), view.getType()}));
                view.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), view.getComment()}));
                view.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), view.getTypeCat()}));
                view.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), view.getTypeName()}));
                view.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), view.getSelfReferencingColumn()}));
                view.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), view.getRefGeneration()}));
                views.put(viewName.toUpperCase(), view);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return views;
    }

    public List<String> ddl(DataRuntime runtime, String random, View view) {
        List<String> list;
        block7: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List runs = this.buildQueryDDLRun(runtime, view);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, null, run).toUpperKey();
                        list = this.ddl(runtime, idx++, view, list, set);
                    }
                    view.setDdls(list);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[view ddl][view:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, view.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block7;
                log.info("{}[view ddl][{}][view:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u89c6\u56fe\u521b\u5efaDDL\u5931\u8d25", (int)33), view.getName(), e.toString()});
            }
        }
        return list;
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap tables = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String[] tps;
            long fr;
            block24: {
                fr = System.currentTimeMillis();
                if (null == catalog || null == schema) {
                    Table tmp = new Table();
                    if (!greedy) {
                        this.checkSchema(runtime, tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                tps = null;
                if (null != types) {
                    tps = types.toUpperCase().trim().split(",");
                }
                DataRow table_map = CacheProxy.getTableMaps((String)runtime.datasource());
                if (null != pattern) {
                    if (table_map.isEmpty()) {
                        LinkedHashMap<String, T> all = this.mtables(runtime, random, greedy, catalog, schema, null, types);
                        for (Table table : all.values()) {
                            table_map.put(table.getName().toUpperCase(), (Object)table.getName());
                        }
                    }
                    if (table_map.containsKey(pattern.toUpperCase())) {
                        pattern = table_map.getString(pattern.toUpperCase());
                    }
                }
                try {
                    List runs = this.buildQueryMasterTableRun(runtime, catalog, schema, pattern, types);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                            tables = this.mtables(runtime, idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block24;
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (null == tables || tables.size() == 0) {
                try {
                    LinkedHashMap tmps = this.mtables(runtime, true, null, catalog, schema, pattern, tps);
                    for (String key : tmps.keySet()) {
                        MasterTable item;
                        if (tables.containsKey(key.toUpperCase()) || null == (item = (MasterTable)tmps.get(key)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                        tables.put(key.toUpperCase(), item);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[stables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[mtables][result:fail][msg:{}]", (Object)e.toString());
        }
        return tables;
    }

    public List<String> ddl(DataRuntime runtime, String random, MasterTable table) {
        List<String> list;
        block7: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List runs = this.buildQueryDDLRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, null, run).toUpperKey();
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[master table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block7;
                log.info("{}[master table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u4e3b\u8868\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchema(DataRuntime runtime, DataSource dataSource, Table table) {
        if (null == table || null != table.getCheckSchemaTime()) {
            return;
        }
        Connection con = null;
        try {
            if (null == table.getCatalog() || null == table.getSchema()) {
                con = DataSourceUtils.getConnection((DataSource)dataSource);
                this.checkSchema(runtime, con, table);
            }
        }
        catch (Exception e) {
            log.warn("[check schema][fail:{}]", (Object)e.toString());
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)dataSource)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
            }
        }
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String name) {
        LinkedHashMap tables = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List runs = this.buildQueryPartitionTableRun(runtime, master, tags, name);
                    if (null != runs) {
                        int idx = 0;
                        int total = runs.size();
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, false, (String)null, null, run).toUpperKey();
                            tables = this.ptables(runtime, total, idx++, true, master, master.getCatalog(), master.getSchema(), tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[tables][{}][stable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), master.getName(), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[tables][stable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, master.getName(), tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[ptables][result:fail][msg:{}]", (Object)e.toString());
        }
        return tables;
    }

    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        List<String> list;
        block7: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List runs = this.buildQueryDDLRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, null, run).toUpperKey();
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[partition table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block7;
                log.info("{}[partition table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5b50\u8868\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table) {
        LinkedHashMap tags;
        block17: {
            if (null == table || BasicUtil.isEmpty((Object)table.getName())) {
                return new LinkedHashMap();
            }
            tags = CacheProxy.tags((String)runtime.getKey(), (Table)table);
            if (null != tags && !tags.isEmpty()) {
                return tags;
            }
            long fr = System.currentTimeMillis();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                String schema;
                String catalog;
                block16: {
                    block15: {
                        if (!greedy) {
                            this.checkSchema(runtime, table);
                        }
                        catalog = table.getCatalog();
                        schema = table.getSchema();
                        try {
                            List runs = this.buildQueryTagRun(runtime, table, false);
                            if (null != runs) {
                                int idx = 0;
                                for (Run run : runs) {
                                    DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                                    tags = this.tags(runtime, idx, true, table, tags, set);
                                    ++idx;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                e.printStackTrace();
                            }
                            if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block15;
                            log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                        }
                    }
                    if (null == tags || tags.size() == 0) {
                        try {
                            tags = this.tags(runtime, false, tags, table, null);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block16;
                            e.printStackTrace();
                        }
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[tags][catalog:{}][schema:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block17;
                e.printStackTrace();
            }
        }
        CacheProxy.tags((String)runtime.getKey(), (Table)table, (LinkedHashMap)tags);
        return tags;
    }

    public void checkSchema(DataRuntime runtime, Connection con, Table table) {
        try {
            if (null == table.getCatalog()) {
                table.setCatalog(con.getCatalog());
            }
            if (null == table.getSchema()) {
                table.setSchema(con.getSchema());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        table.setCheckSchemaTime(new Date());
    }

    public void checkSchema(DataRuntime runtime, Table table) {
        JdbcTemplate jdbc = this.jdbc(runtime);
        this.checkSchema(runtime, jdbc.getDataSource(), table);
    }

    @Override
    public Column column(DataRuntime runtime, Column column, SqlRowSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
            try {
                column.setCatalog((String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)}));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getCatalogName]");
            }
            try {
                column.setSchema((String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)}));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getSchemaName]");
            }
            try {
                column.setClassName(rsm.getColumnClassName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnClassName]");
            }
            try {
                column.setCurrency(Boolean.valueOf(rsm.isCurrency(index)));
            }
            catch (Exception e) {
                column.setCaseSensitive(Boolean.valueOf(rsm.isCaseSensitive(index)));
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCurrency]");
            }
            try {
                column.setOriginalName(rsm.getColumnName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnName]");
            }
            try {
                column.setName(rsm.getColumnLabel(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnLabel]");
            }
            try {
                column.setPrecision(Integer.valueOf(rsm.getPrecision(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getPrecision]");
            }
            try {
                column.setScale(Integer.valueOf(rsm.getScale(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getScale]");
            }
            try {
                column.setDisplaySize(Integer.valueOf(rsm.getColumnDisplaySize(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnDisplaySize]");
            }
            try {
                column.setSigned(Boolean.valueOf(rsm.isSigned(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isSigned]");
            }
            try {
                column.setTable(rsm.getTableName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getTableName]");
            }
            try {
                column.setType(Integer.valueOf(rsm.getColumnType(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnType]");
            }
            try {
                String jdbcType = rsm.getColumnTypeName(index);
                column.setJdbcType(jdbcType);
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnTypeName]");
            }
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        return column;
    }

    public Column column(DataRuntime runtime, Column column, ResultSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
        }
        try {
            column.setCatalog((String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)}));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getCatalogName]");
        }
        try {
            column.setSchema((String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)}));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getSchemaName]");
        }
        try {
            column.setClassName(rsm.getColumnClassName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnClassName]");
        }
        try {
            column.setCaseSensitive(Boolean.valueOf(rsm.isCaseSensitive(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCaseSensitive]");
        }
        try {
            column.setCurrency(Boolean.valueOf(rsm.isCurrency(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCurrency]");
        }
        try {
            column.setOriginalName(rsm.getColumnName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnName]");
        }
        try {
            column.setName(rsm.getColumnLabel(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnLabel]");
        }
        try {
            column.setPrecision(Integer.valueOf(rsm.getPrecision(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getPrecision]");
        }
        try {
            column.setScale(Integer.valueOf(rsm.getScale(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getScale]");
        }
        try {
            column.setDisplaySize(Integer.valueOf(rsm.getColumnDisplaySize(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnDisplaySize]");
        }
        try {
            column.setSigned(Boolean.valueOf(rsm.isSigned(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isSigned]");
        }
        try {
            column.setTable(rsm.getTableName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getTableName]");
        }
        try {
            column.setType(Integer.valueOf(rsm.getColumnType(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnType]");
        }
        try {
            String jdbcType = rsm.getColumnTypeName(index);
            column.setJdbcType(jdbcType);
            if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                column.setTypeName(jdbcType);
            }
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnTypeName]");
        }
        ColumnType columnType = this.type(column.getTypeName());
        column.setColumnType(columnType);
        return column;
    }

    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String catalog = null;
        String schema = null;
        String name = null;
        if (null != table) {
            name = table.getName();
            catalog = table.getCatalog();
            schema = table.getSchema();
        }
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, table);
            builder.append(" WHERE 1=0");
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString(new String[]{"COLUMN_NAME", "COLNAME"});
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                column = new Column();
            }
            column.setName(name);
            this.init(column, table, row);
            columns.put(name.toUpperCase(), column);
        }
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String name = row.getString(new String[]{"COLUMN_NAME", "COLNAME"});
            Column column = new Column();
            column.setName(name);
            this.init(column, table, row);
            columns.add(column);
        }
        return columns;
    }

    protected void init(Column column, Table table, DataRow row) {
        String column_key;
        column.setCatalog((String)BasicUtil.evl((Object[])new String[]{row.getString("TABLE_CATALOG"), table.getCatalog(), column.getCatalog()}));
        column.setSchema((String)BasicUtil.evl((Object[])new String[]{row.getString(new String[]{"TABLE_SCHEMA", "TABSCHEMA", "SCHEMA_NAME", "OWNER"}), table.getSchema(), column.getSchema()}));
        if (null != table.getName()) {
            column.setTable(table);
        }
        column.setTable((String)BasicUtil.evl((Object[])new String[]{row.getString(new String[]{"TABLE_NAME", "TABNAME"}), table.getName(), column.getTableName(true)}));
        if (null == column.getPosition()) {
            try {
                column.setPosition(row.getInt(new String[]{"ORDINAL_POSITION", "COLNO", "POSITION"}));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        column.setComment((String)BasicUtil.evl((Object[])new String[]{row.getString(new String[]{"COLUMN_COMMENT", "COMMENTS", "REMARKS"}), column.getComment()}));
        column.setTypeName((String)BasicUtil.evl((Object[])new String[]{row.getString(new String[]{"DATA_TYPE", "TYPENAME", "DATA_TYPE_NAME"}), column.getTypeName()}));
        String def = BasicUtil.evl((Object[])new Object[]{row.get(new String[]{"COLUMN_DEFAULT", "DATA_DEFAULT", "DEFAULT", "DEFAULT_VALUE"}), column.getDefaultValue()}) + "";
        if (BasicUtil.isNotEmpty((Object)def)) {
            while (def.startsWith("(") && def.endsWith(")")) {
                def = def.substring(1, def.length() - 1);
            }
            column.setDefaultValue((Object)def);
        }
        if (-1 == column.isAutoIncrement()) {
            column.setAutoIncrement(row.getBoolean("IS_IDENTITY", null));
        }
        if (-1 == column.isAutoIncrement()) {
            column.setAutoIncrement(row.getBoolean("IS_AUTOINCREMENT", null));
        }
        if (-1 == column.isAutoIncrement()) {
            column.setAutoIncrement(row.getBoolean("IDENTITY", null));
        }
        if (-1 == column.isAutoIncrement() && row.getStringNvl("EXTRA", new String[0]).toLowerCase().contains("auto_increment")) {
            column.setAutoIncrement(Boolean.valueOf(true));
        }
        if ("PRI".equals(column_key = row.getString("COLUMN_KEY"))) {
            column.setPrimaryKey(1);
        }
        if (-1 == column.isNullable()) {
            try {
                column.setNullable(row.getBoolean(new String[]{"IS_NULLABLE", "NULLABLE", "NULLS"}));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            Integer len = row.getInt(new String[]{"NUMERIC_PRECISION", "PRECISION", "DATA_PRECISION"});
            if (null == len) {
                len = row.getInt(new String[]{"CHARACTER_MAXIMUM_LENGTH", "MAX_LENGTH", "DATA_LENGTH", "LENGTH"});
            }
            column.setPrecision(len);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (null == column.getScale()) {
                column.setScale(row.getInt(new String[]{"NUMERIC_SCALE", "SCALE", "DATA_SCALE"}));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == column.getCharset()) {
            column.setCharset(row.getString("CHARACTER_SET_NAME"));
        }
        if (null == column.getCollate()) {
            column.setCollate(row.getString("COLLATION_NAME"));
        }
        if (null == column.getColumnType()) {
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean create, Table table, LinkedHashMap<String, T> columns, List<Run> runs) {
        block5: {
            try {
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, (String)null, null, run);
                        columns = this.columns(runtime, idx, true, table, columns, set);
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block5;
                log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), table.getCatalog(), table.getSchema(), table.getName(), e.toString()});
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        LinkedHashMap columns = CacheProxy.columns((String)runtime.getKey(), (Table)table);
        if (null != columns && !columns.isEmpty()) {
            return columns;
        }
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            List<Run> runs;
            int qty_jdbc;
            int qty_metadata;
            int qty_dialect;
            int qty_total;
            block35: {
                qty_total = 0;
                qty_dialect = 0;
                qty_metadata = 0;
                qty_jdbc = 0;
                try {
                    runs = this.buildQueryColumnRun(runtime, table, false);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, (String)null, null, run);
                            columns = this.columns(runtime, idx, true, table, columns, set);
                            ++idx;
                        }
                    }
                    if (null != columns) {
                        qty_dialect = columns.size();
                        qty_total = columns.size();
                    }
                }
                catch (Exception e) {
                    if (primary) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block35;
                    log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                }
            }
            if (null == columns || columns.size() == 0) {
                block36: {
                    try {
                        runs = this.buildQueryColumnRun(runtime, table, true);
                        if (null != runs) {
                            for (Run run : runs) {
                                SqlRowSet set = ((JDBCRuntime)runtime).jdbc().queryForRowSet(run.getFinalQuery());
                                columns = this.columns(runtime, true, columns, table, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block36;
                        log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                    }
                }
                if (null != columns) {
                    qty_metadata = columns.size() - qty_dialect;
                    qty_total = columns.size();
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, qty_total, qty_metadata, qty_dialect, qty_jdbc, System.currentTimeMillis() - fr});
            }
            if (null == columns || columns.size() == 0) {
                DataSource ds = null;
                Connection con = null;
                DatabaseMetaData metadata = null;
                try {
                    ds = ((JDBCRuntime)runtime).jdbc().getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    metadata = con.getMetaData();
                    columns = this.columns(runtime, true, columns, metadata, table, null);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                        DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                    }
                }
                if (null != columns) {
                    qty_total = columns.size();
                    qty_jdbc = columns.size() - qty_metadata - qty_dialect;
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, qty_total, qty_metadata, qty_dialect, qty_jdbc, System.currentTimeMillis() - fr});
            }
            if (ConfigTable.IS_METADATA_AUTO_CHECK_COLUMN_PRIMARY && (null != columns || columns.size() > 0)) {
                LinkedHashMap pks;
                PrimaryKey pk;
                boolean exists = false;
                for (Column column : columns.values()) {
                    if (column.isPrimaryKey() == -1) continue;
                    exists = true;
                    break;
                }
                if (!exists && null != (pk = this.primary(runtime, random, false, table)) && null != (pks = pk.getColumns())) {
                    for (String k : pks.keySet()) {
                        Column column = (Column)columns.get(k);
                        if (null == column) continue;
                        column.setPrimaryKey(Boolean.valueOf(true));
                    }
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[columns][result:fail][table:{}][msg:{}]", new Object[]{random, table, e.toString()});
        }
        if (null != columns) {
            CacheProxy.columns((String)runtime.getKey(), (Table)table, columns);
        } else {
            columns = new LinkedHashMap();
        }
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String table) {
        List columns = new ArrayList();
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        Table tab = new Table(table);
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        try {
            List<Run> runs = this.buildQueryColumnRun(runtime, tab, false);
            if (null != runs) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.select(runtime, random, true, (String)null, null, run);
                    columns = this.columns(runtime, idx, true, tab, columns, set);
                    ++idx;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        SqlRowSetMetaData rsm = set.getMetaData();
        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
            Column column;
            String name = rsm.getColumnName(i);
            if (BasicUtil.isEmpty((Object)name) || null != (column = (Column)columns.get(name.toUpperCase())) || !create) continue;
            if (BasicUtil.isEmpty((Object)(column = this.column(runtime, column, rsm, i)).getName())) {
                column.setName(name);
            }
            columns.put(column.getName().toUpperCase(), column);
        }
        return columns;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        if (BasicUtil.isEmpty((Object)table.getName())) {
            return columns;
        }
        ResultSet set = dbmd.getColumns(catalog, schema, table.getName(), pattern);
        Map keys = this.keys(set);
        while (set.next()) {
            String remark;
            String name = set.getString("COLUMN_NAME");
            if (null == name) continue;
            String columnCatalog = this.string(keys, "TABLE_CAT", set, null);
            String columnSchema = this.string(keys, "TABLE_SCHEM", set, null);
            if (!BasicUtil.equalsIgnoreCase((Object)catalog, (Object)columnCatalog) || !BasicUtil.equalsIgnoreCase((Object)schema, (Object)columnSchema)) continue;
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                if (!create) continue;
                column = new Column(name);
                columns.put(name.toUpperCase(), column);
            }
            if ("TAG".equals(remark = this.string(keys, "REMARKS", set, column.getComment()))) {
                column = new Tag();
            }
            column.setCatalog(columnCatalog);
            column.setSchema(columnSchema);
            column.setComment(remark);
            column.setTable((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_NAME", set, table.getName()), column.getTableName(true)}));
            column.setType(this.integer(keys, "DATA_TYPE", set, column.getType()));
            column.setType(this.integer(keys, "SQL_DATA_TYPE", set, column.getType()));
            String jdbcType = this.string(keys, "TYPE_NAME", set, column.getTypeName());
            if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                column.setTypeName(jdbcType);
            }
            column.setJdbcType(jdbcType);
            column.setPrecision(this.integer(keys, "COLUMN_SIZE", set, column.getPrecision()));
            column.setScale(this.integer(keys, "DECIMAL_DIGITS", set, column.getScale()));
            column.setNullable(this.bool(keys, "NULLABLE", set, column.isNullable()));
            column.setDefaultValue(this.value(keys, "COLUMN_DEF", set, column.getDefaultValue()));
            column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, column.getPosition()));
            column.setAutoIncrement(this.bool(keys, "IS_AUTOINCREMENT", set, column.isAutoIncrement()));
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
            this.column(runtime, column, set);
            column.setName(name);
        }
        ResultSet rs = dbmd.getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());
        while (rs.next()) {
            String name = rs.getString(4);
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) continue;
            column.setPrimaryKey(Boolean.valueOf(true));
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        DataSource ds = null;
        Connection con = null;
        try {
            JdbcTemplate jdbc = this.jdbc(runtime);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet set = dbmd.getColumns(catalog, schema, table.getName(), pattern);
            Map keys = this.keys(set);
            while (set.next()) {
                String remark;
                String name = set.getString("COLUMN_NAME");
                if (null == name) continue;
                String columnCatalog = this.string(keys, "TABLE_CAT", set, null);
                String columnSchema = this.string(keys, "TABLE_SCHEM", set, null);
                if (!BasicUtil.equalsIgnoreCase((Object)catalog, (Object)columnCatalog) || !BasicUtil.equalsIgnoreCase((Object)schema, (Object)columnSchema)) continue;
                Column column = (Column)columns.get(name.toUpperCase());
                if (null == column) {
                    if (!create) continue;
                    column = new Column(name);
                    columns.put(name.toUpperCase(), column);
                }
                if ("TAG".equals(remark = this.string(keys, "REMARKS", set, column.getComment()))) {
                    column = new Tag();
                }
                column.setCatalog(columnCatalog);
                column.setSchema(columnSchema);
                column.setComment(remark);
                column.setTable((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_NAME", set, table.getName()), column.getTableName(true)}));
                column.setType(this.integer(keys, "DATA_TYPE", set, column.getType()));
                column.setType(this.integer(keys, "SQL_DATA_TYPE", set, column.getType()));
                String jdbcType = this.string(keys, "TYPE_NAME", set, column.getTypeName());
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
                column.setJdbcType(jdbcType);
                column.setPrecision(this.integer(keys, "COLUMN_SIZE", set, column.getPrecision()));
                column.setScale(this.integer(keys, "DECIMAL_DIGITS", set, column.getScale()));
                column.setNullable(this.bool(keys, "NULLABLE", set, column.isNullable()));
                column.setDefaultValue(this.value(keys, "COLUMN_DEF", set, column.getDefaultValue()));
                column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, column.getPosition()));
                column.setAutoIncrement(this.bool(keys, "IS_AUTOINCREMENT", set, column.isAutoIncrement()));
                ColumnType columnType = this.type(column.getTypeName());
                column.setColumnType(columnType);
                this.column(runtime, column, set);
                column.setName(name);
            }
            ResultSet rs = dbmd.getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());
            while (rs.next()) {
                String name = rs.getString(4);
                Column column = (Column)columns.get(name.toUpperCase());
                if (null == column) continue;
                column.setPrimaryKey(Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return columns;
    }

    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        PrimaryKey primary;
        block8: {
            primary = null;
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            String tab = table.getName();
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                List runs = this.buildQueryPrimaryRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, false, (String)null, null, run).toUpperKey();
                        primary = this.primary(runtime, idx, table, set);
                        if (null != primary) {
                            primary.setTable(table);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block8;
                log.warn("{}[primary][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
            }
        }
        table.setPrimaryKey(primary);
        return primary;
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        LinkedHashMap foreigns;
        block6: {
            foreigns = new LinkedHashMap();
            if (null == random) {
                random = this.random(runtime);
            }
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            try {
                List runs = this.buildQueryForeignsRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                        foreigns = this.foreigns(runtime, idx, table, foreigns, set);
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block6;
                e.printStackTrace();
            }
        }
        return foreigns;
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, String random, boolean greedy, Table table, String name) {
        List runs;
        LinkedHashMap<String, Object> indexs = null;
        if (null == table) {
            table = new Table();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        if (null != table.getName()) {
            block17: {
                try {
                    indexs = this.indexs(runtime, true, indexs, table, false, false);
                    table.setIndexs(indexs);
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block17;
                    e.printStackTrace();
                }
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                Index index = (Index)indexs.get(name.toUpperCase());
                indexs = new LinkedHashMap();
                indexs.put(name.toUpperCase(), index);
            }
        }
        if (null != (runs = this.buildQueryIndexRun(runtime, table, name))) {
            int idx = 0;
            for (Run run : runs) {
                block18: {
                    DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                    try {
                        indexs = this.indexs(runtime, idx, true, table, indexs, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block18;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        PrimaryKey pk = null;
        for (Index index : indexs.values()) {
            if (!index.isPrimary()) continue;
            pk = index;
            break;
        }
        if (null == pk) {
            pk = table.getPrimaryKey();
            if (null == pk) {
                pk = this.primary(runtime, random, false, table);
            }
            if (null != pk) {
                Index index = (Index)indexs.get(pk.getName().toUpperCase());
                if (null != index) {
                    index.setPrimary(true);
                } else {
                    indexs.put(pk.getName().toUpperCase(), pk);
                }
            }
        }
        return indexs;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        DataSource ds = null;
        Connection con = null;
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        JdbcTemplate jdbc = this.jdbc(runtime);
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet set = dbmd.getIndexInfo(table.getCatalog(), table.getSchema(), table.getName(), unique, approximate);
            Map keys = this.keys(set);
            LinkedHashMap<String, Column> columns = null;
            while (set.next()) {
                String name = this.string(keys, "INDEX_NAME", set);
                if (null == name) continue;
                Index index = (Index)indexs.get(name.toUpperCase());
                if (null == index) {
                    if (!create) continue;
                    index = new Index();
                    indexs.put(name.toUpperCase(), index);
                    index.setName(this.string(keys, "INDEX_NAME", set));
                    index.setUnique(this.bool(keys, "NON_UNIQUE", set, false) == false);
                    index.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), table.getCatalog()}));
                    index.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), table.getSchema()}));
                    index.setTable(this.string(keys, "TABLE_NAME", set));
                    indexs.put(name.toUpperCase(), index);
                    columns = new LinkedHashMap<String, Column>();
                    index.setColumns(columns);
                    if (name.equalsIgnoreCase("PRIMARY")) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    } else if (name.equalsIgnoreCase("PK_" + table.getName())) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    }
                } else {
                    columns = index.getColumns();
                }
                String columnName = this.string(keys, "COLUMN_NAME", set);
                Column col = table.getColumn(columnName.toUpperCase());
                Column column = null;
                if (null != col) {
                    column = (Column)col.clone();
                } else {
                    column = new Column();
                    column.setName(columnName);
                }
                String order = this.string(keys, "ASC_OR_DESC", set);
                order = null != order && order.startsWith("D") ? "DESC" : "ASC";
                column.setOrder(order);
                column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, null));
                columns.put(column.getName().toUpperCase(), column);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return indexs;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set)"), (int)37));
        }
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        List runs;
        LinkedHashMap triggers = new LinkedHashMap();
        if (null == table) {
            table = new Table();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        if (null != (runs = this.buildQueryTriggerRun(runtime, table, events))) {
            int idx = 0;
            for (Run run : runs) {
                block7: {
                    DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                    try {
                        triggers = this.triggers(runtime, idx, true, table, triggers, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block7;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return triggers;
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String name) {
        List runs;
        LinkedHashMap procedures = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema) {
            Table tmp = new Table();
            this.checkSchema(runtime, tmp);
            if (null == catalog) {
                catalog = tmp.getCatalog();
            }
            if (null == schema) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryProcedureRun(runtime, catalog, schema, name))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                    try {
                        procedures = this.procedures(runtime, idx, true, procedures, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return procedures;
    }

    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List runs = this.buildQueryDDLRun(runtime, procedure);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, null, run).toUpperKey();
                        list = this.ddl(runtime, idx++, procedure, list, set);
                    }
                    if (list.size() > 0) {
                        procedure.setDdls(list);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[procedure ddl][procedure:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, procedure.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[procedure ddl][{}][procedure:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5b58\u50a8\u8fc7\u7a0b\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), procedure.getName(), e.toString()});
            }
        }
        return list;
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, boolean recover, String catalog, String schema, String name) {
        List runs;
        LinkedHashMap functions = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema) {
            Table tmp = new Table();
            this.checkSchema(runtime, tmp);
            if (null == catalog) {
                catalog = tmp.getCatalog();
            }
            if (null == schema) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryFunctionRun(runtime, catalog, schema, name))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = this.select(runtime, random, true, (String)null, null, run).toUpperKey();
                    try {
                        functions = this.functions(runtime, idx, true, functions, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return functions;
    }

    public List<String> ddl(DataRuntime runtime, String random, Function function) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List runs = this.buildQueryDDLRun(runtime, function);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, null, run).toUpperKey();
                        list = this.ddl(runtime, idx++, function, list, set);
                    }
                    if (list.size() > 0) {
                        function.setDdls(list);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[function ddl][function:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, function.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[function ddl][{}][function:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u51fd\u6570\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), function.getName(), e.toString()});
            }
        }
        return list;
    }
}

