/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.listener;

import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.jdbc.runtime.JDBCRuntime;
import org.anyline.data.jdbc.runtime.JDBCRuntimeHolder;
import org.anyline.util.ConfigTable;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="anyline.listener.jdbc.EnvironmentListener")
public class JDBCEnvironmentListener
implements ApplicationContextAware {
    public static Logger log = LoggerFactory.getLogger(JDBCEnvironmentListener.class);
    private static ApplicationContext context;
    private static DefaultListableBeanFactory factory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
        factory = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        SpringContextUtil.init((ApplicationContext)context);
        JDBCRuntimeHolder.init((DefaultListableBeanFactory)factory);
        JdbcTemplate template = (JdbcTemplate)SpringContextUtil.getBean(JdbcTemplate.class);
        int qty = this.load("spring.datasource");
        qty += this.load("anyline.datasource");
        if (null != template) {
            this.load(template, qty > 0);
        }
    }

    private void load(JdbcTemplate template, boolean multiple) {
        if (null != template) {
            if (multiple) {
                JDBCRuntimeHolder.reg("default", template, null);
                if (ConfigTable.IS_OPEN_PRIMARY_TRANSACTION_MANAGER) {
                    DataSourceHolder.regTransactionManager("primary", template.getDataSource(), true);
                }
            }
            JDBCRuntime runtime = new JDBCRuntime("common", template, null);
            JDBCRuntimeHolder.reg("common", runtime);
        }
    }

    private int load(String head) {
        int qty = 0;
        Environment env = context.getEnvironment();
        String prefixs = env.getProperty(head + ".list");
        if (null == prefixs) {
            prefixs = env.getProperty(head + "-list");
        }
        if (null != prefixs) {
            for (String prefix : prefixs.split(",")) {
                try {
                    String ds = DataSourceHolder.reg(prefix, head + "." + prefix, env);
                    if (null == ds) continue;
                    ++qty;
                    log.info("[\u521b\u5efa\u6570\u636e\u6e90][prefix:{}][bean:{}]", (Object)prefix, (Object)ds);
                }
                catch (Exception e) {
                    log.error("[\u521b\u5efa\u6570\u636e\u6e90\u5931\u8d25][prefix:{}][msg:{}]", (Object)prefix, (Object)e.toString());
                }
            }
        }
        return qty;
    }
}

