/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.runtime;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.runtime.init.DefaultRuntime;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JDBCRuntime
extends DefaultRuntime
implements DataRuntime {
    protected JdbcTemplate processor;
    protected String url;
    protected String driver;

    public JDBCRuntime(String key, JdbcTemplate jdbc, DriverAdapter adapter) {
        this.setKey(key);
        this.setProcessor(jdbc);
        this.setAdapter(adapter);
    }

    public JDBCRuntime() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public JdbcTemplate jdbc() {
        return this.processor;
    }

    public DataSource getDatasource() {
        if (null != this.processor) {
            return this.processor.getDataSource();
        }
        return null;
    }

    public Object getProcessor() {
        return this.processor;
    }

    public void setProcessor(Object processor) {
        this.processor = (JdbcTemplate)processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getFeature(boolean connection) {
        if (null == this.feature) {
            if (connection || null == this.driver || null == this.url) {
                jdbc = this.jdbc();
                if (null != jdbc) {
                    ds = null;
                    con = null;
                    try {
                        ds = jdbc.getDataSource();
                        con = DataSourceUtils.getConnection((DataSource)ds);
                        meta = con.getMetaData();
                        url = meta.getURL();
                        if (null == this.adapterKey) {
                            this.adapterKey = RuntimeHolder.parseAdapterKey((String)url);
                        }
                        this.feature = this.driver + "_" + meta.getDatabaseProductName().toLowerCase().replace(" ", "") + "_" + url;
                        if (null != this.version) ** GOTO lbl27
                        this.version = meta.getDatabaseProductVersion();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                        }
                    }
                }
            } else {
                this.feature = this.driver + "_" + this.url;
            }
        }
lbl27:
        // 7 sources

        if (null == this.adapterKey) {
            this.adapterKey = RuntimeHolder.parseAdapterKey((String)this.feature);
        }
        return this.feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        JdbcTemplate jdbc;
        if (null == this.version && null != (jdbc = this.jdbc())) {
            DataSource ds = null;
            Connection con = null;
            try {
                ds = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                DatabaseMetaData meta = con.getMetaData();
                this.version = meta.getDatabaseProductVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
            }
        }
        return this.version;
    }
}

