/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;

public abstract class RegexFilenameFilter
implements FilenameFilter,
FileFilter {
    PatternCache _cache;
    PatternMatcher _matcher;
    Pattern _pattern;

    RegexFilenameFilter(PatternCache cache, PatternMatcher matcher, String regex) {
        this._cache = cache;
        this._matcher = matcher;
        this.setFilterExpression(regex);
    }

    RegexFilenameFilter(PatternCache cache, PatternMatcher matcher, String regex, int options) {
        this._cache = cache;
        this._matcher = matcher;
        this.setFilterExpression(regex, options);
    }

    RegexFilenameFilter(PatternCache cache, PatternMatcher matcher) {
        this(cache, matcher, "");
    }

    public void setFilterExpression(String regex) throws MalformedCachePatternException {
        this._pattern = this._cache.getPattern(regex);
    }

    public void setFilterExpression(String regex, int options) throws MalformedCachePatternException {
        this._pattern = this._cache.getPattern(regex, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(File dir, String filename) {
        PatternMatcher patternMatcher = this._matcher;
        synchronized (patternMatcher) {
            return this._matcher.matches(filename, this._pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(File pathname) {
        PatternMatcher patternMatcher = this._matcher;
        synchronized (patternMatcher) {
            return this._matcher.matches(pathname.getName(), this._pattern);
        }
    }
}

