/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.awk;

import java.util.BitSet;
import org.apache.oro.text.awk.LeafNode;
import org.apache.oro.text.awk.SyntaxNode;

final class SyntaxTree {
    int _positions;
    SyntaxNode _root;
    LeafNode[] _nodes;
    BitSet[] _followSet;

    SyntaxTree(SyntaxNode root, int positions) {
        this._root = root;
        this._positions = positions;
    }

    void _computeFollowPositions() {
        this._followSet = new BitSet[this._positions];
        this._nodes = new LeafNode[this._positions];
        int index = this._positions;
        while (0 < index--) {
            this._followSet[index] = new BitSet(this._positions);
        }
        this._root._followPosition(this._followSet, this._nodes);
    }

    private void __addToFastMap(BitSet pos, boolean[] fastMap, boolean[] done) {
        for (int node = 0; node < this._positions; ++node) {
            if (!pos.get(node) || done[node]) continue;
            done[node] = true;
            for (int token = 0; token < 256; ++token) {
                if (fastMap[token]) continue;
                fastMap[token] = this._nodes[node]._matches((char)token);
            }
        }
    }

    boolean[] createFastMap() {
        boolean[] fastMap = new boolean[256];
        boolean[] done = new boolean[this._positions];
        this.__addToFastMap(this._root._firstPosition(), fastMap, done);
        return fastMap;
    }
}

