/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.server.replication.proto.Replication;

public interface GarbageCollectionEnvironment {
    public boolean getCandidates(String var1, List<String> var2) throws TableNotFoundException;

    public Iterator<String> getBlipIterator() throws TableNotFoundException;

    public Stream<Reference> getReferences();

    public Set<TableId> getTableIDs();

    public void delete(SortedMap<String, String> var1) throws TableNotFoundException;

    public void deleteTableDirIfEmpty(TableId var1) throws IOException;

    public void incrementCandidatesStat(long var1);

    public void incrementInUseStat(long var1);

    public Iterator<Map.Entry<String, Replication.Status>> getReplicationNeededIterator();

    public static class Reference {
        public final TableId id;
        public final String ref;
        public final boolean isDir;

        Reference(TableId id, String ref, boolean isDir) {
            this.id = id;
            this.ref = ref;
            this.isDir = isDir;
        }
    }
}

