/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.IterConfigUtil;
import org.apache.accumulo.core.conf.ObservableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.scan.ScanDispatcher;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.TableConfWatcher;
import org.apache.accumulo.server.conf.ZooCachePropertyAccessor;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfiguration
extends ObservableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TableConfiguration.class);
    private static final Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> propCaches = new HashMap<ZooCachePropertyAccessor.PropCacheKey, ZooCache>();
    private final AtomicReference<ZooCachePropertyAccessor> propCacheAccessor = new AtomicReference();
    private final ServerContext context;
    private final NamespaceConfiguration parent;
    private ZooCacheFactory zcf = new ZooCacheFactory();
    private final TableId tableId;
    private EnumMap<IteratorUtil.IteratorScope, AtomicReference<ParsedIteratorConfig>> iteratorConfig;
    private AtomicReference<TablesScanDispatcher> scanDispatcherRef = new AtomicReference();

    public TableConfiguration(ServerContext context, TableId tableId, NamespaceConfiguration parent) {
        this.context = Objects.requireNonNull(context);
        this.tableId = Objects.requireNonNull(tableId);
        this.parent = Objects.requireNonNull(parent);
        this.iteratorConfig = new EnumMap(IteratorUtil.IteratorScope.class);
        for (IteratorUtil.IteratorScope scope : IteratorUtil.IteratorScope.values()) {
            this.iteratorConfig.put(scope, new AtomicReference<Object>(null));
        }
    }

    void setZooCacheFactory(ZooCacheFactory zcf) {
        this.zcf = zcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooCache getZooCache() {
        Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> map = propCaches;
        synchronized (map) {
            ZooCachePropertyAccessor.PropCacheKey key = new ZooCachePropertyAccessor.PropCacheKey(this.context.getInstanceID(), this.tableId.canonical());
            ZooCache propCache = propCaches.get(key);
            if (propCache == null) {
                propCache = this.zcf.getZooCache(this.context.getZooKeepers(), this.context.getZooKeepersSessionTimeOut(), (Watcher)new TableConfWatcher(this.context));
                propCaches.put(key, propCache);
            }
            return propCache;
        }
    }

    private ZooCachePropertyAccessor getPropCacheAccessor() {
        ZooCachePropertyAccessor zcpa = this.propCacheAccessor.get();
        if (zcpa != null) {
            return zcpa;
        }
        return this.propCacheAccessor.updateAndGet(pca -> pca == null ? new ZooCachePropertyAccessor(this.getZooCache()) : pca);
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.tableId == null) {
            String err = "Attempt to add observer for non-table configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        this.iterator();
        super.addObserver(co);
    }

    public void removeObserver(ConfigurationObserver co) {
        if (this.tableId == null) {
            String err = "Attempt to remove observer for non-table configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        super.removeObserver(co);
    }

    private String getPath() {
        return this.context.getZooKeeperRoot() + "/tables" + "/" + this.tableId + "/conf";
    }

    public boolean isPropertySet(Property prop, boolean cacheAndWatch) {
        if (!cacheAndWatch) {
            throw new UnsupportedOperationException("Table configuration only supports checking if a property is set in cache.");
        }
        if (this.getPropCacheAccessor().isPropertySet(prop, this.getPath())) {
            return true;
        }
        return this.parent.isPropertySet(prop, cacheAndWatch);
    }

    public String get(Property property) {
        return this.getPropCacheAccessor().get(property, this.getPath(), (AccumuloConfiguration)this.parent);
    }

    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.getPropCacheAccessor().getProperties(props, this.getPath(), filter, (AccumuloConfiguration)this.parent, null);
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public NamespaceConfiguration getNamespaceConfiguration() {
        return this.context.getServerConfFactory().getNamespaceConfiguration(this.parent.namespaceId);
    }

    public NamespaceConfiguration getParentConfiguration() {
        return this.parent;
    }

    public synchronized void invalidateCache() {
        ZooCachePropertyAccessor pca = this.propCacheAccessor.get();
        if (pca != null) {
            pca.invalidateCache();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public long getUpdateCount() {
        return this.parent.getUpdateCount() + this.getPropCacheAccessor().getZooCache().getUpdateCount();
    }

    public ParsedIteratorConfig getParsedIteratorConfig(IteratorUtil.IteratorScope scope) {
        long count = this.getUpdateCount();
        AtomicReference<ParsedIteratorConfig> ref = this.iteratorConfig.get(scope);
        ParsedIteratorConfig pic = ref.get();
        if (pic == null || pic.updateCount != count) {
            HashMap allOpts = new HashMap();
            List iters = IterConfigUtil.parseIterConf((IteratorUtil.IteratorScope)scope, Collections.emptyList(), allOpts, (AccumuloConfiguration)this);
            ParsedIteratorConfig newPic = new ParsedIteratorConfig(iters, allOpts, this.get(Property.TABLE_CLASSPATH), count);
            ref.compareAndSet(pic, newPic);
            pic = newPic;
        }
        return pic;
    }

    public ScanDispatcher getScanDispatcher() {
        long count = this.getUpdateCount();
        TablesScanDispatcher currRef = this.scanDispatcherRef.get();
        if (currRef == null || currRef.count != count) {
            ScanDispatcher newDispatcher = (ScanDispatcher)Property.createTableInstanceFromPropertyName((AccumuloConfiguration)this, (Property)Property.TABLE_SCAN_DISPATCHER, ScanDispatcher.class, null);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.getAllPropertiesWithPrefix(Property.TABLE_SCAN_DISPATCHER_OPTS).forEach((k, v) -> {
                String optKey = k.substring(Property.TABLE_SCAN_DISPATCHER_OPTS.getKey().length());
                builder.put((Object)optKey, v);
            });
            ImmutableMap opts = builder.build();
            newDispatcher.init(new ScanDispatcher.InitParameters((Map)opts){
                final /* synthetic */ Map val$opts;
                {
                    this.val$opts = map;
                }

                public TableId getTableId() {
                    return TableConfiguration.this.tableId;
                }

                public Map<String, String> getOptions() {
                    return this.val$opts;
                }

                public ServiceEnvironment getServiceEnv() {
                    return new ServiceEnvironmentImpl(TableConfiguration.this.context);
                }
            });
            TablesScanDispatcher newRef = new TablesScanDispatcher(newDispatcher, count);
            this.scanDispatcherRef.compareAndSet(currRef, newRef);
            currRef = newRef;
        }
        return currRef.dispatcher;
    }

    public static class TablesScanDispatcher {
        public final ScanDispatcher dispatcher;
        public final long count;

        public TablesScanDispatcher(ScanDispatcher dispatcher, long count) {
            this.dispatcher = dispatcher;
            this.count = count;
        }
    }

    public static class ParsedIteratorConfig {
        private final List<IterInfo> tableIters;
        private final Map<String, Map<String, String>> tableOpts;
        private final String context;
        private final long updateCount;

        private ParsedIteratorConfig(List<IterInfo> ii, Map<String, Map<String, String>> opts, String context, long updateCount) {
            this.tableIters = ImmutableList.copyOf(ii);
            ImmutableMap.Builder imb = ImmutableMap.builder();
            for (Map.Entry<String, Map<String, String>> entry : opts.entrySet()) {
                imb.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
            }
            this.tableOpts = imb.build();
            this.context = context;
            this.updateCount = updateCount;
        }

        public List<IterInfo> getIterInfo() {
            return this.tableIters;
        }

        public Map<String, Map<String, String>> getOpts() {
            return this.tableOpts;
        }

        public String getServiceEnv() {
            return this.context;
        }
    }
}

