/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.init;

import com.beust.jcommander.Parameter;
import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Predicate;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerUtil;
import org.apache.accumulo.server.constraints.MetadataConstraints;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.accumulo.server.fs.VolumeChooserEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.iterators.MetadataBulkLoadFilter;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.apache.accumulo.server.replication.StatusCombiner;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.ChangeSecret;
import org.apache.accumulo.server.util.SystemPropUtil;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DM_EXIT"}, justification="CLI utility can exit")
public class Initialize
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(Initialize.class);
    private static final String DEFAULT_ROOT_USER = "root";
    private static final String TABLE_TABLETS_TABLET_DIR = "/table_info";
    private static ConsoleReader reader = null;
    private static ZooReaderWriter zoo = null;
    private static HashMap<String, String> initialMetadataConf = new HashMap();
    private static HashMap<String, String> initialMetadataCombinerConf = new HashMap();
    private static HashMap<String, String> initialReplicationTableConf = new HashMap();

    private static ConsoleReader getConsoleReader() throws IOException {
        if (reader == null) {
            reader = new ConsoleReader();
        }
        return reader;
    }

    static void setZooReaderWriter(ZooReaderWriter zooReaderWriter) {
        zoo = zooReaderWriter;
    }

    static ZooReaderWriter getZooReaderWriter() {
        return zoo;
    }

    static boolean checkInit(VolumeManager fs, SiteConfiguration sconf, Configuration hadoopConf) throws IOException {
        String fsUri = sconf.get(Property.INSTANCE_DFS_URI);
        if (fsUri.equals("")) {
            fsUri = FileSystem.getDefaultUri((Configuration)hadoopConf).toString();
        }
        log.info("Hadoop Filesystem is {}", (Object)fsUri);
        log.info("Accumulo data dirs are {}", Arrays.asList(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)sconf, (Configuration)hadoopConf)));
        log.info("Zookeeper server is {}", (Object)sconf.get(Property.INSTANCE_ZK_HOST));
        log.info("Checking if Zookeeper is available. If this hangs, then you need to make sure zookeeper is running");
        if (!Initialize.zookeeperAvailable()) {
            log.error("FATAL Zookeeper needs to be up and running in order to init. Exiting ...");
            return false;
        }
        if (sconf.get(Property.INSTANCE_SECRET).equals(Property.INSTANCE_SECRET.getDefaultValue())) {
            ConsoleReader c = Initialize.getConsoleReader();
            c.beep();
            c.println();
            c.println();
            c.println((CharSequence)"Warning!!! Your instance secret is still set to the default, this is not secure. We highly recommend you change it.");
            c.println();
            c.println();
            c.println((CharSequence)"You can change the instance secret in accumulo by using:");
            c.println((CharSequence)("   bin/accumulo " + ChangeSecret.class.getName()));
            c.println((CharSequence)"You will also need to edit your secret in your configuration file by adding the property instance.secret to your accumulo.properties. Without this accumulo will not operate correctly");
        }
        try {
            if (Initialize.isInitialized(fs, sconf, hadoopConf)) {
                Initialize.printInitializeFailureMessages(sconf, hadoopConf);
                return false;
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to check if filesystem already initialized", e);
        }
        return true;
    }

    static void printInitializeFailureMessages(SiteConfiguration sconf, Configuration hadoopConf) {
        Property INSTANCE_DFS_DIR = Property.INSTANCE_DFS_DIR;
        Property INSTANCE_DFS_URI = Property.INSTANCE_DFS_URI;
        String instanceDfsDir = sconf.get(INSTANCE_DFS_DIR);
        log.error("FATAL It appears the directories {}", (Object)(Arrays.asList(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)sconf, (Configuration)hadoopConf)) + " were previously initialized."));
        String instanceVolumes = sconf.get(Property.INSTANCE_VOLUMES);
        String instanceDfsUri = sconf.get(INSTANCE_DFS_URI);
        if (!instanceVolumes.isEmpty()) {
            log.error("FATAL: Change the property {} to use different filesystems,", (Object)Property.INSTANCE_VOLUMES);
        } else if (!instanceDfsDir.isEmpty()) {
            log.error("FATAL: Change the property {} to use a different filesystem,", (Object)INSTANCE_DFS_URI);
        } else {
            log.error("FATAL: You are using the default URI for the filesystem. Set the property {} to use a different filesystem,", (Object)Property.INSTANCE_VOLUMES);
        }
        log.error("FATAL: or change the property {} to use a different directory.", (Object)INSTANCE_DFS_DIR);
        log.error("FATAL: The current value of {} is |{}|", (Object)INSTANCE_DFS_URI, (Object)instanceDfsUri);
        log.error("FATAL: The current value of {} is |{}|", (Object)INSTANCE_DFS_DIR, (Object)instanceDfsDir);
        log.error("FATAL: The current value of {} is |{}|", (Object)Property.INSTANCE_VOLUMES, (Object)instanceVolumes);
    }

    public boolean doInit(SiteConfiguration siteConfig, Opts opts, Configuration conf, VolumeManager fs) throws IOException {
        String rootUser;
        String instanceNamePath;
        if (!Initialize.checkInit(fs, siteConfig, conf)) {
            return false;
        }
        try {
            instanceNamePath = this.getInstanceNamePath(opts);
        }
        catch (Exception e) {
            log.error("FATAL: Failed to talk to zookeeper", (Throwable)e);
            return false;
        }
        try {
            rootUser = this.getRootUserName(siteConfig, opts);
        }
        catch (Exception e) {
            log.error("FATAL: Failed to obtain user for administrative privileges");
            return false;
        }
        opts.rootpass = siteConfig.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED) ? UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8) : this.getRootPassword(siteConfig, opts, rootUser);
        return this.initialize(siteConfig, conf, opts, instanceNamePath, fs, rootUser);
    }

    /*
     * Unable to fully structure code
     */
    private boolean initialize(SiteConfiguration siteConfig, Configuration hadoopConf, Opts opts, String instanceNamePath, VolumeManager fs, String rootUser) {
        block24: {
            uuid = UUID.randomUUID();
            configuredVolumes = VolumeConfiguration.getVolumeUris((AccumuloConfiguration)siteConfig, (Configuration)hadoopConf);
            chooserEnv = new VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.ChooserScope.INIT, null);
            rootTabletDir = new Path(fs.choose(chooserEnv, configuredVolumes) + "/" + "tables" + "/" + RootTable.ID + "/root_tablet").toString();
            try {
                Initialize.initZooKeeper(opts, uuid.toString(), instanceNamePath, rootTabletDir);
            }
            catch (Exception e) {
                Initialize.log.error("FATAL: Failed to initialize zookeeper", (Throwable)e);
                return false;
            }
            try {
                this.initFileSystem(siteConfig, hadoopConf, fs, uuid, rootTabletDir);
            }
            catch (Exception e) {
                Initialize.log.error("FATAL Failed to initialize filesystem", (Throwable)e);
                if (siteConfig.get(Property.INSTANCE_VOLUMES).trim().equals("")) {
                    defaultFsUri = "file:///";
                    fsDefaultName = hadoopConf.get("fs.default.name", "file:///");
                    fsDefaultFS = hadoopConf.get("fs.defaultFS", "file:///");
                    if ("file:///".equals(fsDefaultName) && "file:///".equals(fsDefaultFS)) {
                        Initialize.log.error("FATAL: Default filesystem value ('fs.defaultFS' or 'fs.default.name') of '{}' was found in the Hadoop configuration", (Object)"file:///");
                        Initialize.log.error("FATAL: Please ensure that the Hadoop core-site.xml is on the classpath using 'general.classpaths' in accumulo.properties");
                    }
                }
                return false;
            }
            context = new ServerContext(siteConfig);
            siteConf = context.getServerConfFactory().getSiteConfiguration();
            if (!siteConf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED) || (ugi = UserGroupInformation.getCurrentUser()).hasKerberosCredentials()) ** GOTO lbl46
            accumuloKeytab = siteConf.get(Property.GENERAL_KERBEROS_KEYTAB);
            accumuloPrincipal = siteConf.get(Property.GENERAL_KERBEROS_PRINCIPAL);
            if (!StringUtils.isBlank((CharSequence)accumuloKeytab) && !StringUtils.isBlank((CharSequence)accumuloPrincipal)) break block24;
            Initialize.log.error("FATAL: No Kerberos credentials provided, and Accumulo is not properly configured for server login");
            var16_30 = false;
            context.close();
            return var16_30;
        }
        try {
            try {
                Initialize.log.info("Logging in as {} with {}", (Object)accumuloPrincipal, (Object)accumuloKeytab);
                UserGroupInformation.loginUserFromKeytab((String)accumuloPrincipal, (String)accumuloKeytab);
            }
            catch (IOException e) {
                Initialize.log.error("FATAL: Failed to get the Kerberos user", (Throwable)e);
                var13_23 = false;
                context.close();
                return var13_23;
            }
lbl46:
            // 2 sources

            try {
                Initialize.initSecurity(context, opts, rootUser);
            }
            catch (Exception e) {
                Initialize.log.error("FATAL: Failed to initialize security", (Throwable)e);
                var13_24 = false;
                context.close();
                return var13_24;
            }
            if (opts.uploadAccumuloProps) {
                try {
                    Initialize.log.info("Uploading properties in accumulo.properties to Zookeeper. Properties that cannot be set in Zookeeper will be skipped:");
                    entries = new TreeMap<K, V>();
                    siteConfig.getProperties(entries, (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$initialize$0(java.lang.String ), (Ljava/lang/String;)Z)(), false);
                    for (Map.Entry<K, V> entry : entries.entrySet()) {
                        key = (String)entry.getKey();
                        value = (String)entry.getValue();
                        if (Property.isValidZooPropertyKey((String)key)) {
                            SystemPropUtil.setSystemProperty(context, key, value);
                            Initialize.log.info("Uploaded - {} = {}", (Object)key, (Object)(Property.isSensitive((String)key) != false ? "<hidden>" : value));
                            continue;
                        }
                        Initialize.log.info("Skipped - {} = {}", (Object)key, (Object)(Property.isSensitive((String)key) != false ? "<hidden>" : value));
                    }
                }
                catch (Exception e) {
                    Initialize.log.error("FATAL: Failed to upload accumulo.properties to Zookeeper", (Throwable)e);
                    var13_25 = false;
                    context.close();
                    return var13_25;
                }
            }
            var12_19 = true;
            return var12_19;
        }
        catch (Throwable var12_20) {
            throw var12_20;
        }
        finally {
            try {
                context.close();
            }
            catch (Throwable var13_26) {
                var12_20.addSuppressed(var13_26);
            }
        }
    }

    private static boolean zookeeperAvailable() {
        try {
            return zoo.exists("/");
        }
        catch (InterruptedException | KeeperException e) {
            return false;
        }
    }

    private static void initDirs(VolumeManager fs, UUID uuid, String[] baseDirs, boolean print) throws IOException {
        for (String baseDir : baseDirs) {
            fs.mkdirs(new Path(new Path(baseDir, "version"), "9"), new FsPermission("700"));
            Path iidLocation = new Path(baseDir, "instance_id");
            fs.mkdirs(iidLocation);
            fs.createNewFile(new Path(iidLocation, uuid.toString()));
            if (!print) continue;
            log.info("Initialized volume {}", (Object)baseDir);
        }
    }

    private void initFileSystem(SiteConfiguration siteConfig, Configuration hadoopConf, VolumeManager fs, UUID uuid, String rootTabletDir) throws IOException {
        Initialize.initDirs(fs, uuid, VolumeConfiguration.getVolumeUris((AccumuloConfiguration)siteConfig, (Configuration)hadoopConf), false);
        Initialize.initSystemTablesConfig(zoo, "/accumulo/" + uuid, hadoopConf);
        VolumeChooserEnvironmentImpl chooserEnv = new VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.ChooserScope.INIT, null);
        String tableMetadataTabletDir = fs.choose(chooserEnv, ServerConstants.getBaseUris((AccumuloConfiguration)siteConfig, hadoopConf)) + "/tables" + "/" + MetadataTable.ID + TABLE_TABLETS_TABLET_DIR;
        String replicationTableDefaultTabletDir = fs.choose(chooserEnv, ServerConstants.getBaseUris((AccumuloConfiguration)siteConfig, hadoopConf)) + "/tables" + "/" + ReplicationTable.ID + "/default_tablet";
        String defaultMetadataTabletDir = fs.choose(chooserEnv, ServerConstants.getBaseUris((AccumuloConfiguration)siteConfig, hadoopConf)) + "/tables" + "/" + MetadataTable.ID + "/default_tablet";
        Initialize.createDirectories(fs, rootTabletDir, tableMetadataTabletDir, defaultMetadataTabletDir, replicationTableDefaultTabletDir);
        String ext = FileOperations.getNewFileExtension((AccumuloConfiguration)DefaultConfiguration.getInstance());
        String metadataFileName = tableMetadataTabletDir + "/" + "0_1." + ext;
        Tablet replicationTablet = new Tablet(ReplicationTable.ID, replicationTableDefaultTabletDir, null, null, new String[0]);
        Initialize.createMetadataFile(fs, metadataFileName, (AccumuloConfiguration)siteConfig, replicationTablet);
        String rootTabletFileName = rootTabletDir + "/" + "00000_00000." + ext;
        Text splitPoint = MetadataSchema.TabletsSection.getRange().getEndKey().getRow();
        Tablet tablesTablet = new Tablet(MetadataTable.ID, tableMetadataTabletDir, null, splitPoint, metadataFileName);
        Tablet defaultTablet = new Tablet(MetadataTable.ID, defaultMetadataTabletDir, splitPoint, null, new String[0]);
        Initialize.createMetadataFile(fs, rootTabletFileName, (AccumuloConfiguration)siteConfig, tablesTablet, defaultTablet);
    }

    private static void createMetadataFile(VolumeManager volmanager, String fileName, AccumuloConfiguration conf, Tablet ... tablets) throws IOException {
        TreeMap<Key, Value> sorted = new TreeMap<Key, Value>();
        for (Tablet tablet : tablets) {
            Initialize.createEntriesForTablet(sorted, tablet);
        }
        FileSystem fs = volmanager.getVolumeByPath(new Path(fileName)).getFileSystem();
        CryptoService cs = CryptoServiceFactory.newInstance((AccumuloConfiguration)conf, (CryptoServiceFactory.ClassloaderType)CryptoServiceFactory.ClassloaderType.ACCUMULO);
        FileSKVWriter tabletWriter = FileOperations.getInstance().newWriterBuilder().forFile(fileName, fs, fs.getConf(), cs).withTableConfiguration(conf).build();
        tabletWriter.startDefaultLocalityGroup();
        for (Map.Entry<Key, Value> entry : sorted.entrySet()) {
            tabletWriter.append(entry.getKey(), entry.getValue());
        }
        tabletWriter.close();
    }

    private static void createEntriesForTablet(TreeMap<Key, Value> map, Tablet tablet) {
        Value EMPTY_SIZE = new DataFileValue(0L, 0L).encodeAsValue();
        Text extent = new Text(MetadataSchema.TabletsSection.getRow((TableId)tablet.tableId, (Text)tablet.endRow));
        Initialize.addEntry(map, extent, MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN, new Value(tablet.dir.getBytes(StandardCharsets.UTF_8)));
        Initialize.addEntry(map, extent, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN, new Value("L0".getBytes(StandardCharsets.UTF_8)));
        Initialize.addEntry(map, extent, MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN, KeyExtent.encodePrevEndRow((Text)tablet.prevEndRow));
        for (String file : tablet.files) {
            Initialize.addEntry(map, extent, new ColumnFQ(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, new Text(file)), EMPTY_SIZE);
        }
    }

    private static void addEntry(TreeMap<Key, Value> map, Text row, ColumnFQ col, Value value) {
        map.put(new Key(row, col.getColumnFamily(), col.getColumnQualifier(), 0L), value);
    }

    private static void createDirectories(VolumeManager fs, String ... dirs) throws IOException {
        for (String s : dirs) {
            Path dir = new Path(s);
            try {
                FileStatus fstat = fs.getFileStatus(dir);
                if (fstat.isDirectory()) continue;
                log.error("FATAL: location {} exists but is not a directory", (Object)dir);
                return;
            }
            catch (FileNotFoundException fnfe) {
                if (fs.mkdirs(dir)) continue;
                log.error("FATAL: unable to create directory {}", (Object)dir);
                return;
            }
        }
    }

    private static void initZooKeeper(Opts opts, String uuid, String instanceNamePath, String rootTabletDir) throws KeeperException, InterruptedException {
        zoo.putPersistentData("/accumulo", new byte[0], -1, ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        zoo.putPersistentData("/accumulo/instances", new byte[0], -1, ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        if (opts.clearInstanceName) {
            zoo.recursiveDelete(instanceNamePath, ZooUtil.NodeMissingPolicy.SKIP);
        }
        zoo.putPersistentData(instanceNamePath, uuid.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        byte[] EMPTY_BYTE_ARRAY = new byte[]{};
        byte[] ZERO_CHAR_ARRAY = new byte[]{48};
        String zkInstanceRoot = "/accumulo/" + uuid;
        zoo.putPersistentData(zkInstanceRoot, EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tables", Constants.ZTABLES_INITIAL_ID, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/namespaces", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewNamespaceState((IZooReaderWriter)zoo, uuid, Namespace.DEFAULT.id(), Namespace.DEFAULT.name(), ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewNamespaceState((IZooReaderWriter)zoo, uuid, Namespace.ACCUMULO.id(), Namespace.ACCUMULO.name(), ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState((IZooReaderWriter)zoo, uuid, RootTable.ID, Namespace.ACCUMULO.id(), RootTable.NAME, TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState((IZooReaderWriter)zoo, uuid, MetadataTable.ID, Namespace.ACCUMULO.id(), MetadataTable.NAME, TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState((IZooReaderWriter)zoo, uuid, ReplicationTable.ID, Namespace.ACCUMULO.id(), ReplicationTable.NAME, TableState.OFFLINE, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tservers", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/problems", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/walogs", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/current_logs", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/dir", rootTabletDir.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters/goal_state", MasterGoalState.NORMAL.toString().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/config", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/table_locks", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/hdfs_reservations", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/next_file", ZERO_CHAR_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/recovery", ZERO_CHAR_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/monitor", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/monitor/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/replication", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/replication/tservers", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/wals", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
    }

    private String getInstanceNamePath(Opts opts) throws IOException, KeeperException, InterruptedException {
        String instanceNamePath = null;
        boolean exists = true;
        do {
            String instanceName;
            if ((instanceName = opts.cliInstanceName == null ? Initialize.getConsoleReader().readLine("Instance name : ") : opts.cliInstanceName) == null) {
                System.exit(0);
            }
            if ((instanceName = instanceName.trim()).length() == 0) continue;
            instanceNamePath = "/accumulo/instances/" + instanceName;
            if (opts.clearInstanceName) {
                exists = false;
                continue;
            }
            exists = zoo.exists(instanceNamePath);
            if (!exists) continue;
            String decision = Initialize.getConsoleReader().readLine("Instance name \"" + instanceName + "\" exists. Delete existing entry from zookeeper? [Y/N] : ");
            if (decision == null) {
                System.exit(0);
            }
            if (decision.length() != 1 || decision.toLowerCase(Locale.ENGLISH).charAt(0) != 'y') continue;
            opts.clearInstanceName = true;
            exists = false;
        } while (exists);
        return instanceNamePath;
    }

    private String getRootUserName(SiteConfiguration siteConfig, Opts opts) throws IOException {
        String user;
        String keytab = siteConfig.get(Property.GENERAL_KERBEROS_KEYTAB);
        if (keytab.equals(Property.GENERAL_KERBEROS_KEYTAB.getDefaultValue()) || !siteConfig.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            return DEFAULT_ROOT_USER;
        }
        ConsoleReader c = Initialize.getConsoleReader();
        c.println((CharSequence)"Running against secured HDFS");
        if (opts.rootUser != null) {
            return opts.rootUser;
        }
        do {
            if ((user = c.readLine("Principal (user) to grant administrative privileges to : ")) != null) continue;
            System.exit(1);
        } while (user.isEmpty());
        return user;
    }

    private byte[] getRootPassword(SiteConfiguration siteConfig, Opts opts, String rootUser) throws IOException {
        String confirmpass;
        String rootpass;
        if (opts.cliPassword != null) {
            return opts.cliPassword.getBytes(StandardCharsets.UTF_8);
        }
        do {
            if ((rootpass = Initialize.getConsoleReader().readLine("Enter initial password for " + rootUser + this.getInitialPasswordWarning(siteConfig), Character.valueOf('*'))) == null) {
                System.exit(0);
            }
            if ((confirmpass = Initialize.getConsoleReader().readLine("Confirm initial password for " + rootUser + ": ", Character.valueOf('*'))) == null) {
                System.exit(0);
            }
            if (rootpass.equals(confirmpass)) continue;
            log.error("Passwords do not match");
        } while (!rootpass.equals(confirmpass));
        return rootpass.getBytes(StandardCharsets.UTF_8);
    }

    private String getInitialPasswordWarning(SiteConfiguration siteConfig) {
        Property authenticatorProperty = Property.INSTANCE_SECURITY_AUTHENTICATOR;
        String optionalWarning = siteConfig.get(authenticatorProperty).equals(authenticatorProperty.getDefaultValue()) ? ": " : " (this may not be applicable for your security setup): ";
        return optionalWarning;
    }

    private static void initSecurity(ServerContext context, Opts opts, String rootUser) throws AccumuloSecurityException {
        AuditedSecurityOperation.getInstance(context).initializeSecurity(context.rpcCreds(), rootUser, opts.rootpass);
    }

    public static void initSystemTablesConfig(ZooReaderWriter zoo, String zooKeeperRoot, Configuration hadoopConf) throws IOException {
        try {
            int max = hadoopConf.getInt("dfs.replication.max", 512);
            int min = Math.max(hadoopConf.getInt("dfs.replication.min", 1), hadoopConf.getInt("dfs.namenode.replication.min", 1));
            if (max < 5) {
                Initialize.setMetadataReplication(max, "max");
            }
            if (min > 5) {
                Initialize.setMetadataReplication(min, "min");
            }
            for (Map.Entry<String, String> entry : initialMetadataConf.entrySet()) {
                if (!TablePropUtil.setTableProperty(zoo, zooKeeperRoot, RootTable.ID, entry.getKey(), entry.getValue())) {
                    throw new IOException("Cannot create per-table property " + entry.getKey());
                }
                if (TablePropUtil.setTableProperty(zoo, zooKeeperRoot, MetadataTable.ID, entry.getKey(), entry.getValue())) continue;
                throw new IOException("Cannot create per-table property " + entry.getKey());
            }
            for (Map.Entry<String, String> entry : initialMetadataCombinerConf.entrySet()) {
                if (TablePropUtil.setTableProperty(zoo, zooKeeperRoot, MetadataTable.ID, entry.getKey(), entry.getValue())) continue;
                throw new IOException("Cannot create per-table property " + entry.getKey());
            }
            for (Map.Entry<String, String> entry : initialReplicationTableConf.entrySet()) {
                if (TablePropUtil.setTableProperty(zoo, zooKeeperRoot, ReplicationTable.ID, entry.getKey(), entry.getValue())) continue;
                throw new IOException("Cannot create per-table property " + entry.getKey());
            }
        }
        catch (Exception e) {
            log.error("FATAL: Error talking to ZooKeeper", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static void setMetadataReplication(int replication, String reason) throws IOException {
        String rep = Initialize.getConsoleReader().readLine("Your HDFS replication " + reason + " is not compatible with our default " + MetadataTable.NAME + " replication of 5. What do you want to set your " + MetadataTable.NAME + " replication to? (" + replication + ") ");
        if (rep == null || rep.length() == 0) {
            rep = Integer.toString(replication);
        } else {
            Integer.parseInt(rep);
        }
        initialMetadataConf.put(Property.TABLE_FILE_REPLICATION.getKey(), rep);
    }

    public static boolean isInitialized(VolumeManager fs, SiteConfiguration siteConfig, Configuration hadoopConf) throws IOException {
        for (String baseDir : VolumeConfiguration.getVolumeUris((AccumuloConfiguration)siteConfig, (Configuration)hadoopConf)) {
            if (!fs.exists(new Path(baseDir, "instance_id")) && !fs.exists(new Path(baseDir, "version"))) continue;
            return true;
        }
        return false;
    }

    private static void addVolumes(VolumeManager fs, SiteConfiguration siteConfig, Configuration hadoopConf) throws IOException {
        String[] volumeURIs = VolumeConfiguration.getVolumeUris((AccumuloConfiguration)siteConfig, (Configuration)hadoopConf);
        HashSet<String> initializedDirs = new HashSet<String>();
        initializedDirs.addAll(Arrays.asList(ServerConstants.checkBaseUris((AccumuloConfiguration)siteConfig, hadoopConf, volumeURIs, true)));
        HashSet<String> uinitializedDirs = new HashSet<String>();
        uinitializedDirs.addAll(Arrays.asList(volumeURIs));
        uinitializedDirs.removeAll(initializedDirs);
        Path aBasePath = new Path((String)initializedDirs.iterator().next());
        Path iidPath = new Path(aBasePath, "instance_id");
        Path versionPath = new Path(aBasePath, "version");
        UUID uuid = UUID.fromString(ZooUtil.getInstanceIDFromHdfs((Path)iidPath, (AccumuloConfiguration)siteConfig, (Configuration)hadoopConf));
        for (Pair<Path, Path> replacementVolume : ServerConstants.getVolumeReplacements((AccumuloConfiguration)siteConfig, hadoopConf)) {
            if (!aBasePath.equals(replacementVolume.getFirst())) continue;
            log.error("{} is set to be replaced in {} and should not appear in {}. It is highly recommended that this property be removed as data could still be written to this volume.", new Object[]{aBasePath, Property.INSTANCE_VOLUMES_REPLACEMENTS, Property.INSTANCE_VOLUMES});
        }
        if (ServerUtil.getAccumuloPersistentVersion(versionPath.getFileSystem(hadoopConf), versionPath) != 9) {
            throw new IOException("Accumulo 2.0.0 cannot initialize data version " + ServerUtil.getAccumuloPersistentVersion(fs));
        }
        Initialize.initDirs(fs, uuid, uinitializedDirs.toArray(new String[uinitializedDirs.size()]), true);
    }

    public String keyword() {
        return "init";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.CORE;
    }

    public String description() {
        return "Initializes Accumulo";
    }

    public void execute(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs("accumulo init", args, new Object[0]);
        SiteConfiguration siteConfig = new SiteConfiguration();
        try {
            Initialize.setZooReaderWriter(new ZooReaderWriter((AccumuloConfiguration)siteConfig));
            SecurityUtil.serverLogin((AccumuloConfiguration)siteConfig);
            Configuration hadoopConfig = new Configuration();
            VolumeManager fs = VolumeManagerImpl.get((AccumuloConfiguration)siteConfig, hadoopConfig);
            if (opts.resetSecurity) {
                log.info("Resetting security on accumulo.");
                try (ServerContext context = new ServerContext(siteConfig);){
                    if (Initialize.isInitialized(fs, siteConfig, hadoopConfig)) {
                        ConsoleReader c;
                        String userEnteredName;
                        if (!opts.forceResetSecurity && (userEnteredName = (c = Initialize.getConsoleReader()).readLine("WARNING: This will remove all users from Accumulo! If you wish to proceed enter the instance name: ")) != null && !context.getInstanceName().equals(userEnteredName)) {
                            log.error("Aborted reset security: Instance name did not match current instance.");
                            return;
                        }
                        String rootUser = this.getRootUserName(siteConfig, opts);
                        opts.rootpass = this.getRootPassword(siteConfig, opts, rootUser);
                        Initialize.initSecurity(context, opts, rootUser);
                    } else {
                        log.error("FATAL: Attempted to reset security on accumulo before it was initialized");
                    }
                }
            }
            if (opts.addVolumes) {
                Initialize.addVolumes(fs, siteConfig, hadoopConfig);
            }
            if (!(opts.resetSecurity || opts.addVolumes || this.doInit(siteConfig, opts, hadoopConfig, fs))) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            log.error("Fatal exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        new Initialize().execute(args);
    }

    private static /* synthetic */ boolean lambda$initialize$0(String x) {
        return true;
    }

    static {
        initialMetadataConf.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "32K");
        initialMetadataConf.put(Property.TABLE_FILE_REPLICATION.getKey(), "5");
        initialMetadataConf.put(Property.TABLE_DURABILITY.getKey(), "sync");
        initialMetadataConf.put(Property.TABLE_MAJC_RATIO.getKey(), "1");
        initialMetadataConf.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "64M");
        initialMetadataConf.put(Property.TABLE_CONSTRAINT_PREFIX.getKey() + "1", MetadataConstraints.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.bulkLoadFilter", "20," + MetadataBulkLoadFilter.class.getName());
        initialMetadataConf.put(Property.TABLE_FAILURES_IGNORE.getKey(), "false");
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "tablet", String.format("%s,%s", MetadataSchema.TabletsSection.TabletColumnFamily.NAME, MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME));
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "server", String.format("%s,%s,%s,%s", MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, MetadataSchema.TabletsSection.LogColumnFamily.NAME, MetadataSchema.TabletsSection.ServerColumnFamily.NAME, MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME));
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "tablet,server");
        initialMetadataConf.put(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey(), "");
        initialMetadataConf.put(Property.TABLE_INDEXCACHE_ENABLED.getKey(), "true");
        initialMetadataConf.put(Property.TABLE_BLOCKCACHE_ENABLED.getKey(), "true");
        IteratorSetting setting = new IteratorSetting(9, "replcombiner", StatusCombiner.class);
        Combiner.setColumns((IteratorSetting)setting, Collections.singletonList(new IteratorSetting.Column(MetadataSchema.ReplicationSection.COLF)));
        for (IteratorUtil.IteratorScope scope : IteratorUtil.IteratorScope.values()) {
            String root = String.format("%s%s.%s", Property.TABLE_ITERATOR_PREFIX, scope.name().toLowerCase(), setting.getName());
            for (Map.Entry prop : setting.getOptions().entrySet()) {
                initialMetadataCombinerConf.put(root + ".opt." + (String)prop.getKey(), (String)prop.getValue());
            }
            initialMetadataCombinerConf.put(root, setting.getPriority() + "," + setting.getIteratorClass());
        }
        setting = new IteratorSetting(30, "statuscombiner", StatusCombiner.class);
        setting.setPriority(30);
        Combiner.setColumns((IteratorSetting)setting, Arrays.asList(new IteratorSetting.Column(ReplicationSchema.StatusSection.NAME), new IteratorSetting.Column(ReplicationSchema.WorkSection.NAME)));
        for (IteratorUtil.IteratorScope iteratorScope : EnumSet.allOf(IteratorUtil.IteratorScope.class)) {
            String root = String.format("%s%s.%s", Property.TABLE_ITERATOR_PREFIX, iteratorScope.name().toLowerCase(), setting.getName());
            for (Map.Entry prop : setting.getOptions().entrySet()) {
                initialReplicationTableConf.put(root + ".opt." + (String)prop.getKey(), (String)prop.getValue());
            }
            initialReplicationTableConf.put(root, setting.getPriority() + "," + setting.getIteratorClass());
        }
        for (Map.Entry entry : ReplicationTable.LOCALITY_GROUPS.entrySet()) {
            initialReplicationTableConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX + (String)entry.getKey(), LocalityGroupUtil.encodeColumnFamilies((Set)((Set)entry.getValue())));
        }
        initialReplicationTableConf.put(Property.TABLE_LOCALITY_GROUPS.getKey(), Joiner.on((String)",").join(ReplicationTable.LOCALITY_GROUPS.keySet()));
        initialReplicationTableConf.put(Property.TABLE_FORMATTER_CLASS.getKey(), ReplicationUtil.STATUS_FORMATTER_CLASS_NAME);
    }

    static class Opts
    extends Help {
        @Parameter(names={"--add-volumes"}, description="Initialize any uninitialized volumes listed in instance.volumes")
        boolean addVolumes = false;
        @Parameter(names={"--reset-security"}, description="just update the security information, will prompt")
        boolean resetSecurity = false;
        @Parameter(names={"-f", "--force"}, description="force reset of the security information without prompting")
        boolean forceResetSecurity = false;
        @Parameter(names={"--clear-instance-name"}, description="delete any existing instance name without prompting")
        boolean clearInstanceName = false;
        @Parameter(names={"--upload-accumulo-props"}, description="Uploads properties in accumulo.properties to Zookeeper")
        boolean uploadAccumuloProps = false;
        @Parameter(names={"--instance-name"}, description="the instance name, if not provided, will prompt")
        String cliInstanceName = null;
        @Parameter(names={"--password"}, description="set the password on the command line")
        String cliPassword = null;
        @Parameter(names={"-u", "--user"}, description="the name of the user to grant system permissions to")
        String rootUser = null;
        byte[] rootpass = null;

        Opts() {
        }
    }

    private static class Tablet {
        TableId tableId;
        String dir;
        Text prevEndRow;
        Text endRow;
        String[] files;

        Tablet(TableId tableId, String dir, Text prevEndRow, Text endRow, String ... files) {
            this.tableId = tableId;
            this.dir = dir;
            this.prevEndRow = prevEndRow;
            this.endRow = endRow;
            this.files = files;
        }
    }
}

