/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.delegation;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.server.security.delegation.AuthenticationKey;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.security.delegation.ZooAuthenticationKeyDistributor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationTokenKeyManager
extends Daemon {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationTokenKeyManager.class);
    private final AuthenticationTokenSecretManager secretManager;
    private final ZooAuthenticationKeyDistributor keyDistributor;
    private long lastKeyUpdate = 0L;
    private long keyUpdateInterval;
    private long tokenMaxLifetime;
    private int idSeq = 0;
    private volatile boolean keepRunning = true;
    private volatile boolean initialized = false;

    public AuthenticationTokenKeyManager(AuthenticationTokenSecretManager mgr, ZooAuthenticationKeyDistributor dist, long keyUpdateInterval, long tokenMaxLifetime) {
        super("Delegation Token Key Manager");
        this.secretManager = mgr;
        this.keyDistributor = dist;
        this.keyUpdateInterval = keyUpdateInterval;
        this.tokenMaxLifetime = tokenMaxLifetime;
    }

    @VisibleForTesting
    void setKeepRunning(boolean keepRunning) {
        this.keepRunning = keepRunning;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void gracefulStop() {
        this.keepRunning = false;
    }

    public void run() {
        this.updateStateFromCurrentKeys();
        this.initialized = true;
        while (this.keepRunning) {
            long now = System.currentTimeMillis();
            this._run(now);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                log.debug("Interrupted waiting for next update", (Throwable)ie);
            }
        }
    }

    @VisibleForTesting
    void updateStateFromCurrentKeys() {
        try {
            List<AuthenticationKey> currentKeys = this.keyDistributor.getCurrentKeys();
            if (!currentKeys.isEmpty()) {
                for (AuthenticationKey key : currentKeys) {
                    if (key.getKeyId() > this.idSeq) {
                        this.idSeq = key.getKeyId();
                    }
                    this.secretManager.addKey(key);
                }
                log.info("Added {} existing AuthenticationKeys into the local cache from ZooKeeper", (Object)currentKeys.size());
                AuthenticationKey currentKey = this.secretManager.getCurrentKey();
                if (currentKey != null) {
                    log.info("Updating last key update to {} from current secret manager key", (Object)currentKey.getCreationDate());
                    this.lastKeyUpdate = currentKey.getCreationDate();
                }
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Failed to fetch existing AuthenticationKeys from ZooKeeper");
        }
    }

    @VisibleForTesting
    long getLastKeyUpdate() {
        return this.lastKeyUpdate;
    }

    @VisibleForTesting
    int getIdSeq() {
        return this.idSeq;
    }

    void _run(long now) {
        int removedKeys = this.secretManager.removeExpiredKeys(this.keyDistributor);
        if (removedKeys > 0) {
            log.debug("Removed {} expired keys from the local cache", (Object)removedKeys);
        }
        if (this.lastKeyUpdate + this.keyUpdateInterval < now) {
            log.debug("Key update interval passed, creating new authentication key");
            AuthenticationKey newKey = new AuthenticationKey(++this.idSeq, now, now + this.tokenMaxLifetime, this.secretManager.generateSecret());
            log.debug("Created new {}", (Object)newKey);
            this.secretManager.addKey(newKey);
            try {
                this.keyDistributor.advertise(newKey);
            }
            catch (InterruptedException | KeeperException e) {
                log.error("Failed to advertise AuthenticationKey in ZooKeeper. Exiting.", e);
                throw new RuntimeException(e);
            }
            this.lastKeyUpdate = now;
        }
    }
}

