/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.Path;

public class ListVolumesUsed {
    public static void main(String[] args) throws Exception {
        ListVolumesUsed.listVolumes(new ServerContext(new SiteConfiguration()));
    }

    private static String getTableURI(String rootTabletDir) {
        Path ret = VolumeManager.FileType.TABLE.getVolume(new Path(rootTabletDir));
        if (ret == null) {
            return "RELATIVE";
        }
        return ret.toString();
    }

    private static String getLogURI(String logEntry) {
        Path ret = VolumeManager.FileType.WAL.getVolume(new Path(logEntry));
        if (ret == null) {
            return "RELATIVE";
        }
        return ret.toString();
    }

    private static void getLogURIs(TreeSet<String> volumes, LogEntry logEntry) {
        volumes.add(ListVolumesUsed.getLogURI(logEntry.filename));
    }

    private static void listZookeeper(ServerContext context) throws Exception {
        System.out.println("Listing volumes referenced in zookeeper");
        TreeSet<String> volumes = new TreeSet<String>();
        volumes.add(ListVolumesUsed.getTableURI(MetadataTableUtil.getRootTabletDir(context)));
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        MetadataTableUtil.getRootLogEntries(context, result);
        for (LogEntry logEntry : result) {
            ListVolumesUsed.getLogURIs(volumes, logEntry);
        }
        for (String volume : volumes) {
            System.out.println("\tVolume : " + volume);
        }
    }

    private static void listTable(String name, ServerContext context) throws Exception {
        System.out.println("Listing volumes referenced in " + name + " tablets section");
        Scanner scanner = context.createScanner(name, Authorizations.EMPTY);
        scanner.setRange(MetadataSchema.TabletsSection.getRange());
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
        TreeSet<String> volumes = new TreeSet<String>();
        for (Map.Entry entry : scanner) {
            if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                volumes.add(ListVolumesUsed.getTableURI(((Key)entry.getKey()).getColumnQualifier().toString()));
                continue;
            }
            if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LogColumnFamily.NAME)) {
                LogEntry le = LogEntry.fromKeyValue((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue()));
                ListVolumesUsed.getLogURIs(volumes, le);
                continue;
            }
            if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns((Key)entry.getKey())) continue;
            volumes.add(ListVolumesUsed.getTableURI(((Value)entry.getValue()).toString()));
        }
        for (String volume : volumes) {
            System.out.println("\tVolume : " + volume);
        }
        volumes.clear();
        scanner.clearColumns();
        scanner.setRange(MetadataSchema.DeletesSection.getRange());
        for (Map.Entry entry : scanner) {
            String delPath = ((Key)entry.getKey()).getRow().toString().substring(MetadataSchema.DeletesSection.getRowPrefix().length());
            volumes.add(ListVolumesUsed.getTableURI(delPath));
        }
        System.out.println("Listing volumes referenced in " + name + " deletes section (volume replacement occurrs at deletion time)");
        for (String volume : volumes) {
            System.out.println("\tVolume : " + volume);
        }
        volumes.clear();
        WalStateManager wals = new WalStateManager(context);
        for (Path path : wals.getAllState().keySet()) {
            volumes.add(ListVolumesUsed.getLogURI(path.toString()));
        }
        System.out.println("Listing volumes referenced in " + name + " current logs");
        for (String volume : volumes) {
            System.out.println("\tVolume : " + volume);
        }
    }

    public static void listVolumes(ServerContext context) throws Exception {
        ListVolumesUsed.listZookeeper(context);
        System.out.println();
        ListVolumesUsed.listTable(RootTable.NAME, context);
        System.out.println();
        ListVolumesUsed.listTable(MetadataTable.NAME, context);
    }
}

