/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.fs.VolumeChooserEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.htrace.TraceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomizeVolumes {
    private static final Logger log = LoggerFactory.getLogger(RandomizeVolumes.class);

    public static void main(String[] args) {
        RandomizeOpts opts = new RandomizeOpts();
        try (TraceScope clientSpan = opts.parseArgsAndTrace(RandomizeVolumes.class.getName(), args, new Object[0]);){
            ServerContext context = opts.getServerContext();
            try {
                int status = RandomizeVolumes.randomize(context, opts.tableName);
                System.exit(status);
            }
            catch (Exception ex) {
                log.error("{}", (Object)ex.getMessage(), (Object)ex);
                System.exit(4);
            }
        }
    }

    public static int randomize(ServerContext context, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        VolumeManager vm = context.getVolumeManager();
        if (vm.getVolumes().size() < 2) {
            log.error("There are not enough volumes configured");
            return 1;
        }
        String tblStr = (String)context.tableOperations().tableIdMap().get(tableName);
        if (tblStr == null) {
            log.error("Could not determine the table ID for table {}", (Object)tableName);
            return 2;
        }
        TableId tableId = TableId.of((String)tblStr);
        TableState tableState = context.getTableManager().getTableState(tableId);
        if (tableState != TableState.OFFLINE) {
            log.info("Taking {} offline", (Object)tableName);
            context.tableOperations().offline(tableName, true);
            log.info("{} offline", (Object)tableName);
        }
        SimpleThreadPool pool = new SimpleThreadPool(50, "directory maker");
        log.info("Rewriting entries for {}", (Object)tableName);
        Scanner scanner = context.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
        scanner.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
        BatchWriter writer = context.createBatchWriter(MetadataTable.NAME, null);
        int count = 0;
        for (Map.Entry entry : scanner) {
            String directory;
            String oldLocation = ((Value)entry.getValue()).toString();
            if (oldLocation.contains(":")) {
                String[] parts = oldLocation.split("/");
                TableId tableIdEntry = TableId.of((String)parts[parts.length - 2]);
                if (!tableIdEntry.equals((Object)tableId)) {
                    log.error("Unexpected table id found: {}, expected {}; skipping", (Object)tableIdEntry, (Object)tableId);
                    continue;
                }
                directory = parts[parts.length - 1];
            } else {
                directory = oldLocation.substring("/".length());
            }
            Key key = (Key)entry.getKey();
            Mutation m = new Mutation(key.getRow());
            VolumeChooserEnvironmentImpl chooserEnv = new VolumeChooserEnvironmentImpl(tableId, new KeyExtent(key.getRow(), (Text)null).getEndRow(), context);
            String newLocation = vm.choose(chooserEnv, ServerConstants.getBaseUris(context)) + "/" + "tables" + "/" + tableId + "/" + directory;
            m.put(key.getColumnFamily(), key.getColumnQualifier(), new Value(newLocation.getBytes(StandardCharsets.UTF_8)));
            if (log.isTraceEnabled()) {
                log.trace("Replacing {} with {}", (Object)oldLocation, (Object)newLocation);
            }
            writer.addMutation(m);
            pool.submit(() -> {
                try {
                    vm.mkdirs(new Path(newLocation));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            ++count;
        }
        writer.close();
        pool.shutdown();
        while (!pool.isTerminated()) {
            log.trace("Waiting for mkdir() calls to finish");
            try {
                pool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        log.info("Updated {} entries for table {}", (Object)count, (Object)tableName);
        if (tableState != TableState.OFFLINE) {
            context.tableOperations().online(tableName, true);
            log.info("table {} back online", (Object)tableName);
        }
        return 0;
    }

    static class RandomizeOpts
    extends ServerUtilOpts {
        @Parameter(names={"-t", "--table"}, required=true, description="table to use")
        String tableName;

        RandomizeOpts() {
        }
    }
}

