/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.ServerContext;

public class TabletServerLocks {
    public static void main(String[] args) throws Exception {
        try (ServerContext context = new ServerContext(new SiteConfiguration());){
            String tserverPath = context.getZooKeeperRoot() + "/tservers";
            Opts opts = new Opts();
            opts.parseArgs(TabletServerLocks.class.getName(), args, new Object[0]);
            ZooCache cache = context.getZooCache();
            ZooReaderWriter zoo = context.getZooReaderWriter();
            if (opts.list) {
                List tabletServers = zoo.getChildren(tserverPath);
                for (String tabletServer : tabletServers) {
                    byte[] lockData = ZooLock.getLockData((ZooCache)cache, (String)(tserverPath + "/" + tabletServer), null);
                    String holder = null;
                    if (lockData != null) {
                        holder = new String(lockData, StandardCharsets.UTF_8);
                    }
                    System.out.printf("%32s %16s%n", tabletServer, holder);
                }
            } else if (opts.delete != null) {
                ZooLock.deleteLock((IZooReaderWriter)zoo, (String)(tserverPath + "/" + args[1]));
            } else {
                System.out.println("Usage : " + TabletServerLocks.class.getName() + " -list|-delete <tserver lock>");
            }
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-list"})
        boolean list = false;
        @Parameter(names={"-delete"})
        String delete = null;

        Opts() {
        }
    }
}

