/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.tserver.log.CloseableIterator;
import org.apache.accumulo.tserver.log.RecoveryLogReader;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryLogsIterator
implements CloseableIterator<Map.Entry<LogFileKey, LogFileValue>> {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryLogsIterator.class);
    List<CloseableIterator<Map.Entry<LogFileKey, LogFileValue>>> iterators;
    private UnmodifiableIterator<Map.Entry<LogFileKey, LogFileValue>> iter;

    RecoveryLogsIterator(VolumeManager fs, List<Path> recoveryLogPaths, LogFileKey start, LogFileKey end) throws IOException {
        this.iterators = new ArrayList<CloseableIterator<Map.Entry<LogFileKey, LogFileValue>>>(recoveryLogPaths.size());
        try {
            for (Path log : recoveryLogPaths) {
                LOG.debug("Opening recovery log {}", (Object)log.getName());
                RecoveryLogReader rlr = new RecoveryLogReader(fs, log, start, end);
                if (rlr.hasNext()) {
                    LOG.debug("Write ahead log {} has data in range {} {}", new Object[]{log.getName(), start, end});
                    this.iterators.add(rlr);
                    continue;
                }
                LOG.debug("Write ahead log {} has no data in range {} {}", new Object[]{log.getName(), start, end});
                rlr.close();
            }
            this.iter = Iterators.mergeSorted(this.iterators, (o1, o2) -> ((LogFileKey)o1.getKey()).compareTo((LogFileKey)o2.getKey()));
        }
        catch (IOException | RuntimeException e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Map.Entry<LogFileKey, LogFileValue> next() {
        return (Map.Entry)this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() {
        for (CloseableIterator<Map.Entry<LogFileKey, LogFileValue>> reader : this.iterators) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close reader", (Throwable)e);
            }
        }
    }
}

