/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.IterConfigUtil;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.TimeSettingIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReportingIterator;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.TabletIteratorEnvironment;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.tablet.CompactionInfo;
import org.apache.accumulo.tserver.tablet.CompactionStats;
import org.apache.accumulo.tserver.tablet.CountingIterator;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compactor
implements Callable<CompactionStats> {
    private static final Logger log = LoggerFactory.getLogger(Compactor.class);
    private static final AtomicLong nextCompactorID = new AtomicLong(0L);
    private final Map<FileRef, DataFileValue> filesToCompact;
    private final InMemoryMap imm;
    private final FileRef outputFile;
    private final boolean propogateDeletes;
    private final AccumuloConfiguration acuTableConf;
    private final CompactionEnv env;
    private final VolumeManager fs;
    protected final KeyExtent extent;
    private final List<IteratorSetting> iterators;
    private String currentLocalityGroup = "";
    private final long startTime;
    private int reason;
    private final AtomicLong entriesRead = new AtomicLong(0L);
    private final AtomicLong entriesWritten = new AtomicLong(0L);
    private final DateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private final long compactorID = nextCompactorID.getAndIncrement();
    protected volatile Thread thread;
    private final ServerContext context;
    protected static final Set<Compactor> runningCompactions = Collections.synchronizedSet(new HashSet());

    public long getCompactorID() {
        return this.compactorID;
    }

    private synchronized void setLocalityGroup(String name) {
        this.currentLocalityGroup = name;
    }

    public synchronized String getCurrentLocalityGroup() {
        return this.currentLocalityGroup;
    }

    private void clearStats() {
        this.entriesRead.set(0L);
        this.entriesWritten.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompactionInfo> getRunningCompactions() {
        ArrayList<CompactionInfo> compactions = new ArrayList<CompactionInfo>();
        Set<Compactor> set = runningCompactions;
        synchronized (set) {
            for (Compactor compactor : runningCompactions) {
                compactions.add(new CompactionInfo(compactor));
            }
        }
        return compactions;
    }

    public Compactor(ServerContext context, Tablet tablet, Map<FileRef, DataFileValue> files, InMemoryMap imm, FileRef outputFile, boolean propogateDeletes, CompactionEnv env, List<IteratorSetting> iterators, int reason, AccumuloConfiguration tableConfiguation) {
        this.context = context;
        this.extent = tablet.getExtent();
        this.fs = tablet.getTabletServer().getFileSystem();
        this.acuTableConf = tableConfiguation;
        this.filesToCompact = files;
        this.imm = imm;
        this.outputFile = outputFile;
        this.propogateDeletes = propogateDeletes;
        this.env = env;
        this.iterators = iterators;
        this.reason = reason;
        this.startTime = System.currentTimeMillis();
    }

    public VolumeManager getFileSystem() {
        return this.fs;
    }

    KeyExtent getExtent() {
        return this.extent;
    }

    String getOutputFile() {
        return this.outputFile.toString();
    }

    MajorCompactionReason getMajorCompactionReason() {
        return MajorCompactionReason.values()[this.reason];
    }

    protected Map<String, Set<ByteSequence>> getLocalityGroups(AccumuloConfiguration acuTableConf) throws IOException {
        try {
            return LocalityGroupUtil.getLocalityGroups((AccumuloConfiguration)acuTableConf);
        }
        catch (LocalityGroupUtil.LocalityGroupConfigurationError e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionStats call() throws IOException, CompactionCanceledException {
        FileSKVWriter mfw = null;
        CompactionStats majCStats = new CompactionStats();
        boolean remove = runningCompactions.add(this);
        this.clearStats();
        Path outputFilePath = this.outputFile.path();
        String outputFilePathName = outputFilePath.toString();
        String oldThreadName = Thread.currentThread().getName();
        String newThreadName = "MajC compacting " + this.extent + " started " + this.dateFormatter.format(new Date()) + " file: " + this.outputFile;
        Thread.currentThread().setName(newThreadName);
        this.thread = Thread.currentThread();
        try {
            FileOperations fileFactory = FileOperations.getInstance();
            FileSystem ns = this.fs.getVolumeByPath(outputFilePath).getFileSystem();
            mfw = fileFactory.newWriterBuilder().forFile(outputFilePathName, ns, ns.getConf(), this.context.getCryptoService()).withTableConfiguration(this.acuTableConf).withRateLimiter(this.env.getWriteLimiter()).build();
            Map<String, Set<ByteSequence>> lGroups = this.getLocalityGroups(this.acuTableConf);
            long t1 = System.currentTimeMillis();
            HashSet<ByteSequence> allColumnFamilies = new HashSet<ByteSequence>();
            if (mfw.supportsLocalityGroups()) {
                for (Map.Entry<String, Set<ByteSequence>> entry : lGroups.entrySet()) {
                    this.setLocalityGroup(entry.getKey());
                    this.compactLocalityGroup(entry.getKey(), entry.getValue(), true, mfw, majCStats);
                    allColumnFamilies.addAll((Collection<ByteSequence>)entry.getValue());
                }
            }
            this.setLocalityGroup("");
            this.compactLocalityGroup(null, allColumnFamilies, false, mfw, majCStats);
            long t2 = System.currentTimeMillis();
            FileSKVWriter mfwTmp = mfw;
            mfw = null;
            try {
                mfwTmp.close();
            }
            catch (IOException ex) {
                if (!this.fs.deleteRecursively(this.outputFile.path()) && this.fs.exists(this.outputFile.path())) {
                    log.error("Unable to delete {}", (Object)this.outputFile);
                }
                throw ex;
            }
            log.debug(String.format("Compaction %s %,d read | %,d written | %,6d entries/sec | %,6.3f secs | %,12d bytes | %9.3f byte/sec", this.extent, majCStats.getEntriesRead(), majCStats.getEntriesWritten(), (int)((double)majCStats.getEntriesRead() / ((double)(t2 - t1) / 1000.0)), (double)(t2 - t1) / 1000.0, mfwTmp.getLength(), (double)mfwTmp.getLength() / ((double)(t2 - t1) / 1000.0)));
            majCStats.setFileSize(mfwTmp.getLength());
            CompactionStats compactionStats = majCStats;
            return compactionStats;
        }
        catch (IOException | RuntimeException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        finally {
            block21: {
                Thread.currentThread().setName(oldThreadName);
                if (remove) {
                    this.thread = null;
                    runningCompactions.remove(this);
                }
                try {
                    if (mfw == null) break block21;
                    try {
                        mfw.close();
                    }
                    finally {
                        if (!this.fs.deleteRecursively(this.outputFile.path()) && this.fs.exists(this.outputFile.path())) {
                            log.error("Unable to delete {}", (Object)this.outputFile);
                        }
                    }
                }
                catch (IOException | RuntimeException e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private List<SortedKeyValueIterator<Key, Value>> openMapDataFiles(ArrayList<FileSKVIterator> readers) throws IOException {
        ArrayList<SortedKeyValueIterator<Key, Value>> iters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.filesToCompact.size());
        for (FileRef mapFile : this.filesToCompact.keySet()) {
            try {
                FileOperations fileFactory = FileOperations.getInstance();
                FileSystem fs = this.fs.getVolumeByPath(mapFile.path()).getFileSystem();
                FileSKVIterator reader = fileFactory.newReaderBuilder().forFile(mapFile.path().toString(), fs, fs.getConf(), this.context.getCryptoService()).withTableConfiguration(this.acuTableConf).withRateLimiter(this.env.getReadLimiter()).build();
                readers.add(reader);
                ProblemReportingIterator iter = new ProblemReportingIterator(this.context, this.extent.getTableId(), mapFile.path().toString(), false, (SortedKeyValueIterator)reader);
                if (this.filesToCompact.get(mapFile).isTimeSet()) {
                    iter = new TimeSettingIterator((SortedKeyValueIterator)iter, this.filesToCompact.get(mapFile).getTime());
                }
                iters.add((SortedKeyValueIterator<Key, Value>)iter);
            }
            catch (Throwable e) {
                ProblemReports.getInstance((ServerContext)this.context).report(new ProblemReport(this.extent.getTableId(), ProblemType.FILE_READ, mapFile.path().toString(), e));
                log.warn("Some problem opening map file {} {}", new Object[]{mapFile, e.getMessage(), e});
                for (FileSKVIterator reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e2) {
                        log.warn("Failed to close map file", e2);
                    }
                }
                readers.clear();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException("Failed to open map data files", e);
            }
        }
        return iters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactLocalityGroup(String lgName, Set<ByteSequence> columnFamilies, boolean inclusive, FileSKVWriter mfw, CompactionStats majCStats) throws IOException, CompactionCanceledException {
        ArrayList<FileSKVIterator> readers;
        block35: {
            readers = new ArrayList<FileSKVIterator>(this.filesToCompact.size());
            try (TraceScope span = Trace.startSpan((String)"compact");){
                TabletIteratorEnvironment iterEnv;
                long entriesCompacted = 0L;
                List<SortedKeyValueIterator<Key, Value>> iters = this.openMapDataFiles(readers);
                if (this.imm != null) {
                    iters.add(this.imm.compactionIterator());
                }
                CountingIterator citr = new CountingIterator((SortedKeyValueIterator<Key, Value>)new MultiIterator(iters, this.extent.toDataRange()), this.entriesRead);
                SortedKeyValueIterator delIter = DeletingIterator.wrap((SortedKeyValueIterator)citr, (boolean)this.propogateDeletes, (DeletingIterator.Behavior)DeletingIterator.getBehavior((AccumuloConfiguration)this.acuTableConf));
                ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator(delIter);
                if (this.env.getIteratorScope() == IteratorUtil.IteratorScope.majc) {
                    iterEnv = new TabletIteratorEnvironment(this.context, IteratorUtil.IteratorScope.majc, !this.propogateDeletes, this.acuTableConf, this.getExtent().getTableId(), this.getMajorCompactionReason());
                } else if (this.env.getIteratorScope() == IteratorUtil.IteratorScope.minc) {
                    iterEnv = new TabletIteratorEnvironment(this.context, IteratorUtil.IteratorScope.minc, this.acuTableConf, this.getExtent().getTableId());
                } else {
                    throw new IllegalArgumentException();
                }
                SortedKeyValueIterator<Key, Value> itr = iterEnv.getTopLevelIterator((SortedKeyValueIterator<Key, Value>)IterConfigUtil.convertItersAndLoad((IteratorUtil.IteratorScope)this.env.getIteratorScope(), (SortedKeyValueIterator)cfsi, (AccumuloConfiguration)this.acuTableConf, this.iterators, (IteratorEnvironment)iterEnv));
                itr.seek(this.extent.toDataRange(), columnFamilies, inclusive);
                if (!inclusive) {
                    mfw.startDefaultLocalityGroup();
                } else {
                    mfw.startNewLocalityGroup(lgName, columnFamilies);
                }
                try (TraceScope write = Trace.startSpan((String)"write");){
                    while (itr.hasTop() && this.env.isCompactionEnabled()) {
                        mfw.append((Key)itr.getTopKey(), (Value)itr.getTopValue());
                        itr.next();
                        if (++entriesCompacted % 1024L != 0L) continue;
                        this.entriesWritten.addAndGet(1024L);
                    }
                    if (!itr.hasTop() || this.env.isCompactionEnabled()) break block35;
                    try {
                        try {
                            mfw.close();
                        }
                        catch (IOException e) {
                            log.error("{}", (Object)e.getMessage(), (Object)e);
                        }
                        this.fs.deleteRecursively(this.outputFile.path());
                    }
                    catch (Exception e) {
                        log.warn("Failed to delete Canceled compaction output file {}", (Object)this.outputFile, (Object)e);
                    }
                    throw new CompactionCanceledException();
                }
                finally {
                    CompactionStats lgMajcStats = new CompactionStats(citr.getCount(), entriesCompacted);
                    majCStats.add(lgMajcStats);
                }
            }
            catch (Throwable throwable) {
                for (FileSKVIterator reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e) {
                        log.warn("Failed to close map file", e);
                    }
                }
                throw throwable;
            }
        }
        for (FileSKVIterator reader : readers) {
            try {
                reader.close();
            }
            catch (Throwable e) {
                log.warn("Failed to close map file", e);
            }
        }
    }

    Collection<FileRef> getFilesToCompact() {
        return this.filesToCompact.keySet();
    }

    boolean hasIMM() {
        return this.imm != null;
    }

    boolean willPropogateDeletes() {
        return this.propogateDeletes;
    }

    long getEntriesRead() {
        return this.entriesRead.get();
    }

    long getEntriesWritten() {
        return this.entriesWritten.get();
    }

    long getStartTime() {
        return this.startTime;
    }

    Iterable<IteratorSetting> getIterators() {
        return this.iterators;
    }

    MinorCompactionReason getMinCReason() {
        return MinorCompactionReason.values()[this.reason];
    }

    public static interface CompactionEnv {
        public boolean isCompactionEnabled();

        public IteratorUtil.IteratorScope getIteratorScope();

        public RateLimiter getReadLimiter();

        public RateLimiter getWriteLimiter();
    }

    public static class CompactionCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

