/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.AbstractJSONDataSource;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;

public abstract class AbstractJSONOMBuilder
implements Builder {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        Reader reader;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        String localName = "";
        String prefix = "";
        OMNamespace ns = factory.createOMNamespace("", "");
        messageContext.setDoingREST(true);
        if (inputStream == null) {
            String requestURL;
            EndpointReference endpointReference = messageContext.getTo();
            if (endpointReference == null) {
                throw new AxisFault("Cannot create DocumentElement without destination EPR");
            }
            try {
                requestURL = URIEncoderDecoder.decode((String)endpointReference.getAddress());
            }
            catch (UnsupportedEncodingException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            int index = requestURL.indexOf("=");
            if (index <= 0) throw new AxisFault("No JSON message received through HTTP GET or POST");
            String jsonString = requestURL.substring(index + 1);
            reader = new StringReader(jsonString);
        } else {
            String charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEncoding == null) {
                charSetEncoding = "UTF-8";
            }
            try {
                reader = new InputStreamReader(inputStream, charSetEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw AxisFault.makeFault((Throwable)ex);
            }
        }
        try {
            char temp = (char)reader.read();
            while (temp != ':') {
                if (temp != ' ' && temp != '{' && temp != '\n' && temp != '\r' && temp != '\t') {
                    localName = localName + temp;
                }
                temp = (char)reader.read();
            }
            if (localName.charAt(0) == '\"') {
                if (localName.charAt(localName.length() - 1) == '\"') {
                    localName = localName.substring(1, localName.length() - 1);
                } else {
                    prefix = localName.substring(1, localName.length()) + ":";
                    localName = "";
                    temp = (char)reader.read();
                    while (temp != ':') {
                        if (temp != ' ') {
                            localName = localName + temp;
                        }
                        temp = (char)reader.read();
                    }
                    localName = localName.substring(0, localName.length() - 1);
                }
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        AbstractJSONDataSource jsonDataSource = this.getDataSource(reader, prefix, localName);
        return factory.createOMElement((OMDataSource)jsonDataSource, localName, ns);
    }

    protected abstract AbstractJSONDataSource getDataSource(Reader var1, String var2, String var3);
}

