/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTable;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTransport;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

public class ElasticsearchSchema
extends AbstractSchema {
    private final RestClient client;
    private final ObjectMapper mapper;
    private final Map<String, Table> tableMap;
    private final int fetchSize;

    public ElasticsearchSchema(RestClient client, ObjectMapper mapper, String index) {
        this(client, mapper, index, 5196);
    }

    @VisibleForTesting
    ElasticsearchSchema(RestClient client, ObjectMapper mapper, String index, int fetchSize) {
        this.client = Objects.requireNonNull(client, "client");
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (String)"invalid fetch size. Expected %s > 0", (int)fetchSize);
        this.fetchSize = fetchSize;
        if (index == null) {
            try {
                this.tableMap = this.createTables(this.indicesFromElastic());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Couldn't get indices", e);
            }
        } else {
            this.tableMap = this.createTables(Collections.singleton(index));
        }
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private Map<String, Table> createTables(Iterable<String> indices) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String index : indices) {
            ElasticsearchTransport transport = new ElasticsearchTransport(this.client, this.mapper, index, this.fetchSize);
            builder.put((Object)index, (Object)new ElasticsearchTable(transport));
        }
        return builder.build();
    }

    private Set<String> indicesFromElastic() throws IOException {
        String endpoint = "/_alias";
        Response response = this.client.performRequest(new Request("GET", "/_alias"));
        try (InputStream is = response.getEntity().getContent();){
            JsonNode root = this.mapper.readTree(is);
            if (!root.isObject() || root.size() <= 0) {
                String message = String.format(Locale.ROOT, "Invalid response for %s/%s Expected object of at least size 1 got %s (of size %d)", response.getHost(), response.getRequestLine(), root.getNodeType(), root.size());
                throw new IllegalStateException(message);
            }
            HashSet indices = Sets.newHashSet((Iterator)root.fieldNames());
            Set aliases = root.findValues("aliases").stream().map(JsonNode::fieldNames).flatMap(it -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false)).collect(Collectors.toSet());
            indices.addAll(aliases);
            HashSet hashSet = indices;
            return hashSet;
        }
    }
}

