/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.util.UnsafeX509ExtendedTrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSchemaFactory
implements SchemaFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSchemaFactory.class);
    private static final int REST_CLIENT_CACHE_SIZE = 100;
    private static final Cache<List, RestClient> REST_CLIENTS = CacheBuilder.newBuilder().maximumSize(100L).removalListener((RemovalListener)new RemovalListener<List, RestClient>(){

        public void onRemoval(RemovalNotification<List, RestClient> notice) {
            LOGGER.warn("Will close an ES REST client to keep the number of open clients under {}. Any schema objects that might still have been relying on this client are now broken! Do not try to access more than {} distinct ES REST APIs through this adapter.", (Object)100, (Object)100);
            try {
                ((RestClient)notice.getValue()).close();
            }
            catch (IOException ex) {
                LOGGER.warn("Could not close RestClient {}", notice.getValue(), (Object)ex);
            }
        }
    }).build();

    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        Map<String, Object> map = operand;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        try {
            boolean disableSSLVerification;
            List<HttpHost> hosts;
            if (map.containsKey("hosts")) {
                List configHosts = (List)mapper.readValue((String)map.get("hosts"), (TypeReference)new TypeReference<List<String>>(){});
                hosts = configHosts.stream().map(host -> HttpHost.create((String)host)).collect(Collectors.toList());
            } else if (map.containsKey("coordinates")) {
                Map coordinates = (Map)mapper.readValue((String)map.get("coordinates"), (TypeReference)new TypeReference<Map<String, Integer>>(){});
                hosts = coordinates.entrySet().stream().map(entry -> new HttpHost((String)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
                LOGGER.warn("Prefer using hosts, coordinates is deprecated.");
            } else {
                throw new IllegalArgumentException("Both 'coordinates' and 'hosts' is missing in configuration. Provide one of them.");
            }
            String pathPrefix = (String)map.get("pathPrefix");
            if (map.containsKey("disableSSLVerification")) {
                String temp = (String)map.get("disableSSLVerification");
                disableSSLVerification = Boolean.getBoolean(temp.toLowerCase(Locale.ROOT));
            } else {
                disableSSLVerification = false;
            }
            String username = (String)map.get("username");
            String password = (String)map.get("password");
            RestClient client = ElasticsearchSchemaFactory.connect(hosts, pathPrefix, username, password, disableSSLVerification);
            String index = (String)map.get("index");
            return new ElasticsearchSchema(client, new ObjectMapper(), index);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot parse values from json", e);
        }
    }

    private static RestClient connect(final List<HttpHost> hosts, final String pathPrefix, final String username, final String password, final boolean disableSSLVerification) {
        Objects.requireNonNull(hosts, "hosts or coordinates");
        Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"no ES hosts specified");
        ImmutableList cacheKey = ImmutableList.of(hosts, (Object)pathPrefix, (Object)username, (Object)password);
        try {
            return (RestClient)REST_CLIENTS.get((Object)cacheKey, (Callable)new Callable<RestClient>(){

                @Override
                public RestClient call() throws NoSuchAlgorithmException, KeyManagementException {
                    RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[hosts.size()]));
                    if (!Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password)) {
                        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                        builder.setHttpClientConfigCallback(arg_0 -> 4.lambda$call$0((CredentialsProvider)credentialsProvider, arg_0));
                    }
                    if (disableSSLVerification) {
                        SSLContext sslContext = SSLContext.getInstance("TLS");
                        sslContext.init(null, new TrustManager[]{UnsafeX509ExtendedTrustManager.getInstance()}, null);
                        builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(sslContext).setSSLHostnameVerifier((host, session) -> true));
                    }
                    if (pathPrefix != null && !pathPrefix.isEmpty()) {
                        builder.setPathPrefix(pathPrefix);
                    }
                    return builder.build();
                }

                private static /* synthetic */ HttpAsyncClientBuilder lambda$call$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
                    return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                }
            });
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Cannot return a cached RestClient", ex);
        }
    }
}

