/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.inject.Qualifier;

@Qualifier
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
public @interface Uri {
    @Nonbinding
    public String value();

    @Deprecated
    @Nonbinding
    public String context() default "";

    public static final class Literal
    extends AnnotationLiteral<Uri>
    implements Uri {
        private static final long serialVersionUID = 1L;
        private final String uri;

        private Literal(String uri) {
            this.uri = uri;
        }

        public static Literal of(String uri) {
            return new Literal(uri);
        }

        @Override
        public String value() {
            return this.uri;
        }

        @Override
        public String context() {
            return "";
        }
    }
}

