/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.main.junit5;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.InterceptSendToMockEndpointStrategy;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.BreakpointSupport;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.test.main.junit5.AdviceRouteMapping;
import org.apache.camel.test.main.junit5.CamelMainTest;
import org.apache.camel.test.main.junit5.Configure;
import org.apache.camel.test.main.junit5.DebuggerCallback;
import org.apache.camel.test.main.junit5.MainForTest;
import org.apache.camel.test.main.junit5.ReplaceInRegistry;
import org.apache.camel.util.ReflectionHelper;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

final class CamelMainContext
implements ExtensionContext.Store.CloseableResource {
    private final ModelCamelContext camelContext;

    private CamelMainContext(ModelCamelContext camelContext) {
        this.camelContext = camelContext;
    }

    ModelCamelContext context() {
        return this.camelContext;
    }

    void start() {
        this.camelContext.start();
    }

    public void close() throws Exception {
        this.camelContext.close();
    }

    static Builder builder(ExtensionContext context) {
        return new Builder(context);
    }

    static final class Builder {
        private final List<CamelMainTest> annotations;
        private final List<Object> instances;
        private boolean useJmx;

        private Builder(ExtensionContext context) {
            this.instances = context.getRequiredTestInstances().getAllInstances();
            this.annotations = this.instances.stream().map(Object::getClass).filter(tClass -> tClass.isAnnotationPresent(CamelMainTest.class)).map(tClass -> tClass.getAnnotation(CamelMainTest.class)).collect(Collectors.toList());
        }

        Builder useJmx(boolean useJmx) {
            this.useJmx = useJmx;
            return this;
        }

        CamelMainContext build() throws Exception {
            DefaultCamelContext camelContext = new DefaultCamelContext();
            ExtendedCamelContext extendedCamelContext = (ExtendedCamelContext)camelContext.getExtension(ExtendedCamelContext.class);
            this.mockEndpointsIfNeeded(extendedCamelContext);
            this.configureShutdownTimeout((ModelCamelContext)camelContext);
            this.configureDebuggerIfNeeded((ModelCamelContext)camelContext);
            this.initCamelContext((ModelCamelContext)camelContext);
            CamelBeanPostProcessor beanPostProcessor = extendedCamelContext.getBeanPostProcessor();
            for (Object instance : this.instances) {
                this.initInstance(beanPostProcessor, instance);
                this.replaceBeansInRegistry(camelContext.getRegistry(), instance);
            }
            for (CamelMainTest annotation : this.annotations) {
                this.applyReplaceRouteFromWith((ModelCamelContext)camelContext, annotation);
                this.adviceRoutes((ModelCamelContext)camelContext, beanPostProcessor, annotation);
            }
            return new CamelMainContext((ModelCamelContext)camelContext);
        }

        private void configureShutdownTimeout(ModelCamelContext context) {
            context.getShutdownStrategy().setTimeout((long)this.getOuterClassAnnotation().shutdownTimeout());
        }

        private void initInstance(CamelBeanPostProcessor beanPostProcessor, Object instance) throws Exception {
            Class<?> requiredTestClass = instance.getClass();
            beanPostProcessor.postProcessBeforeInitialization(instance, requiredTestClass.getName());
            beanPostProcessor.postProcessAfterInitialization(instance, requiredTestClass.getName());
        }

        private void mockEndpointsIfNeeded(ExtendedCamelContext context) {
            boolean mockEndpointsSet = false;
            boolean mockEndpointsAndSkipSet = false;
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CamelMainTest annotation = this.annotations.get(i);
                String mockEndpoints = annotation.mockEndpoints();
                if (!mockEndpointsSet && !mockEndpoints.isEmpty()) {
                    mockEndpointsSet = true;
                    context.registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockEndpoints));
                }
                String mockEndpointsAndSkip = annotation.mockEndpointsAndSkip();
                if (mockEndpointsAndSkipSet || mockEndpointsAndSkip.isEmpty()) continue;
                mockEndpointsAndSkipSet = true;
                context.registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockEndpointsAndSkip, true));
            }
        }

        private void configureDebuggerIfNeeded(ModelCamelContext context) {
            Object instance = this.getOuterClassInstance();
            if (instance instanceof DebuggerCallback) {
                context.setDebugging(Boolean.valueOf(true));
                context.setDebugger((Debugger)new DefaultDebugger());
                final DebuggerCallback callback = (DebuggerCallback)instance;
                context.getDebugger().addBreakpoint((Breakpoint)new BreakpointSupport(){

                    public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
                        callback.debugBefore(exchange, processor, (ProcessorDefinition)definition, definition.getId(), definition.getLabel());
                    }

                    public void afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
                        callback.debugAfter(exchange, processor, (ProcessorDefinition)definition, definition.getId(), definition.getLabel(), timeTaken);
                    }
                });
            }
        }

        private void initCamelContext(ModelCamelContext context) throws Exception {
            this.createMainForTest().init((CamelContext)context);
        }

        private MainForTest createMainForTest() {
            MainForTest main = new MainForTest();
            main.configure().setJmxEnabled(this.useJmx);
            for (CamelMainTest annotation : this.annotations) {
                this.configureMainClass(main, annotation);
                this.addConfigurationClasses(main, annotation);
                this.configureOverrideProperties(main, annotation);
                this.configurePropertyPlaceholderLocations(main, annotation);
            }
            for (Object instance : this.instances) {
                this.invokeConfigureMethods(main, instance);
            }
            return main;
        }

        private void configureMainClass(MainForTest main, CamelMainTest annotation) {
            Class<?> mainClass = annotation.mainClass();
            if (mainClass != Void.TYPE) {
                main.configure().withBasePackageScan(mainClass.getPackageName());
            }
        }

        private void addConfigurationClasses(MainForTest main, CamelMainTest annotation) {
            for (Class<? extends CamelConfiguration> configurationClass : annotation.configurationClasses()) {
                main.configure().addConfiguration(configurationClass);
            }
        }

        private void adviceRoutes(ModelCamelContext context, CamelBeanPostProcessor beanPostProcessor, CamelMainTest annotation) throws Exception {
            for (AdviceRouteMapping adviceRouteMapping : annotation.advices()) {
                Class<? extends RouteBuilder> adviceClass = adviceRouteMapping.advice();
                try {
                    Constructor<? extends RouteBuilder> constructor = adviceClass.getDeclaredConstructor(new Class[0]);
                    if (!constructor.trySetAccessible()) {
                        throw new RuntimeCamelException(String.format("The default constructor of the class %s is not accessible since it is in a package that is not opened to the extension.", adviceClass.getName()));
                    }
                    RouteBuilder advice = adviceClass.cast(constructor.newInstance(new Object[0]));
                    beanPostProcessor.postProcessBeforeInitialization((Object)advice, advice.getClass().getName());
                    beanPostProcessor.postProcessAfterInitialization((Object)advice, advice.getClass().getName());
                    AdviceWith.adviceWith((RouteDefinition)context.getRouteDefinition(adviceRouteMapping.route()), (CamelContext)context, (RouteBuilder)advice);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeCamelException(String.format("Could not find the default constructor of the class %s.", adviceClass.getName()), (Throwable)e);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            }
        }

        private void applyReplaceRouteFromWith(ModelCamelContext context, CamelMainTest annotation) throws Exception {
            for (final String fromEndpoint : annotation.replaceRouteFromWith()) {
                final int index = fromEndpoint.indexOf(61);
                if (index == -1) {
                    throw new RuntimeCamelException("The attribute replaceRouteFromWith doesn't have the expected format, it should be of type \"route-id-1=new-uri-1\", ...");
                }
                AdviceWith.adviceWith((RouteDefinition)context.getRouteDefinition(fromEndpoint.substring(0, index)), (CamelContext)context, (RouteBuilder)new AdviceWithRouteBuilder(){

                    public void configure() {
                        this.replaceFromWith(fromEndpoint.substring(index + 1));
                    }
                });
            }
        }

        private void replaceBeansInRegistry(Registry registry, Object instance) {
            Class<?> requiredTestClass = instance.getClass();
            for (Method method : AnnotationSupport.findAnnotatedMethods(requiredTestClass, ReplaceInRegistry.class, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN)) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length == 0) {
                    if (method.trySetAccessible()) {
                        registry.bind(method.getName(), method.getReturnType(), ObjectHelper.invokeMethod((Method)method, (Object)instance, (Object[])new Object[0]));
                        continue;
                    }
                    throw new RuntimeCamelException(String.format("The method %s is not accessible since it is in a package that is not opened to the extension.", method.getName()));
                }
                throw new RuntimeCamelException(String.format("The method %s should not have any parameter.", method.getName()));
            }
            ReflectionHelper.doWithFields(requiredTestClass, field -> {
                if (field.isAnnotationPresent(ReplaceInRegistry.class)) {
                    if (field.trySetAccessible()) {
                        registry.bind(field.getName(), field.getType(), ReflectionHelper.getField((Field)field, (Object)instance));
                    } else {
                        throw new RuntimeCamelException(String.format("The field %s is not accessible since it is in a package that is not opened to the extension.", field.getName()));
                    }
                }
            });
        }

        private void invokeConfigureMethods(MainForTest main, Object instance) {
            for (Method method : AnnotationSupport.findAnnotatedMethods(instance.getClass(), Configure.class, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN)) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length == 1 && parameterTypes[0] == MainConfigurationProperties.class) {
                    if (method.trySetAccessible()) {
                        ObjectHelper.invokeMethod((Method)method, (Object)instance, (Object[])new Object[]{main.configure()});
                        continue;
                    }
                    throw new RuntimeCamelException(String.format("The method %s is not accessible since it is in a package that is not opened to the extension.", method.getName()));
                }
                throw new RuntimeCamelException(String.format("The method %s should have one single parameter of type MainConfigurationProperties.", method.getName()));
            }
        }

        private void configureOverrideProperties(MainForTest main, CamelMainTest annotation) {
            for (String property : annotation.properties()) {
                int index = property.indexOf(61);
                if (index == -1) {
                    throw new RuntimeCamelException("The attribute properties doesn't have the expected format, it should be of type \"key-1=value-1\", ...");
                }
                main.addOverrideProperty(property.substring(0, index), property.substring(index + 1));
            }
        }

        private void configurePropertyPlaceholderLocations(MainForTest main, CamelMainTest annotation) {
            CharSequence[] locations = annotation.propertyPlaceholderLocations();
            if (locations.length == 0) {
                String fileName = annotation.propertyPlaceholderFileName();
                if (!fileName.isEmpty()) {
                    main.setPropertyPlaceholderLocations(String.format("classpath:%s/%s;optional=true,classpath:%s;optional=true", this.getOuterClassInstance().getClass().getPackageName().replace('.', '/'), fileName, fileName));
                }
            } else {
                main.setPropertyPlaceholderLocations(String.join((CharSequence)",", locations));
            }
        }

        private Object getOuterClassInstance() {
            return this.instances.get(0);
        }

        private CamelMainTest getOuterClassAnnotation() {
            return this.annotations.get(0);
        }
    }
}

