/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;

public class CXFCdiServlet
extends CXFNonSpringServlet {
    private static final long serialVersionUID = -2890970731778523861L;
    private boolean busCreated;

    @Inject
    public void setBus(Bus bus) {
        super.setBus(bus);
    }

    protected void loadBus(ServletConfig servletConfig) {
        Set candidates;
        Bus bus = null;
        BeanManager beanManager = CDI.current().getBeanManager();
        if (beanManager != null && !(candidates = beanManager.getBeans("cxf")).isEmpty()) {
            Bean candidate = beanManager.resolve(candidates);
            bus = (Bus)beanManager.getReference(candidate, Bus.class, beanManager.createCreationalContext((Contextual)candidate));
        }
        if (bus != null) {
            this.setBus(bus);
        } else {
            this.busCreated = true;
            this.setBus(BusFactory.newInstance().createBus());
        }
    }

    public void destroyBus() {
        if (this.busCreated) {
            this.getBus().shutdown(true);
            this.setBus(null);
        }
    }
}

