/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.event.GoToBrowserEvent;
import org.apache.cxf.management.web.browser.client.event.GoToBrowserEventHandler;
import org.apache.cxf.management.web.browser.client.event.GoToEditCriteriaEvent;
import org.apache.cxf.management.web.browser.client.event.GoToEditCriteriaEventHandler;
import org.apache.cxf.management.web.browser.client.event.GoToSettingsEvent;
import org.apache.cxf.management.web.browser.client.event.GoToSettingsEventHandler;
import org.apache.cxf.management.web.browser.client.service.settings.SettingsFacade;
import org.apache.cxf.management.web.browser.client.ui.Presenter;
import org.apache.cxf.management.web.browser.client.ui.browser.BrowsePresenter;
import org.apache.cxf.management.web.browser.client.ui.browser.EditCriteriaPresenter;
import org.apache.cxf.management.web.browser.client.ui.settings.SettingsPresenter;

public class Dispatcher {
    @Nonnull
    private final EventBus eventBus;
    @Nonnull
    private final Provider<BrowsePresenter> browseProvider;
    @Nonnull
    private final Provider<EditCriteriaPresenter> editCriteriaProvider;
    @Nonnull
    private final Provider<SettingsPresenter> settingsProvider;
    @Nonnull
    private final SettingsFacade settingsFacade;
    @Nullable
    private Presenter currentPresenter;

    @Inject
    public Dispatcher(@Nonnull EventBus eventBus, @Nonnull SettingsFacade settingsFacade, @Nonnull Provider<BrowsePresenter> browseProvider, @Nonnull Provider<EditCriteriaPresenter> editCriteriaProvider, @Nonnull Provider<SettingsPresenter> settingsProvider) {
        this.eventBus = eventBus;
        this.browseProvider = browseProvider;
        this.editCriteriaProvider = editCriteriaProvider;
        this.settingsProvider = settingsProvider;
        this.settingsFacade = settingsFacade;
        this.bind();
    }

    public void start() {
        this.settingsFacade.initialize(SettingsFacade.StorageStrategy.REMOTE);
        this.eventBus.fireEvent((GwtEvent)new GoToBrowserEvent());
    }

    private void go(@Nonnull Presenter newPresenter) {
        if (this.currentPresenter != null) {
            this.currentPresenter.unbind();
        }
        this.currentPresenter = newPresenter;
        this.currentPresenter.go((HasWidgets)RootLayoutPanel.get());
    }

    private void bind() {
        this.eventBus.addHandler(GoToBrowserEvent.TYPE, (EventHandler)new GoToBrowserEventHandler(){

            @Override
            public void onGoToBrowser(@Nonnull GoToBrowserEvent event) {
                Dispatcher.this.go((Presenter)Dispatcher.this.browseProvider.get());
            }
        });
        this.eventBus.addHandler(GoToEditCriteriaEvent.TYPE, (EventHandler)new GoToEditCriteriaEventHandler(){

            @Override
            public void onGoToEditCriteria(@Nonnull GoToEditCriteriaEvent event) {
                Dispatcher.this.go((Presenter)Dispatcher.this.editCriteriaProvider.get());
            }
        });
        this.eventBus.addHandler(GoToSettingsEvent.TYPE, (EventHandler)new GoToSettingsEventHandler(){

            @Override
            public void onGoToSettings(@Nonnull GoToSettingsEvent event) {
                Dispatcher.this.go((Presenter)Dispatcher.this.settingsProvider.get());
            }
        });
    }
}

