/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.blueprint;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.TLSServerParametersConfig;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transports.http_jetty.configuration.JettyHTTPServerEngineConfigType;
import org.apache.cxf.transports.http_jetty.configuration.JettyHTTPServerEngineFactoryConfigType;
import org.apache.cxf.transports.http_jetty.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JettyHTTPServerEngineFactoryHolder {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPServerEngineFactoryHolder.class);
    private String parsedElement;
    private JettyHTTPServerEngineFactory factory;
    private JAXBContext jaxbContext;
    private Set<Class<?>> jaxbClasses;

    public void init() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            Element element = docFactory.newDocumentBuilder().parse(new ByteArrayInputStream(this.parsedElement.getBytes())).getDocumentElement();
            JettyHTTPServerEngineFactoryConfigType config = (JettyHTTPServerEngineFactoryConfigType)this.getJaxbObject(element, JettyHTTPServerEngineFactoryConfigType.class);
            this.factory = new JettyHTTPServerEngineFactory();
            TreeMap<String, ThreadingParameters> threadingParametersMap = new TreeMap<String, ThreadingParameters>();
            if (config.getIdentifiedThreadingParameters() != null) {
                for (ThreadingParametersIdentifiedType threads : config.getIdentifiedThreadingParameters()) {
                    ThreadingParameters rThreads = new ThreadingParameters();
                    String id = threads.getId();
                    rThreads.setMaxThreads(threads.getThreadingParameters().getMaxThreads());
                    rThreads.setMinThreads(threads.getThreadingParameters().getMinThreads());
                    threadingParametersMap.put(id, rThreads);
                }
                this.factory.setThreadingParametersMap(threadingParametersMap);
            }
            TreeMap<String, TLSServerParameters> sslMap = new TreeMap<String, TLSServerParameters>();
            if (config.getIdentifiedTLSServerParameters() != null) {
                for (TLSServerParametersIdentifiedType t : config.getIdentifiedTLSServerParameters()) {
                    try {
                        TLSServerParametersConfig parameter = new TLSServerParametersConfig(t.getTlsServerParameters());
                        sslMap.put(t.getId(), (TLSServerParameters)parameter);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not configure TLS for id " + t.getId(), e);
                    }
                }
                this.factory.setTlsServerParametersMap(sslMap);
            }
            ArrayList<JettyHTTPServerEngine> engineList = new ArrayList<JettyHTTPServerEngine>();
            for (JettyHTTPServerEngineConfigType engine : config.getEngine()) {
                JettyHTTPServerEngine eng = new JettyHTTPServerEngine();
                if (engine.isContinuationsEnabled() != null) {
                    eng.setContinuationsEnabled(engine.isContinuationsEnabled());
                }
                if (engine.getHost() != null && !StringUtils.isEmpty((String)engine.getHost())) {
                    eng.setHost(engine.getHost());
                }
                if (engine.getMaxIdleTime() != null) {
                    eng.setMaxIdleTime(engine.getMaxIdleTime());
                }
                if (engine.getPort() != null) {
                    eng.setPort(engine.getPort());
                }
                if (engine.isReuseAddress() != null) {
                    eng.setReuseAddress(engine.isReuseAddress());
                }
                if (engine.isSessionSupport() != null) {
                    eng.setSessionSupport(engine.isSessionSupport());
                }
                if (engine.getThreadingParameters() != null) {
                    ThreadingParametersType threads = engine.getThreadingParameters();
                    ThreadingParameters rThreads = new ThreadingParameters();
                    rThreads.setMaxThreads(threads.getMaxThreads());
                    rThreads.setMinThreads(threads.getMinThreads());
                    eng.setThreadingParameters(rThreads);
                }
                if (engine.getTlsServerParameters() != null) {
                    TLSServerParametersConfig parameter = null;
                    try {
                        parameter = new TLSServerParametersConfig(engine.getTlsServerParameters());
                        eng.setTlsServerParameters((TLSServerParameters)parameter);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not configure TLS for engine on  " + eng.getHost() + ":" + eng.getPort(), e);
                    }
                }
                eng.finalizeConfig();
                engineList.add(eng);
            }
            this.factory.setEnginesList(engineList);
            this.factory.initComplete();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
    }

    public void destroy() {
        this.factory.postShutdown();
        this.jaxbClasses.clear();
        this.jaxbContext = null;
    }

    public String getParsedElement() {
        return this.parsedElement;
    }

    public void setParsedElement(String parsedElement) {
        this.parsedElement = parsedElement;
    }

    protected Object getJaxbObject(Element parent, Class<?> c) {
        try {
            Unmarshaller umr = this.getContext(c).createUnmarshaller();
            JAXBElement ele = (JAXBElement)umr.unmarshal((Node)parent);
            return ele.getValue();
        }
        catch (JAXBException e) {
            LOG.warning("Unable to parse property due to " + (Object)((Object)e));
            return null;
        }
    }

    protected synchronized JAXBContext getContext(Class<?> cls) {
        if (this.jaxbContext == null || this.jaxbClasses == null || !this.jaxbClasses.contains(cls)) {
            try {
                HashSet tmp = new HashSet();
                if (this.jaxbClasses != null) {
                    tmp.addAll(this.jaxbClasses);
                }
                JAXBContextCache.addPackage(tmp, (String)PackageUtils.getPackageName(cls), (ClassLoader)(cls == null ? this.getClass().getClassLoader() : cls.getClassLoader()));
                if (cls != null) {
                    boolean hasOf = false;
                    for (Class clazz : tmp) {
                        if (clazz.getPackage() != cls.getPackage() || !"ObjectFactory".equals(clazz.getSimpleName())) continue;
                        hasOf = true;
                    }
                    if (!hasOf) {
                        tmp.add(cls);
                    }
                }
                JAXBContextCache.scanPackages(tmp);
                JAXBContextCache.CachedContextAndSchemas ccs = JAXBContextCache.getCachedContextAndSchemas(tmp, null, null, null, (boolean)false);
                this.jaxbClasses = ccs.getClasses();
                this.jaxbContext = ccs.getContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.jaxbContext;
    }
}

