/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.CertificateConstraintsType;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CopyingOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ServerEngine;
import org.apache.cxf.transport.http_jetty.continuations.JettyContinuationProvider;
import org.apache.cxf.transport.https.CertConstraintsJaxBUtils;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.springframework.util.ClassUtils;

public class JettyHTTPDestination
extends AbstractHTTPDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPDestination.class);
    protected JettyHTTPServerEngine engine;
    protected JettyHTTPServerEngineFactory serverEngineFactory;
    protected ServletContext servletContext;
    protected URL nurl;
    protected ClassLoader loader;
    private boolean configFinalized;

    public JettyHTTPDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, JettyHTTPDestination.getAddressValue((EndpointInfo)ei, (boolean)true).getAddress(), true);
        this.serverEngineFactory = serverEngineFactory;
        this.nurl = new URL(this.getAddress(this.endpointInfo));
        this.loader = (ClassLoader)bus.getExtension(ClassLoader.class);
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
    }

    protected void retrieveEngine() throws GeneralSecurityException, IOException {
        CertificateConstraintsType constraints;
        this.engine = this.serverEngineFactory.retrieveJettyHTTPServerEngine(this.nurl.getPort());
        if (this.engine == null) {
            this.engine = this.serverEngineFactory.createJettyHTTPServerEngine(this.nurl.getHost(), this.nurl.getPort(), this.nurl.getProtocol());
        }
        assert (this.engine != null);
        TLSServerParameters serverParameters = this.engine.getTlsServerParameters();
        if (serverParameters != null && serverParameters.getCertConstraints() != null && (constraints = serverParameters.getCertConstraints()) != null) {
            this.certConstraints = CertConstraintsJaxBUtils.createCertConstraints((CertificateConstraintsType)constraints);
        }
        if (!this.nurl.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.nurl + "\"");
        }
    }

    public void finalizeConfig() {
        assert (!this.configFinalized);
        try {
            this.retrieveEngine();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.configFinalized = true;
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        return endpointInfo.getAddress();
    }

    protected void activate() {
        super.activate();
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        URL url = null;
        try {
            url = new URL(this.getAddress(this.endpointInfo));
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        JettyHTTPHandler jhd = this.createJettyHTTPHandler(this, this.contextMatchOnExact());
        this.engine.addServant(url, jhd);
    }

    protected JettyHTTPHandler createJettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        return new JettyHTTPHandler(jhd, cmExact);
    }

    protected void deactivate() {
        super.deactivate();
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeServant(this.nurl);
    }

    protected String getBasePathForFullAddress(String addr) {
        try {
            return new URL(addr).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(this.servletContext, req, resp);
    }

    static AbstractConnection getConnectionForRequest(Request r) {
        try {
            return (AbstractConnection)r.getClass().getMethod("getConnection", new Class[0]).invoke((Object)r, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void setHeadFalse(AbstractConnection con) {
        try {
            Generator gen = (Generator)con.getClass().getMethod("getGenerator", new Class[0]).invoke((Object)con, new Object[0]);
            gen.setHead(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HTTPServerPolicy sp;
        AbstractConnection c;
        Request baseRequest;
        if (context == null) {
            context = this.servletContext;
        }
        Request request = baseRequest = req instanceof Request ? (Request)req : this.getCurrentRequest();
        if (!"HEAD".equals(req.getMethod()) && (c = JettyHTTPDestination.getConnectionForRequest(baseRequest)) != null) {
            this.setHeadFalse(c);
        }
        if ((sp = this.getServer()).isSetRedirectURL()) {
            resp.sendRedirect(sp.getRedirectURL());
            resp.flushBuffer();
            baseRequest.setHandled(true);
            return;
        }
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            this.invoke(null, context, req, resp);
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    protected void invokeComplete(ServletContext context, HttpServletRequest req, HttpServletResponse resp, Message m) throws IOException {
        Request baseRequest;
        resp.flushBuffer();
        Request request = baseRequest = req instanceof Request ? (Request)req : this.getCurrentRequest();
        if (baseRequest != null) {
            baseRequest.setHandled(true);
        }
        super.invokeComplete(context, req, resp, m);
    }

    protected OutputStream flushHeaders(Message outMessage, boolean getStream) throws IOException {
        OutputStream out = super.flushHeaders(outMessage, getStream);
        return this.wrapOutput(out);
    }

    private OutputStream wrapOutput(OutputStream out) {
        try {
            if (out instanceof AbstractHttpConnection.Output) {
                out = new JettyOutputStream((AbstractHttpConnection.Output)out);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return out;
    }

    public ServerEngine getEngine() {
        return this.engine;
    }

    protected Message retrieveFromContinuation(HttpServletRequest req) {
        return (Message)req.getAttribute("cxf.continuation.message");
    }

    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
        if (this.engine.getContinuationsEnabled()) {
            inMessage.put((Object)ContinuationProvider.class.getName(), (Object)new JettyContinuationProvider(req, resp, inMessage));
        }
    }

    private AbstractConnection getCurrentConnection() {
        Class cls = null;
        try {
            cls = ClassUtils.forName((String)"org.eclipse.jetty.server.AbstractHttpConnection", (ClassLoader)AbstractConnection.class.getClassLoader());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cls == null) {
            try {
                cls = ClassUtils.forName((String)"org.eclipse.jetty.server.HttpConnection", (ClassLoader)AbstractConnection.class.getClassLoader());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return (AbstractConnection)((Method)ReflectionUtil.setAccessible((AccessibleObject)cls.getMethod("getCurrentConnection", new Class[0]))).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Request getCurrentRequest() {
        AbstractConnection con = this.getCurrentConnection();
        try {
            return (Request)((Method)ReflectionUtil.setAccessible((AccessibleObject)con.getClass().getMethod("getRequest", new Class[0]))).invoke((Object)con, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class CountingInputStream
    extends FilterInputStream {
        int count;

        public CountingInputStream(InputStream in) {
            super(in);
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int read() throws IOException {
            int i = super.read();
            if (i != -1) {
                ++this.count;
            }
            return i;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int i = super.read(b);
            if (i != -1) {
                this.count += i;
            }
            return i;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i = super.read(b, off, len);
            if (i != -1) {
                this.count += i;
            }
            return i;
        }
    }

    static class JettyOutputStream
    extends FilterOutputStream
    implements CopyingOutputStream {
        final AbstractHttpConnection.Output out;
        boolean written;

        public JettyOutputStream(AbstractHttpConnection.Output o) {
            super((OutputStream)o);
            this.out = o;
        }

        public int copyFrom(InputStream in) throws IOException {
            if (this.written) {
                return IOUtils.copy((InputStream)in, (OutputStream)this.out);
            }
            CountingInputStream c = new CountingInputStream(in);
            this.out.sendContent((Object)c);
            return c.getCount();
        }

        @Override
        public void write(int b) throws IOException {
            this.written = true;
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.written = true;
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

