/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.osgi;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterJaxBUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.CertStoreType;
import org.apache.cxf.configuration.security.CertificateConstraintsType;
import org.apache.cxf.configuration.security.CombinatorType;
import org.apache.cxf.configuration.security.DNConstraintsType;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.configuration.security.KeyManagersType;
import org.apache.cxf.configuration.security.KeyStoreType;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.configuration.security.SecureRandomParameters;
import org.apache.cxf.configuration.security.TrustManagersType;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class HTTPTransportActivator
implements BundleActivator,
ManagedServiceFactory,
HTTPConduitConfigurer {
    public static final String FACTORY_PID = "org.apache.cxf.http.conduits";
    private static final String SECURE_HTTP_PREFIX = "https";
    ServiceTracker configAdminTracker;
    ServiceRegistration reg;
    ServiceRegistration reg2;
    Map<String, PidInfo> props = new ConcurrentHashMap<String, PidInfo>(4, 0.75f, 2);
    CopyOnWriteArrayList<PidInfo> sorted = new CopyOnWriteArrayList();

    public void start(BundleContext context) throws Exception {
        Properties servProps = new Properties();
        servProps.put("service.pid", FACTORY_PID);
        this.reg2 = context.registerService(ManagedServiceFactory.class.getName(), (Object)this, (Dictionary)servProps);
        servProps = new Properties();
        servProps.put("service.pid", "org.apache.cxf.http.conduit-configurer");
        this.reg = context.registerService(HTTPConduitConfigurer.class.getName(), (Object)this, (Dictionary)servProps);
        this.configAdminTracker = new ServiceTracker(context, ConfigurationAdmin.class.getName(), null);
        this.configAdminTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.reg.unregister();
        this.reg2.unregister();
        this.configAdminTracker.close();
    }

    public String getName() {
        return FACTORY_PID;
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (pid == null) {
            return;
        }
        String url = (String)properties.get("url");
        String name = (String)properties.get("name");
        Matcher matcher = url == null ? null : Pattern.compile(url).matcher("");
        String p = (String)properties.get("order");
        int order = 50;
        if (p != null) {
            order = Integer.valueOf(p);
        }
        PidInfo info = new PidInfo(properties, matcher, order);
        this.props.put(pid, info);
        if (url != null) {
            this.props.put(url, info);
        }
        if (name != null) {
            this.props.put(name, info);
        }
        this.addToSortedInfos(info);
    }

    private synchronized void addToSortedInfos(PidInfo pi) {
        int size = this.sorted.size();
        for (int x = 0; x < size; ++x) {
            PidInfo p = this.sorted.get(x);
            if (pi.compareTo(p) >= 0) continue;
            this.sorted.add(x, pi);
            return;
        }
        this.sorted.add(pi);
    }

    private synchronized void removeFromSortedInfos(PidInfo pi) {
        this.sorted.remove(pi);
    }

    public void deleted(String pid) {
        PidInfo info = this.props.remove(pid);
        if (info == null) {
            return;
        }
        this.removeFromSortedInfos(info);
        Dictionary<String, String> d = info.getProps();
        if (d != null) {
            String url = d.get("url");
            String name = d.get("name");
            if (url != null) {
                this.props.remove(url);
            }
            if (name != null) {
                this.props.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(String name, String address, HTTPConduit c) {
        PidInfo byName = null;
        PidInfo byAddress = null;
        if (name != null) {
            byName = this.props.get(name);
        }
        if (address != null && (byAddress = this.props.get(address)) == byName) {
            byAddress = null;
        }
        for (PidInfo info : this.sorted) {
            Matcher m;
            if (info.getMatcher() == null || info == byName || info == byAddress) continue;
            Matcher matcher = m = info.getMatcher();
            synchronized (matcher) {
                m.reset(address);
                if (m.matches()) {
                    this.apply(info.getProps(), c, address);
                }
            }
        }
        if (byAddress != null) {
            this.apply(byAddress.getProps(), c, address);
        }
        if (byName != null) {
            this.apply(byName.getProps(), c, address);
        }
    }

    private void apply(Dictionary<String, String> d, HTTPConduit c, String address) {
        this.applyClientPolicies(d, c);
        this.applyAuthorization(d, c);
        this.applyProxyAuthorization(d, c);
        if (address != null && address.startsWith(SECURE_HTTP_PREFIX)) {
            this.applyTlsClientParameters(d, c);
        }
    }

    private void applyTlsClientParameters(Dictionary<String, String> d, HTTPConduit c) {
        Enumeration<String> keys = d.keys();
        TLSClientParameters p = c.getTlsClientParameters();
        SecureRandomParameters srp = null;
        KeyManagersType kmt = null;
        TrustManagersType tmt = null;
        while (keys.hasMoreElements()) {
            StringTokenizer st;
            String k = keys.nextElement();
            if (!k.startsWith("tlsClientParameters.")) continue;
            if (p == null) {
                p = new TLSClientParameters();
                c.setTlsClientParameters(p);
            }
            String v = d.get(k);
            if ("secureSocketProtocol".equals(k = k.substring("tlsClientParameters.".length()))) {
                p.setSecureSocketProtocol(v);
                continue;
            }
            if ("sslCacheTimeout".equals(k)) {
                p.setSslCacheTimeout(Integer.parseInt(v));
                continue;
            }
            if ("jsseProvider".equals(k)) {
                p.setJsseProvider(v);
                continue;
            }
            if ("disableCNCheck".equals(k)) {
                p.setDisableCNCheck(Boolean.parseBoolean(v));
                continue;
            }
            if ("useHttpsURLConnectionDefaultHostnameVerifier".equals(k)) {
                p.setUseHttpsURLConnectionDefaultHostnameVerifier(Boolean.parseBoolean(v));
                continue;
            }
            if ("useHttpsURLConnectionDefaultSslSocketFactory".equals(k)) {
                p.setUseHttpsURLConnectionDefaultSslSocketFactory(Boolean.parseBoolean(v));
                continue;
            }
            if (k.startsWith("certConstraints.")) {
                k = k.substring("certConstraints.".length());
                CertificateConstraintsType cct = p.getCertConstraints();
                if (cct == null) {
                    cct = new CertificateConstraintsType();
                    p.setCertConstraints(cct);
                }
                DNConstraintsType dnct = null;
                if (k.startsWith("SubjectDNConstraints.")) {
                    dnct = cct.getSubjectDNConstraints();
                    if (dnct == null) {
                        dnct = new DNConstraintsType();
                        cct.setSubjectDNConstraints(dnct);
                    }
                    k = k.substring("SubjectDNConstraints.".length());
                } else if (k.startsWith("IssuerDNConstraints.")) {
                    dnct = cct.getIssuerDNConstraints();
                    if (dnct == null) {
                        dnct = new DNConstraintsType();
                        cct.setIssuerDNConstraints(dnct);
                    }
                    k = k.substring("IssuerDNConstraints.".length());
                }
                if (dnct == null) continue;
                if ("combinator".equals(k)) {
                    dnct.setCombinator(CombinatorType.fromValue((String)v));
                    continue;
                }
                if (!"RegularExpression".equals(k)) continue;
                dnct.getRegularExpression().add(k);
                continue;
            }
            if (k.startsWith("secureRandomParameters.")) {
                k = k.substring("secureRandomParameters.".length());
                if (srp == null) {
                    srp = new SecureRandomParameters();
                }
                if ("algorithm".equals(k)) {
                    srp.setAlgorithm(v);
                    continue;
                }
                if (!"provider".equals(k)) continue;
                srp.setProvider(v);
                continue;
            }
            if (k.startsWith("cipherSuitesFilter.")) {
                List lst;
                k = k.substring("cipherSuitesFilter.".length());
                st = new StringTokenizer(v, ",");
                FiltersType ft = p.getCipherSuitesFilter();
                if (ft == null) {
                    ft = new FiltersType();
                    p.setCipherSuitesFilter(ft);
                }
                List list = lst = "include".equals(k) ? ft.getInclude() : ft.getExclude();
                while (st.hasMoreTokens()) {
                    lst.add(st.nextToken());
                }
                continue;
            }
            if (k.startsWith("cipherSuites")) {
                st = new StringTokenizer(v, ",");
                while (st.hasMoreTokens()) {
                    p.getCipherSuites().add(st.nextToken());
                }
                continue;
            }
            if (k.startsWith("trustManagers.")) {
                tmt = this.getTrustManagers(tmt, k.substring("trustManagers.".length()), v);
                continue;
            }
            if (!k.startsWith("keyManagers.")) continue;
            kmt = this.getKeyManagers(kmt, k.substring("keyManagers.".length()), v);
        }
        try {
            if (srp != null) {
                p.setSecureRandom(TLSParameterJaxBUtils.getSecureRandom(srp));
            }
            if (kmt != null) {
                p.setKeyManagers(TLSParameterJaxBUtils.getKeyManagers(kmt));
            }
            if (tmt != null) {
                p.setTrustManagers(TLSParameterJaxBUtils.getTrustManagers(tmt));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KeyManagersType getKeyManagers(KeyManagersType keyManagers, String k, String v) {
        if (keyManagers == null) {
            keyManagers = new KeyManagersType();
        }
        if ("factoryAlgorithm".equals(k)) {
            keyManagers.setFactoryAlgorithm(v);
        } else if ("provider".equals(k)) {
            keyManagers.setProvider(v);
        } else if ("keyPassword".equals(k)) {
            keyManagers.setKeyPassword(v);
        } else if (k.startsWith("keyStore.")) {
            keyManagers.setKeyStore(this.getKeyStore(keyManagers.getKeyStore(), k.substring("keyStore.".length()), v));
        }
        return keyManagers;
    }

    private KeyStoreType getKeyStore(KeyStoreType ks, String k, String v) {
        if (ks == null) {
            ks = new KeyStoreType();
        }
        if ("type".equals(k)) {
            ks.setType(v);
        } else if ("password".equals(k)) {
            ks.setPassword(v);
        } else if ("provider".equals(k)) {
            ks.setProvider(v);
        } else if ("url".equals(k)) {
            ks.setUrl(v);
        } else if ("file".equals(k)) {
            ks.setFile(v);
        } else if ("resource".equals(k)) {
            ks.setResource(v);
        }
        return ks;
    }

    private TrustManagersType getTrustManagers(TrustManagersType tmt, String k, String v) {
        if (tmt == null) {
            tmt = new TrustManagersType();
        }
        if ("provider".equals(k)) {
            tmt.setProvider(v);
        } else if ("factoryAlgorithm".equals(k)) {
            tmt.setFactoryAlgorithm(v);
        } else if (k.startsWith("keyStore.")) {
            tmt.setKeyStore(this.getKeyStore(tmt.getKeyStore(), k.substring("keyStore.".length()), v));
        } else if (k.startsWith("certStore")) {
            tmt.setCertStore(this.getCertStore(tmt.getCertStore(), k.substring("certStore.".length()), v));
        }
        return tmt;
    }

    private CertStoreType getCertStore(CertStoreType cs, String k, String v) {
        if (cs == null) {
            cs = new CertStoreType();
        }
        if ("file".equals(k)) {
            cs.setFile(v);
        } else if ("url".equals(k)) {
            cs.setUrl(v);
        } else if ("resource".equals(k)) {
            cs.setResource(v);
        }
        return cs;
    }

    private void applyProxyAuthorization(Dictionary<String, String> d, HTTPConduit c) {
        Enumeration<String> keys = d.keys();
        ProxyAuthorizationPolicy p = c.getProxyAuthorization();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            if (!k.startsWith("proxyAuthorization.")) continue;
            if (p == null) {
                p = new ProxyAuthorizationPolicy();
                c.setProxyAuthorization(p);
            }
            String v = d.get(k);
            if ("UserName".equals(k = k.substring("proxyAuthorization.".length()))) {
                p.setUserName(v);
                continue;
            }
            if ("Password".equals(k)) {
                p.setPassword(v);
                continue;
            }
            if ("Authorization".equals(k)) {
                p.setAuthorization(v);
                continue;
            }
            if (!"AuthorizationType".equals(k)) continue;
            p.setAuthorizationType(v);
        }
    }

    private void applyAuthorization(Dictionary<String, String> d, HTTPConduit c) {
        Enumeration<String> keys = d.keys();
        AuthorizationPolicy p = c.getAuthorization();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            if (!k.startsWith("authorization.")) continue;
            if (p == null) {
                p = new AuthorizationPolicy();
                c.setAuthorization(p);
            }
            String v = d.get(k);
            if ("UserName".equals(k = k.substring("authorization.".length()))) {
                p.setUserName(v);
                continue;
            }
            if ("Password".equals(k)) {
                p.setPassword(v);
                continue;
            }
            if ("Authorization".equals(k)) {
                p.setAuthorization(v);
                continue;
            }
            if (!"AuthorizationType".equals(k)) continue;
            p.setAuthorizationType(v);
        }
    }

    private void applyClientPolicies(Dictionary<String, String> d, HTTPConduit c) {
        Enumeration<String> keys = d.keys();
        HTTPClientPolicy p = c.getClient();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            if (!k.startsWith("client.")) continue;
            if (p == null) {
                p = new HTTPClientPolicy();
                c.setClient(p);
            }
            String v = d.get(k);
            if ("ConnectionTimeout".equals(k = k.substring("client.".length()))) {
                p.setConnectionTimeout(Long.parseLong(v.trim()));
                continue;
            }
            if ("ReceiveTimeout".equals(k)) {
                p.setReceiveTimeout(Long.parseLong(v.trim()));
                continue;
            }
            if ("AsyncExecuteTimeout".equals(k)) {
                p.setAsyncExecuteTimeout(Long.parseLong(v.trim()));
                continue;
            }
            if ("AsyncExecuteTimeoutRejection".equals(k)) {
                p.setAsyncExecuteTimeoutRejection(Boolean.parseBoolean(v.trim()));
                continue;
            }
            if ("AutoRedirect".equals(k)) {
                p.setAutoRedirect(Boolean.parseBoolean(v.trim()));
                continue;
            }
            if ("MaxRetransmits".equals(k)) {
                p.setMaxRetransmits(Integer.parseInt(v.trim()));
                continue;
            }
            if ("AllowChunking".equals(k)) {
                p.setAllowChunking(Boolean.parseBoolean(v.trim()));
                continue;
            }
            if ("ChunkingThreshold".equals(k)) {
                p.setChunkingThreshold(Integer.parseInt(v.trim()));
                continue;
            }
            if ("ChunkLength".equals(k)) {
                p.setChunkLength(Integer.parseInt(v.trim()));
                continue;
            }
            if ("Connection".equals(k)) {
                p.setConnection(ConnectionType.valueOf(v));
                continue;
            }
            if ("DecoupledEndpoint".equals(k)) {
                p.setDecoupledEndpoint(v);
                continue;
            }
            if ("ProxyServer".equals(k)) {
                p.setProxyServer(v);
                continue;
            }
            if ("ProxyServerPort".equals(k)) {
                p.setProxyServerPort(Integer.parseInt(v.trim()));
                continue;
            }
            if ("ProxyServerType".equals(k)) {
                p.setProxyServerType(ProxyServerType.fromValue(v));
                continue;
            }
            if (!"NonProxyHosts".equals(k)) continue;
            p.setNonProxyHosts(v);
        }
    }

    private static class PidInfo
    implements Comparable<PidInfo> {
        final Dictionary<String, String> props;
        final Matcher matcher;
        final int order;

        public PidInfo(Dictionary<String, String> p, Matcher m, int o) {
            this.matcher = m;
            this.props = p;
            this.order = o;
        }

        public Dictionary<String, String> getProps() {
            return this.props;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        @Override
        public int compareTo(PidInfo o) {
            if (this.order < o.order) {
                return -1;
            }
            if (this.order > o.order) {
                return 1;
            }
            if (this.matcher != null) {
                if (o.matcher == null) {
                    return -1;
                }
                return this.matcher.pattern().toString().compareTo(o.matcher.pattern().toString());
            }
            return 0;
        }
    }
}

