/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.integration.RegistryProtocol;

public class ServiceInstanceMetadataUtils {
    public static final String METADATA_SERVICE_PREFIX = "dubbo.metadata-service.";
    public static final String ENDPOINTS = "dubbo.endpoints";
    public static String METADATA_SERVICE_URL_PARAMS_PROPERTY_NAME = "dubbo.metadata-service.url-params";
    public static final String METADATA_SERVICE_URLS_PROPERTY_NAME = "dubbo.metadata-service.urls";
    public static String EXPORTED_SERVICES_REVISION_PROPERTY_NAME = "dubbo.exported-services.revision";
    public static String SUBSCRIBER_SERVICES_REVISION_PROPERTY_NAME = "dubbo.subscribed-services.revision";
    public static String METADATA_STORAGE_TYPE_PROPERTY_NAME = "dubbo.metadata.storage-type";

    public static Map<String, Map<String, String>> getMetadataServiceURLsParams(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        String param = metadata.get(METADATA_SERVICE_URL_PARAMS_PROPERTY_NAME);
        return StringUtils.isBlank((CharSequence)param) ? Collections.emptyMap() : (Map)JSON.parse((String)param);
    }

    public static Map<String, String> getMetadataServiceURLParams(ServiceInstance serviceInstance, String protocol) {
        Map<String, Map<String, String>> params = ServiceInstanceMetadataUtils.getMetadataServiceURLsParams(serviceInstance);
        return params.getOrDefault(protocol, Collections.emptyMap());
    }

    public static String getMetadataServiceParameter(List<URL> urls) {
        HashMap params = new HashMap();
        urls.stream().map(url -> url.removeParameter("application")).map(url -> url.removeParameter("group")).map(url -> url.removeParameter("deprecated")).map(url -> url.removeParameter("timestamp")).forEach(url -> {
            String protocol = url.getProtocol();
            params.put(protocol, ServiceInstanceMetadataUtils.getParams(url));
        });
        if (params.isEmpty()) {
            return null;
        }
        return JSON.toJSONString(params);
    }

    private static Map<String, String> getParams(URL providerURL) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        ServiceInstanceMetadataUtils.setDefaultParams(params, providerURL);
        params.put("port", String.valueOf(providerURL.getPort()));
        return params;
    }

    public static String getExportedServicesRevision(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.get(EXPORTED_SERVICES_REVISION_PROPERTY_NAME);
    }

    public static String getSubscribedServicesRevision(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.get(SUBSCRIBER_SERVICES_REVISION_PROPERTY_NAME);
    }

    public static String getMetadataStorageType(URL registryURL) {
        return registryURL.getParameter(METADATA_STORAGE_TYPE_PROPERTY_NAME, "local");
    }

    public static String getMetadataStorageType(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.getOrDefault(METADATA_STORAGE_TYPE_PROPERTY_NAME, "local");
    }

    public static void setMetadataStorageType(ServiceInstance serviceInstance, String metadataType) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        metadata.put(METADATA_STORAGE_TYPE_PROPERTY_NAME, metadataType);
    }

    public static boolean isDubboServiceInstance(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.containsKey(METADATA_SERVICE_URL_PARAMS_PROPERTY_NAME) || metadata.containsKey(METADATA_SERVICE_URLS_PROPERTY_NAME);
    }

    public static void setEndpoints(ServiceInstance serviceInstance, Map<String, Integer> protocolPorts) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        ArrayList endpoints = new ArrayList();
        protocolPorts.forEach((k, v) -> {
            Endpoint endpoint = new Endpoint((Integer)v, (String)k);
            endpoints.add(endpoint);
        });
        metadata.put(ENDPOINTS, JSON.toJSONString(endpoints));
    }

    public static Integer getProtocolPort(ServiceInstance serviceInstance, String protocol) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        String rawEndpoints = metadata.get(ENDPOINTS);
        if (StringUtils.isNotEmpty((String)rawEndpoints)) {
            List endpoints = JSON.parseArray((String)rawEndpoints, Endpoint.class);
            for (Endpoint endpoint : endpoints) {
                if (!endpoint.getProtocol().equals(protocol)) continue;
                return endpoint.getPort();
            }
        }
        return null;
    }

    private static void setDefaultParams(Map<String, String> params, URL providerURL) {
        for (String parameterName : RegistryProtocol.DEFAULT_REGISTER_PROVIDER_KEYS) {
            String parameterValue = providerURL.getParameter(parameterName);
            if (StringUtils.isBlank((CharSequence)parameterValue)) continue;
            params.put(parameterName, parameterValue);
        }
    }

    public static class Endpoint {
        Integer port;
        String protocol;

        public Endpoint(Integer port, String protocol) {
            this.port = port;
            this.protocol = protocol;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }
    }
}

