/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.concurrent.Callable;
import org.apache.dubbo.common.profiler.Profiler;
import org.apache.dubbo.common.profiler.ProfilerEntry;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.rpc.Invocation;

public class InvocationProfilerUtils {
    public static void enterSimpleProfiler(Invocation invocation, Callable<String> messageCallable) {
        if (ProfilerSwitch.isEnableSimpleProfiler()) {
            InvocationProfilerUtils.enterProfiler(invocation, messageCallable);
        }
    }

    public static void releaseSimpleProfiler(Invocation invocation) {
        if (ProfilerSwitch.isEnableSimpleProfiler()) {
            InvocationProfilerUtils.releaseProfiler(invocation);
        }
    }

    public static void enterDetailProfiler(Invocation invocation, Callable<String> messageCallable) {
        if (ProfilerSwitch.isEnableDetailProfiler()) {
            InvocationProfilerUtils.enterProfiler(invocation, messageCallable);
        }
    }

    public static void releaseDetailProfiler(Invocation invocation) {
        if (ProfilerSwitch.isEnableDetailProfiler()) {
            InvocationProfilerUtils.releaseProfiler(invocation);
        }
    }

    public static void enterProfiler(Invocation invocation, String message) {
        Object fromInvocation = invocation.get("DUBBO_INVOKE_PROFILER");
        if (fromInvocation instanceof ProfilerEntry) {
            invocation.put("DUBBO_INVOKE_PROFILER", Profiler.enter((ProfilerEntry)((ProfilerEntry)fromInvocation), (String)message));
        }
    }

    public static void enterProfiler(Invocation invocation, Callable<String> messageCallable) {
        Object fromInvocation = invocation.get("DUBBO_INVOKE_PROFILER");
        if (fromInvocation instanceof ProfilerEntry) {
            String message = "";
            try {
                message = messageCallable.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            invocation.put("DUBBO_INVOKE_PROFILER", Profiler.enter((ProfilerEntry)((ProfilerEntry)fromInvocation), (String)message));
        }
    }

    public static void releaseProfiler(Invocation invocation) {
        Object fromInvocation = invocation.get("DUBBO_INVOKE_PROFILER");
        if (fromInvocation instanceof ProfilerEntry) {
            invocation.put("DUBBO_INVOKE_PROFILER", Profiler.release((ProfilerEntry)((ProfilerEntry)fromInvocation)));
        }
    }
}

