/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.utils.AbstractParameterTool;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MultipleParameterTool
extends AbstractParameterTool {
    private static final long serialVersionUID = 1L;
    protected final Map<String, Collection<String>> data;

    public static MultipleParameterTool fromArgs(String[] args) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>(args.length / 2);
        int i = 0;
        while (i < args.length) {
            String key = Utils.getKeyFromArgs(args, i);
            map.putIfAbsent(key, new ArrayList());
            if (++i >= args.length) {
                ((Collection)map.get(key)).add("__NO_VALUE_KEY");
                continue;
            }
            if (NumberUtils.isNumber((String)args[i])) {
                ((Collection)map.get(key)).add(args[i]);
                ++i;
                continue;
            }
            if (args[i].startsWith("--") || args[i].startsWith("-")) {
                ((Collection)map.get(key)).add("__NO_VALUE_KEY");
                continue;
            }
            ((Collection)map.get(key)).add(args[i]);
            ++i;
        }
        return MultipleParameterTool.fromMultiMap(map);
    }

    public static MultipleParameterTool fromMultiMap(Map<String, Collection<String>> multiMap) {
        Preconditions.checkNotNull(multiMap, (String)"Unable to initialize from empty map");
        return new MultipleParameterTool(multiMap);
    }

    private MultipleParameterTool(Map<String, Collection<String>> data) {
        this.data = Collections.unmodifiableMap(new HashMap<String, Collection<String>>(data));
        this.defaultData = new ConcurrentHashMap(data.size());
        this.unrequestedParameters = Collections.newSetFromMap(new ConcurrentHashMap(data.size()));
        this.unrequestedParameters.addAll(data.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleParameterTool that = (MultipleParameterTool)o;
        return Objects.equals(this.data, that.data) && Objects.equals(this.defaultData, that.defaultData) && Objects.equals(this.unrequestedParameters, that.unrequestedParameters);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.defaultData, this.unrequestedParameters);
    }

    @Override
    public int getNumberOfParameters() {
        return this.data.size();
    }

    @Override
    public String get(String key) {
        this.addToDefaults(key, null);
        this.unrequestedParameters.remove(key);
        if (!this.data.containsKey(key)) {
            return null;
        }
        Preconditions.checkState((this.data.get(key).size() == 1 ? 1 : 0) != 0, (String)"Key %s should has only one value.", (Object[])new Object[]{key});
        return (String)this.data.get(key).toArray()[0];
    }

    @Override
    public boolean has(String value) {
        this.addToDefaults(value, null);
        this.unrequestedParameters.remove(value);
        return this.data.containsKey(value);
    }

    public Collection<String> getMultiParameter(String key) {
        this.addToDefaults(key, null);
        this.unrequestedParameters.remove(key);
        return this.data.getOrDefault(key, null);
    }

    public Collection<String> getMultiParameterRequired(String key) {
        this.addToDefaults(key, null);
        Collection<String> value = this.getMultiParameter(key);
        if (value == null) {
            throw new RuntimeException("No data for required key '" + key + "'");
        }
        return value;
    }

    public Map<String, Collection<String>> toMultiMap() {
        return this.data;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new MultipleParameterTool(this.data);
    }

    public MultipleParameterTool mergeWith(MultipleParameterTool other) {
        HashMap<String, Collection<String>> resultData = new HashMap<String, Collection<String>>(this.data.size() + other.data.size());
        resultData.putAll(this.data);
        other.data.forEach((key, value) -> {
            resultData.putIfAbsent((String)key, new ArrayList());
            ((Collection)resultData.get(key)).addAll(value);
        });
        MultipleParameterTool ret = new MultipleParameterTool(resultData);
        HashSet<String> requestedParametersLeft = new HashSet<String>(this.data.keySet());
        requestedParametersLeft.removeAll(this.unrequestedParameters);
        HashSet<String> requestedParametersRight = new HashSet<String>(other.data.keySet());
        requestedParametersRight.removeAll(other.unrequestedParameters);
        ret.unrequestedParameters.removeAll(requestedParametersLeft);
        ret.unrequestedParameters.removeAll(requestedParametersRight);
        return ret;
    }

    @Override
    public Map<String, String> toMap() {
        return MultipleParameterTool.getFlatMapOfData(this.data);
    }

    private static Map<String, String> getFlatMapOfData(Map<String, Collection<String>> data) {
        return data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (((Collection)e.getValue()).size() > 0) {
                return (String)((Collection)e.getValue()).toArray()[((Collection)e.getValue()).size() - 1];
            }
            return "__NO_VALUE_KEY";
        }));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.defaultData = new ConcurrentHashMap(this.data.size());
        this.unrequestedParameters = Collections.newSetFromMap(new ConcurrentHashMap(this.data.size()));
    }
}

