/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.FlatMapOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;

@Public
public class FlatMapOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, FlatMapOperator<IN, OUT>> {
    protected final FlatMapFunction<IN, OUT> function;
    protected final String defaultName;

    public FlatMapOperator(DataSet<IN> input, TypeInformation<OUT> resultType, FlatMapFunction<IN, OUT> function, String defaultName) {
        super(input, resultType);
        this.function = function;
        this.defaultName = defaultName;
    }

    protected FlatMapFunction<IN, OUT> getFunction() {
        return this.function;
    }

    protected FlatMapOperatorBase<IN, OUT, FlatMapFunction<IN, OUT>> translateToDataFlow(Operator<IN> input) {
        String name = this.getName() != null ? this.getName() : "FlatMap at " + this.defaultName;
        FlatMapOperatorBase po = new FlatMapOperatorBase(this.function, new UnaryOperatorInformation(this.getInputType(), this.getResultType()), name);
        po.setInput(input);
        if (this.getParallelism() > 0) {
            po.setParallelism(this.getParallelism());
        } else {
            po.setParallelism(input.getParallelism());
        }
        return po;
    }
}

