/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.SortPartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.KeyFunctions;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.tuple.Tuple2;

@Public
public class SortPartitionOperator<T>
extends SingleInputOperator<T, T, SortPartitionOperator<T>> {
    private List<Keys<T>> keys = new ArrayList<Keys<T>>();
    private List<Order> orders = new ArrayList<Order>();
    private final String sortLocationName;
    private boolean useKeySelector;

    private SortPartitionOperator(DataSet<T> dataSet, String sortLocationName) {
        super(dataSet, dataSet.getType());
        this.sortLocationName = sortLocationName;
    }

    public SortPartitionOperator(DataSet<T> dataSet, int sortField, Order sortOrder, String sortLocationName) {
        this(dataSet, sortLocationName);
        this.useKeySelector = false;
        super.ensureSortableKey(sortField);
        this.keys.add((Keys<T>)new Keys.ExpressionKeys(sortField, this.getType()));
        this.orders.add(sortOrder);
    }

    public SortPartitionOperator(DataSet<T> dataSet, String sortField, Order sortOrder, String sortLocationName) {
        this(dataSet, sortLocationName);
        this.useKeySelector = false;
        super.ensureSortableKey(sortField);
        this.keys.add((Keys<T>)new Keys.ExpressionKeys(sortField, this.getType()));
        this.orders.add(sortOrder);
    }

    public <K> SortPartitionOperator(DataSet<T> dataSet, Keys.SelectorFunctionKeys<T, K> sortKey, Order sortOrder, String sortLocationName) {
        this(dataSet, sortLocationName);
        this.useKeySelector = true;
        super.ensureSortableKey(sortKey);
        this.keys.add((Keys<T>)sortKey);
        this.orders.add(sortOrder);
    }

    public boolean useKeySelector() {
        return this.useKeySelector;
    }

    @Override
    public SortPartitionOperator<T> sortPartition(int field, Order order) {
        if (this.useKeySelector) {
            throw new InvalidProgramException("Expression keys cannot be appended after a KeySelector");
        }
        this.ensureSortableKey(field);
        this.keys.add((Keys<T>)new Keys.ExpressionKeys(field, this.getType()));
        this.orders.add(order);
        return this;
    }

    @Override
    public SortPartitionOperator<T> sortPartition(String field, Order order) {
        if (this.useKeySelector) {
            throw new InvalidProgramException("Expression keys cannot be appended after a KeySelector");
        }
        this.ensureSortableKey(field);
        this.keys.add((Keys<T>)new Keys.ExpressionKeys(field, this.getType()));
        this.orders.add(order);
        return this;
    }

    @Override
    public <K> SortPartitionOperator<T> sortPartition(KeySelector<T, K> keyExtractor, Order order) {
        throw new InvalidProgramException("KeySelector cannot be chained.");
    }

    private void ensureSortableKey(int field) throws InvalidProgramException {
        if (!Keys.ExpressionKeys.isSortKey((int)field, this.getType())) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
    }

    private void ensureSortableKey(String field) throws InvalidProgramException {
        if (!Keys.ExpressionKeys.isSortKey((String)field, this.getType())) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
    }

    private <K> void ensureSortableKey(Keys.SelectorFunctionKeys<T, K> sortKey) {
        if (!sortKey.getKeyType().isSortKeyType()) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
    }

    protected org.apache.flink.api.common.operators.SingleInputOperator<?, T, ?> translateToDataFlow(Operator<T> input) {
        String name = "Sort at " + this.sortLocationName;
        if (this.useKeySelector) {
            return this.translateToDataFlowWithKeyExtractor(input, (Keys.SelectorFunctionKeys)this.keys.get(0), this.orders.get(0), name);
        }
        ArrayList<Integer> allKeyPositions = new ArrayList<Integer>();
        ArrayList<Order> allOrders = new ArrayList<Order>();
        int length = this.keys.size();
        for (int i = 0; i < length; ++i) {
            int[] sortKeyPositions = this.keys.get(i).computeLogicalKeyPositions();
            Order order = this.orders.get(i);
            for (int sortKeyPosition : sortKeyPositions) {
                allKeyPositions.add(sortKeyPosition);
                allOrders.add(order);
            }
        }
        Ordering partitionOrdering = new Ordering();
        int length2 = allKeyPositions.size();
        for (int i = 0; i < length2; ++i) {
            partitionOrdering.appendOrdering((Integer)allKeyPositions.get(i), null, (Order)allOrders.get(i));
        }
        UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getType(), this.getType());
        SortPartitionOperatorBase noop = new SortPartitionOperatorBase(operatorInfo, partitionOrdering, name);
        noop.setInput(input);
        if (this.getParallelism() < 0) {
            noop.setParallelism(input.getParallelism());
        } else {
            noop.setParallelism(this.getParallelism());
        }
        return noop;
    }

    private <K> org.apache.flink.api.common.operators.SingleInputOperator<?, T, ?> translateToDataFlowWithKeyExtractor(Operator<T> input, Keys.SelectorFunctionKeys<T, K> keys, Order order, String name) {
        TypeInformation<Tuple2<K, T>> typeInfoWithKey = KeyFunctions.createTypeWithKey(keys);
        Keys.ExpressionKeys newKey = new Keys.ExpressionKeys(0, typeInfoWithKey);
        Operator<Tuple2<K, T>> keyedInput = KeyFunctions.appendKeyExtractor(input, keys);
        int[] sortKeyPositions = newKey.computeLogicalKeyPositions();
        Ordering partitionOrdering = new Ordering();
        for (int keyPosition : sortKeyPositions) {
            partitionOrdering.appendOrdering(Integer.valueOf(keyPosition), null, order);
        }
        UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(typeInfoWithKey, typeInfoWithKey);
        SortPartitionOperatorBase noop = new SortPartitionOperatorBase(operatorInfo, partitionOrdering, name);
        noop.setInput(keyedInput);
        if (this.getParallelism() < 0) {
            noop.setParallelism(input.getParallelism());
        } else {
            noop.setParallelism(this.getParallelism());
        }
        return KeyFunctions.appendKeyRemover(noop, keys);
    }
}

