/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.traversals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.plan.BinaryUnionPlanNode;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.IterationPlanNode;
import org.apache.flink.optimizer.plan.NAryUnionPlanNode;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.util.Visitor;

public class BinaryUnionReplacer
implements Visitor<PlanNode> {
    private final Set<PlanNode> seenBefore = new HashSet<PlanNode>();

    public boolean preVisit(PlanNode visitable) {
        if (this.seenBefore.add(visitable)) {
            if (visitable instanceof IterationPlanNode) {
                ((IterationPlanNode)((Object)visitable)).acceptForStepFunction(this);
            }
            return true;
        }
        return false;
    }

    public void postVisit(PlanNode visitable) {
        block3: {
            Channel in2;
            Channel in1;
            BinaryUnionPlanNode unionNode;
            block4: {
                if (!(visitable instanceof BinaryUnionPlanNode)) break block3;
                unionNode = (BinaryUnionPlanNode)visitable;
                in1 = unionNode.getInput1();
                in2 = unionNode.getInput2();
                if (unionNode.unionsStaticAndDynamicPath()) break block4;
                ArrayList<Channel> inputs = new ArrayList<Channel>();
                this.collect(in1, inputs);
                this.collect(in2, inputs);
                NAryUnionPlanNode newUnionNode = new NAryUnionPlanNode(unionNode.getOptimizerNode(), inputs, unionNode.getGlobalProperties(), unionNode.getCumulativeCosts());
                newUnionNode.setParallelism(unionNode.getParallelism());
                for (Channel c : inputs) {
                    c.setTarget(newUnionNode);
                }
                for (Channel channel : unionNode.getOutgoingChannels()) {
                    channel.swapUnionNodes(newUnionNode);
                    newUnionNode.addOutgoingChannel(channel);
                }
                break block3;
            }
            if (!in1.isOnDynamicPath()) break block3;
            BinaryUnionPlanNode newUnionNode = new BinaryUnionPlanNode(unionNode);
            in1.setTarget(newUnionNode);
            in2.setTarget(newUnionNode);
            for (Channel channel : unionNode.getOutgoingChannels()) {
                channel.swapUnionNodes(newUnionNode);
                newUnionNode.addOutgoingChannel(channel);
            }
        }
    }

    public void collect(Channel in, List<Channel> inputs) {
        if (in.getSource() instanceof NAryUnionPlanNode) {
            if (in.getShipStrategy() != ShipStrategyType.FORWARD) {
                throw new CompilerException("Bug: Plan generation for Unions picked a ship strategy between binary plan operators.");
            }
            if (in.getLocalStrategy() != null && in.getLocalStrategy() != LocalStrategy.NONE) {
                throw new CompilerException("Bug: Plan generation for Unions picked a local strategy between binary plan operators.");
            }
            inputs.addAll(((NAryUnionPlanNode)in.getSource()).getListOfInputs());
        } else {
            inputs.add(in);
        }
    }
}

