/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpecFactory;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

public class ResourceManagerRuntimeServicesConfiguration {
    private final Time jobTimeout;
    private final SlotManagerConfiguration slotManagerConfiguration;
    private final boolean enableFineGrainedResourceManagement;

    public ResourceManagerRuntimeServicesConfiguration(Time jobTimeout, SlotManagerConfiguration slotManagerConfiguration, boolean enableFineGrainedResourceManagement) {
        this.jobTimeout = (Time)Preconditions.checkNotNull((Object)jobTimeout);
        this.slotManagerConfiguration = (SlotManagerConfiguration)Preconditions.checkNotNull((Object)slotManagerConfiguration);
        this.enableFineGrainedResourceManagement = enableFineGrainedResourceManagement;
    }

    public Time getJobTimeout() {
        return this.jobTimeout;
    }

    public SlotManagerConfiguration getSlotManagerConfiguration() {
        return this.slotManagerConfiguration;
    }

    public boolean isEnableFineGrainedResourceManagement() {
        return this.enableFineGrainedResourceManagement;
    }

    public static ResourceManagerRuntimeServicesConfiguration fromConfiguration(Configuration configuration, WorkerResourceSpecFactory defaultWorkerResourceSpecFactory) throws ConfigurationException {
        Time jobTimeout;
        String strJobTimeout = configuration.getString(ResourceManagerOptions.JOB_TIMEOUT);
        try {
            jobTimeout = Time.milliseconds((long)TimeUtils.parseDuration((String)strJobTimeout).toMillis());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Could not parse the resource manager's job timeout value " + ResourceManagerOptions.JOB_TIMEOUT + '.', (Throwable)e);
        }
        WorkerResourceSpec defaultWorkerResourceSpec = defaultWorkerResourceSpecFactory.createDefaultWorkerResourceSpec(configuration);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration(configuration, defaultWorkerResourceSpec);
        boolean enableFineGrainedResourceManagement = ClusterOptions.isFineGrainedResourceManagementEnabled((Configuration)configuration);
        return new ResourceManagerRuntimeServicesConfiguration(jobTimeout, slotManagerConfiguration, enableFineGrainedResourceManagement);
    }
}

