/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.stopwithsavepoint;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.scheduler.stopwithsavepoint.StopWithSavepointTerminationHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;

public class StopWithSavepointTerminationManager {
    private final StopWithSavepointTerminationHandler stopWithSavepointTerminationHandler;

    public StopWithSavepointTerminationManager(StopWithSavepointTerminationHandler stopWithSavepointTerminationHandler) {
        this.stopWithSavepointTerminationHandler = (StopWithSavepointTerminationHandler)Preconditions.checkNotNull((Object)stopWithSavepointTerminationHandler);
    }

    public CompletableFuture<String> stopWithSavepoint(CompletableFuture<CompletedCheckpoint> completedSavepointFuture, CompletableFuture<Collection<ExecutionState>> terminatedExecutionStatesFuture, ComponentMainThreadExecutor mainThreadExecutor) {
        FutureUtils.assertNoException((CompletableFuture)((CompletableFuture)completedSavepointFuture.handleAsync((completedSavepoint, throwable) -> {
            this.stopWithSavepointTerminationHandler.handleSavepointCreation((CompletedCheckpoint)completedSavepoint, (Throwable)throwable);
            return null;
        }, (Executor)mainThreadExecutor)).thenRun(() -> FutureUtils.assertNoException((CompletableFuture)terminatedExecutionStatesFuture.thenAcceptAsync(this.stopWithSavepointTerminationHandler::handleExecutionsTermination, (Executor)mainThreadExecutor))));
        return this.stopWithSavepointTerminationHandler.getSavepointPath();
    }

    public static void checkStopWithSavepointPreconditions(CheckpointCoordinator checkpointCoordinator, @Nullable String targetDirectory, JobID jobId, Logger logger) {
        if (checkpointCoordinator == null) {
            throw new IllegalStateException(String.format("Job %s is not a streaming job.", jobId));
        }
        if (targetDirectory == null && !checkpointCoordinator.getCheckpointStorage().hasDefaultSavepointLocation()) {
            logger.info("Trying to cancel job {} with savepoint, but no savepoint directory configured.", (Object)jobId);
            throw new IllegalStateException("No savepoint directory configured. You can either specify a directory while cancelling via -s :targetDirectory or configure a cluster-wide default via key '" + CheckpointingOptions.SAVEPOINT_DIRECTORY.key() + "'.");
        }
    }
}

