/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoReader;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshotReadersWriters;
import org.apache.flink.util.Preconditions;

public class OperatorBackendSerializationProxy
extends VersionedIOReadableWritable {
    public static final int VERSION = 5;
    private static final Map<Integer, Integer> META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER = new HashMap<Integer, Integer>();
    private List<StateMetaInfoSnapshot> operatorStateMetaInfoSnapshots;
    private List<StateMetaInfoSnapshot> broadcastStateMetaInfoSnapshots;
    private ClassLoader userCodeClassLoader;

    public OperatorBackendSerializationProxy(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
    }

    public OperatorBackendSerializationProxy(List<StateMetaInfoSnapshot> operatorStateMetaInfoSnapshots, List<StateMetaInfoSnapshot> broadcastStateMetaInfoSnapshots) {
        this.operatorStateMetaInfoSnapshots = (List)Preconditions.checkNotNull(operatorStateMetaInfoSnapshots);
        this.broadcastStateMetaInfoSnapshots = (List)Preconditions.checkNotNull(broadcastStateMetaInfoSnapshots);
        Preconditions.checkArgument((operatorStateMetaInfoSnapshots.size() <= Short.MAX_VALUE && broadcastStateMetaInfoSnapshots.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
    }

    public int getVersion() {
        return 5;
    }

    public int[] getCompatibleVersions() {
        return new int[]{5, 4, 3, 2, 1};
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.writeStateMetaInfoSnapshots(this.operatorStateMetaInfoSnapshots, out);
        this.writeStateMetaInfoSnapshots(this.broadcastStateMetaInfoSnapshots, out);
    }

    private void writeStateMetaInfoSnapshots(List<StateMetaInfoSnapshot> snapshots, DataOutputView out) throws IOException {
        out.writeShort(snapshots.size());
        for (StateMetaInfoSnapshot state : snapshots) {
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(state, out);
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        int proxyReadVersion = this.getReadVersion();
        Integer metaInfoSnapshotVersion = META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.get(proxyReadVersion);
        if (metaInfoSnapshotVersion == null) {
            throw new IOException("Cannot determine corresponding meta info snapshot version for operator backend serialization readVersion=" + proxyReadVersion);
        }
        StateMetaInfoReader stateMetaInfoReader = StateMetaInfoSnapshotReadersWriters.getReader(metaInfoSnapshotVersion, StateMetaInfoSnapshotReadersWriters.StateTypeHint.OPERATOR_STATE);
        int numOperatorStates = in.readShort();
        this.operatorStateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(numOperatorStates);
        for (int i = 0; i < numOperatorStates; ++i) {
            this.operatorStateMetaInfoSnapshots.add(stateMetaInfoReader.readStateMetaInfoSnapshot(in, this.userCodeClassLoader));
        }
        if (proxyReadVersion >= 3) {
            int numBroadcastStates = in.readShort();
            this.broadcastStateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(numBroadcastStates);
            for (int i = 0; i < numBroadcastStates; ++i) {
                this.broadcastStateMetaInfoSnapshots.add(stateMetaInfoReader.readStateMetaInfoSnapshot(in, this.userCodeClassLoader));
            }
        } else {
            this.broadcastStateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>();
        }
    }

    public List<StateMetaInfoSnapshot> getOperatorStateMetaInfoSnapshots() {
        return this.operatorStateMetaInfoSnapshots;
    }

    public List<StateMetaInfoSnapshot> getBroadcastStateMetaInfoSnapshots() {
        return this.broadcastStateMetaInfoSnapshots;
    }

    static {
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(1, 1);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(2, 2);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(3, 3);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(4, 5);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(5, 6);
    }
}

