/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentState;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;

public class DefaultExecutionDeploymentTracker
implements ExecutionDeploymentTracker {
    private final Set<ExecutionAttemptID> pendingDeployments = new HashSet<ExecutionAttemptID>();
    private final Map<ResourceID, Set<ExecutionAttemptID>> executionsByHost = new HashMap<ResourceID, Set<ExecutionAttemptID>>();
    private final Map<ExecutionAttemptID, ResourceID> hostByExecution = new HashMap<ExecutionAttemptID, ResourceID>();

    @Override
    public void startTrackingPendingDeploymentOf(ExecutionAttemptID executionAttemptId, ResourceID host) {
        this.pendingDeployments.add(executionAttemptId);
        this.hostByExecution.put(executionAttemptId, host);
        this.executionsByHost.computeIfAbsent(host, ignored -> new HashSet()).add(executionAttemptId);
    }

    @Override
    public void completeDeploymentOf(ExecutionAttemptID executionAttemptId) {
        this.pendingDeployments.remove(executionAttemptId);
    }

    @Override
    public void stopTrackingDeploymentOf(ExecutionAttemptID executionAttemptId) {
        this.pendingDeployments.remove(executionAttemptId);
        ResourceID host = this.hostByExecution.remove(executionAttemptId);
        if (host != null) {
            this.executionsByHost.computeIfPresent(host, (resourceID, executionAttemptIds) -> {
                executionAttemptIds.remove(executionAttemptId);
                return executionAttemptIds.isEmpty() ? null : executionAttemptIds;
            });
        }
    }

    @Override
    public Map<ExecutionAttemptID, ExecutionDeploymentState> getExecutionsOn(ResourceID host) {
        return this.executionsByHost.getOrDefault(host, Collections.emptySet()).stream().collect(Collectors.toMap(x -> x, x -> this.pendingDeployments.contains(x) ? ExecutionDeploymentState.PENDING : ExecutionDeploymentState.DEPLOYED));
    }
}

