/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.InternalExecutionGraphAccessor;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ExecutionGraphToInputsLocationsRetrieverAdapter
implements InputsLocationsRetriever {
    private final ExecutionGraph executionGraph;

    public ExecutionGraphToInputsLocationsRetrieverAdapter(ExecutionGraph executionGraph) {
        this.executionGraph = (ExecutionGraph)Preconditions.checkNotNull((Object)executionGraph);
    }

    @Override
    public Collection<Collection<ExecutionVertexID>> getConsumedResultPartitionsProducers(ExecutionVertexID executionVertexId) {
        ExecutionVertex ev = this.getExecutionVertex(executionVertexId);
        InternalExecutionGraphAccessor executionGraphAccessor = ev.getExecutionGraphAccessor();
        ArrayList<Collection<ExecutionVertexID>> resultPartitionProducers = new ArrayList<Collection<ExecutionVertexID>>(ev.getNumberOfInputs());
        for (ConsumedPartitionGroup consumedPartitions : ev.getAllConsumedPartitionGroups()) {
            ArrayList<ExecutionVertexID> producers = new ArrayList<ExecutionVertexID>(consumedPartitions.size());
            for (IntermediateResultPartitionID consumedPartitionId : consumedPartitions) {
                ExecutionVertex producer = executionGraphAccessor.getResultPartitionOrThrow(consumedPartitionId).getProducer();
                producers.add(producer.getID());
            }
            resultPartitionProducers.add(producers);
        }
        return resultPartitionProducers;
    }

    @Override
    public Optional<CompletableFuture<TaskManagerLocation>> getTaskManagerLocation(ExecutionVertexID executionVertexId) {
        ExecutionVertex ev = this.getExecutionVertex(executionVertexId);
        if (ev.getExecutionState() != ExecutionState.CREATED) {
            return Optional.of(ev.getCurrentTaskManagerLocationFuture());
        }
        return Optional.empty();
    }

    private ExecutionVertex getExecutionVertex(ExecutionVertexID executionVertexId) {
        ExecutionJobVertex ejv = this.executionGraph.getJobVertex(executionVertexId.getJobVertexId());
        Preconditions.checkState((ejv != null && ejv.getParallelism() > executionVertexId.getSubtaskIndex() ? 1 : 0) != 0, (String)"Failed to find execution %s in execution graph.", (Object[])new Object[]{executionVertexId});
        return ejv.getTaskVertices()[executionVertexId.getSubtaskIndex()];
    }
}

