/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public final class VertexGroupComputeUtil {
    public static <V> Set<V> mergeVertexGroups(Set<V> group1, Set<V> group2, Map<V, Set<V>> vertexToGroup) {
        Set<V> largerSet;
        Set<V> smallerSet;
        if (group1.size() < group2.size()) {
            smallerSet = group1;
            largerSet = group2;
        } else {
            smallerSet = group2;
            largerSet = group1;
        }
        for (V v : smallerSet) {
            vertexToGroup.put((Set<V>)v, (Set<Set<V>>)largerSet);
        }
        largerSet.addAll(smallerSet);
        return largerSet;
    }

    public static <V> Set<Set<V>> uniqueVertexGroups(Map<V, Set<V>> vertexToGroup) {
        Set<Set<V>> distinctGroups = Collections.newSetFromMap(new IdentityHashMap());
        distinctGroups.addAll(vertexToGroup.values());
        return distinctGroups;
    }

    private VertexGroupComputeUtil() {
    }
}

