/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import java.util.Collection;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlCreateDatabase;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.impl.ParseException;

public class SqlCreateHiveDatabase
extends SqlCreateDatabase {
    public static final String DATABASE_LOCATION_URI = "hive.database.location-uri";
    private SqlNodeList originPropList;
    private final SqlCharStringLiteral location;

    public SqlCreateHiveDatabase(SqlParserPos pos, SqlIdentifier databaseName, SqlNodeList propertyList, SqlCharStringLiteral comment, SqlCharStringLiteral location, boolean ifNotExists) throws ParseException {
        super(pos, databaseName, HiveDDLUtils.checkReservedDBProperties(propertyList), HiveDDLUtils.unescapeStringLiteral(comment), ifNotExists);
        HiveDDLUtils.ensureNonGeneric(propertyList);
        this.originPropList = new SqlNodeList((Collection)propertyList.getList(), propertyList.getParserPosition());
        propertyList.add((SqlNode)HiveDDLUtils.toTableOption("is_generic", "false", pos));
        if (location != null) {
            propertyList.add((SqlNode)new SqlTableOption((SqlNode)SqlLiteral.createCharString((String)DATABASE_LOCATION_URI, (SqlParserPos)location.getParserPosition()), (SqlNode)location, location.getParserPosition()));
        }
        this.location = location;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE DATABASE");
        if (this.isIfNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.getDatabaseName().unparse(writer, leftPrec, rightPrec);
        if (this.getComment().isPresent()) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            ((SqlCharStringLiteral)this.getComment().get()).unparse(writer, leftPrec, rightPrec);
        }
        if (this.location != null) {
            writer.newlineAndIndent();
            writer.keyword("LOCATION");
            this.location.unparse(writer, leftPrec, rightPrec);
        }
        if (this.originPropList.size() > 0) {
            writer.keyword("WITH DBPROPERTIES");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.originPropList) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }
}

