/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.dml;

import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.SqlProperty;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;

public class RichSqlHiveInsert
extends RichSqlInsert {
    private final SqlNodeList allPartKeys;
    private final Map<SqlIdentifier, SqlProperty> partKeyToSpec;

    public RichSqlHiveInsert(SqlParserPos pos, SqlNodeList keywords, SqlNodeList extendedKeywords, SqlNode targetTable, SqlNode source, SqlNodeList columnList, SqlNodeList staticPartitions, SqlNodeList allPartKeys) {
        super(pos, keywords, extendedKeywords, targetTable, source, columnList, staticPartitions);
        HiveDDLUtils.unescapePartitionSpec(staticPartitions);
        this.allPartKeys = allPartKeys;
        this.partKeyToSpec = RichSqlHiveInsert.getPartKeyToSpec(staticPartitions);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        String insertKeyword = "INSERT INTO";
        if (this.isUpsert()) {
            insertKeyword = "UPSERT INTO";
        } else if (this.isOverwrite()) {
            insertKeyword = "INSERT OVERWRITE";
        }
        writer.sep(insertKeyword);
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.getTargetTable().unparse(writer, opLeft, opRight);
        if (this.getTargetColumnList() != null) {
            this.getTargetColumnList().unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        if (this.allPartKeys != null && this.allPartKeys.size() > 0) {
            writer.keyword("PARTITION");
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode node : this.allPartKeys) {
                writer.sep(",", false);
                SqlIdentifier partKey = (SqlIdentifier)node;
                SqlProperty spec = this.partKeyToSpec.get(partKey);
                if (spec != null) {
                    spec.unparse(writer, leftPrec, rightPrec);
                    continue;
                }
                partKey.unparse(writer, leftPrec, rightPrec);
            }
            writer.endList(frame);
            writer.newlineAndIndent();
        }
        this.getSource().unparse(writer, 0, 0);
    }

    private static Map<SqlIdentifier, SqlProperty> getPartKeyToSpec(SqlNodeList staticSpec) {
        HashMap<SqlIdentifier, SqlProperty> res = new HashMap<SqlIdentifier, SqlProperty>();
        if (staticSpec != null) {
            for (SqlNode node : staticSpec) {
                SqlProperty spec = (SqlProperty)node;
                res.put(spec.getKey(), spec);
            }
        }
        return res;
    }
}

