/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.watermarkstatus;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.watermarkstatus.HeapPriorityQueue;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;

@Internal
public class StatusWatermarkValve {
    private final InputChannelStatus[] channelStatuses;
    private long lastOutputWatermark;
    private WatermarkStatus lastOutputWatermarkStatus;
    private final HeapPriorityQueue<InputChannelStatus> alignedChannelStatuses;

    public StatusWatermarkValve(int numInputChannels) {
        Preconditions.checkArgument((numInputChannels > 0 ? 1 : 0) != 0);
        this.channelStatuses = new InputChannelStatus[numInputChannels];
        this.alignedChannelStatuses = new HeapPriorityQueue<InputChannelStatus>((left, right) -> Long.compare(left.watermark, right.watermark), numInputChannels);
        for (int i = 0; i < numInputChannels; ++i) {
            this.channelStatuses[i] = new InputChannelStatus();
            this.channelStatuses[i].watermark = Long.MIN_VALUE;
            this.channelStatuses[i].watermarkStatus = WatermarkStatus.ACTIVE;
            this.markWatermarkAligned(this.channelStatuses[i]);
        }
        this.lastOutputWatermark = Long.MIN_VALUE;
        this.lastOutputWatermarkStatus = WatermarkStatus.ACTIVE;
    }

    public void inputWatermark(Watermark watermark, int channelIndex, PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        long watermarkMillis;
        if (this.lastOutputWatermarkStatus.isActive() && this.channelStatuses[channelIndex].watermarkStatus.isActive() && (watermarkMillis = watermark.getTimestamp()) > this.channelStatuses[channelIndex].watermark) {
            this.channelStatuses[channelIndex].watermark = watermarkMillis;
            if (this.channelStatuses[channelIndex].isWatermarkAligned) {
                this.adjustAlignedChannelStatuses(this.channelStatuses[channelIndex]);
            } else if (watermarkMillis >= this.lastOutputWatermark) {
                this.markWatermarkAligned(this.channelStatuses[channelIndex]);
            }
            this.findAndOutputNewMinWatermarkAcrossAlignedChannels(output);
        }
    }

    public void inputWatermarkStatus(WatermarkStatus watermarkStatus, int channelIndex, PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        if (watermarkStatus.isIdle() && this.channelStatuses[channelIndex].watermarkStatus.isActive()) {
            this.channelStatuses[channelIndex].watermarkStatus = WatermarkStatus.IDLE;
            this.markWatermarkUnaligned(this.channelStatuses[channelIndex]);
            if (!InputChannelStatus.hasActiveChannels(this.channelStatuses)) {
                if (this.channelStatuses[channelIndex].watermark == this.lastOutputWatermark) {
                    this.findAndOutputMaxWatermarkAcrossAllChannels(output);
                }
                this.lastOutputWatermarkStatus = WatermarkStatus.IDLE;
                output.emitWatermarkStatus(this.lastOutputWatermarkStatus);
            } else if (this.channelStatuses[channelIndex].watermark == this.lastOutputWatermark) {
                this.findAndOutputNewMinWatermarkAcrossAlignedChannels(output);
            }
        } else if (watermarkStatus.isActive() && this.channelStatuses[channelIndex].watermarkStatus.isIdle()) {
            this.channelStatuses[channelIndex].watermarkStatus = WatermarkStatus.ACTIVE;
            if (this.channelStatuses[channelIndex].watermark >= this.lastOutputWatermark) {
                this.markWatermarkAligned(this.channelStatuses[channelIndex]);
            }
            if (this.lastOutputWatermarkStatus.isIdle()) {
                this.lastOutputWatermarkStatus = WatermarkStatus.ACTIVE;
                output.emitWatermarkStatus(this.lastOutputWatermarkStatus);
            }
        }
    }

    private void findAndOutputNewMinWatermarkAcrossAlignedChannels(PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        boolean hasAlignedChannels;
        boolean bl = hasAlignedChannels = !this.alignedChannelStatuses.isEmpty();
        if (hasAlignedChannels && this.alignedChannelStatuses.peek().watermark > this.lastOutputWatermark) {
            this.lastOutputWatermark = this.alignedChannelStatuses.peek().watermark;
            output.emitWatermark(new Watermark(this.lastOutputWatermark));
        }
    }

    private void markWatermarkAligned(InputChannelStatus inputChannelStatus) {
        inputChannelStatus.isWatermarkAligned = true;
        inputChannelStatus.addTo(this.alignedChannelStatuses);
    }

    private void markWatermarkUnaligned(InputChannelStatus inputChannelStatus) {
        inputChannelStatus.isWatermarkAligned = false;
        inputChannelStatus.removeFrom(this.alignedChannelStatuses);
    }

    private void adjustAlignedChannelStatuses(InputChannelStatus inputChannelStatus) {
        this.alignedChannelStatuses.adjustModifiedElement(inputChannelStatus);
    }

    private void findAndOutputMaxWatermarkAcrossAllChannels(PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        long maxWatermark = Long.MIN_VALUE;
        for (InputChannelStatus channelStatus : this.channelStatuses) {
            maxWatermark = Math.max(channelStatus.watermark, maxWatermark);
        }
        if (maxWatermark > this.lastOutputWatermark) {
            this.lastOutputWatermark = maxWatermark;
            output.emitWatermark(new Watermark(this.lastOutputWatermark));
        }
    }

    @VisibleForTesting
    protected InputChannelStatus getInputChannelStatus(int channelIndex) {
        Preconditions.checkArgument((channelIndex >= 0 && channelIndex < this.channelStatuses.length ? 1 : 0) != 0, (Object)("Invalid channel index. Number of input channels: " + this.channelStatuses.length));
        return this.channelStatuses[channelIndex];
    }

    @VisibleForTesting
    protected static class InputChannelStatus
    implements HeapPriorityQueue.HeapPriorityQueueElement {
        protected long watermark;
        protected WatermarkStatus watermarkStatus;
        protected boolean isWatermarkAligned;
        private int heapIndex = Integer.MIN_VALUE;

        protected InputChannelStatus() {
        }

        private static boolean hasActiveChannels(InputChannelStatus[] channelStatuses) {
            for (InputChannelStatus status : channelStatuses) {
                if (!status.watermarkStatus.isActive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getInternalIndex() {
            return this.heapIndex;
        }

        @Override
        public void setInternalIndex(int newIndex) {
            this.heapIndex = newIndex;
        }

        private void removeFrom(HeapPriorityQueue<InputChannelStatus> queue) {
            queue.remove(this);
            this.setInternalIndex(Integer.MIN_VALUE);
        }

        private void addTo(HeapPriorityQueue<InputChannelStatus> queue) {
            if (this.heapIndex == Integer.MIN_VALUE) {
                queue.add(this);
            }
        }
    }
}

