/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.core.execution.JobStatusHook;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.graph.GlobalStreamExchangeMode;
import org.apache.flink.streaming.api.graph.JSONGenerator;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.StreamingJobGraphGenerator;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.OutputFormatOperatorFactory;
import org.apache.flink.streaming.api.operators.SourceOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.streaming.runtime.partitioner.ForwardForConsecutiveHashPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ForwardForUnspecifiedPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.MultipleInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.SourceOperatorStreamTask;
import org.apache.flink.streaming.runtime.tasks.SourceStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamIterationHead;
import org.apache.flink.streaming.runtime.tasks.StreamIterationTail;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTask;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StreamGraph
implements Pipeline {
    private static final Logger LOG = LoggerFactory.getLogger(StreamGraph.class);
    public static final String ITERATION_SOURCE_NAME_PREFIX = "IterationSource";
    public static final String ITERATION_SINK_NAME_PREFIX = "IterationSink";
    private String jobName;
    private final ExecutionConfig executionConfig;
    private final CheckpointConfig checkpointConfig;
    private SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
    private boolean chaining;
    private boolean chainingOfOperatorsWithDifferentMaxParallelism;
    private Collection<Tuple2<String, DistributedCache.DistributedCacheEntry>> userArtifacts = Collections.emptyList();
    private TimeCharacteristic timeCharacteristic;
    private GlobalStreamExchangeMode globalExchangeMode;
    private boolean enableCheckpointsAfterTasksFinish;
    private boolean allVerticesInSameSlotSharingGroupByDefault = true;
    private Map<Integer, StreamNode> streamNodes;
    private Set<Integer> sources;
    private Set<Integer> sinks;
    private Map<Integer, Tuple2<Integer, OutputTag>> virtualSideOutputNodes;
    private Map<Integer, Tuple3<Integer, StreamPartitioner<?>, StreamExchangeMode>> virtualPartitionNodes;
    protected Map<Integer, String> vertexIDtoBrokerID;
    protected Map<Integer, Long> vertexIDtoLoopTimeout;
    private StateBackend stateBackend;
    private TernaryBoolean changelogStateBackendEnabled;
    private CheckpointStorage checkpointStorage;
    private Path savepointDir;
    private Set<Tuple2<StreamNode, StreamNode>> iterationSourceSinkPairs;
    private InternalTimeServiceManager.Provider timerServiceProvider;
    private JobType jobType = JobType.STREAMING;
    private Map<String, ResourceProfile> slotSharingGroupResources;
    private PipelineOptions.VertexDescriptionMode descriptionMode = PipelineOptions.VertexDescriptionMode.TREE;
    private boolean vertexNameIncludeIndexPrefix = false;
    private final List<JobStatusHook> jobStatusHooks = new ArrayList<JobStatusHook>();
    private boolean dynamic;
    private boolean autoParallelismEnabled;

    public StreamGraph(ExecutionConfig executionConfig, CheckpointConfig checkpointConfig, SavepointRestoreSettings savepointRestoreSettings) {
        this.executionConfig = (ExecutionConfig)Preconditions.checkNotNull((Object)executionConfig);
        this.checkpointConfig = (CheckpointConfig)Preconditions.checkNotNull((Object)checkpointConfig);
        this.savepointRestoreSettings = (SavepointRestoreSettings)Preconditions.checkNotNull((Object)savepointRestoreSettings);
        this.clear();
    }

    public void clear() {
        this.streamNodes = new HashMap<Integer, StreamNode>();
        this.virtualSideOutputNodes = new HashMap<Integer, Tuple2<Integer, OutputTag>>();
        this.virtualPartitionNodes = new HashMap();
        this.vertexIDtoBrokerID = new HashMap<Integer, String>();
        this.vertexIDtoLoopTimeout = new HashMap<Integer, Long>();
        this.iterationSourceSinkPairs = new HashSet<Tuple2<StreamNode, StreamNode>>();
        this.sources = new HashSet<Integer>();
        this.sinks = new HashSet<Integer>();
        this.slotSharingGroupResources = new HashMap<String, ResourceProfile>();
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public void setSavepointRestoreSettings(SavepointRestoreSettings savepointRestoreSettings) {
        this.savepointRestoreSettings = savepointRestoreSettings;
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointRestoreSettings;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setChaining(boolean chaining) {
        this.chaining = chaining;
    }

    public void setChainingOfOperatorsWithDifferentMaxParallelism(boolean chainingOfOperatorsWithDifferentMaxParallelism) {
        this.chainingOfOperatorsWithDifferentMaxParallelism = chainingOfOperatorsWithDifferentMaxParallelism;
    }

    public void setStateBackend(StateBackend backend) {
        this.stateBackend = backend;
    }

    public StateBackend getStateBackend() {
        return this.stateBackend;
    }

    public void setChangelogStateBackendEnabled(TernaryBoolean changelogStateBackendEnabled) {
        this.changelogStateBackendEnabled = changelogStateBackendEnabled;
    }

    public TernaryBoolean isChangelogStateBackendEnabled() {
        return this.changelogStateBackendEnabled;
    }

    public void setCheckpointStorage(CheckpointStorage checkpointStorage) {
        this.checkpointStorage = checkpointStorage;
    }

    public CheckpointStorage getCheckpointStorage() {
        return this.checkpointStorage;
    }

    public void setSavepointDirectory(Path savepointDir) {
        this.savepointDir = savepointDir;
    }

    public Path getSavepointDirectory() {
        return this.savepointDir;
    }

    public InternalTimeServiceManager.Provider getTimerServiceProvider() {
        return this.timerServiceProvider;
    }

    public void setTimerServiceProvider(InternalTimeServiceManager.Provider timerServiceProvider) {
        this.timerServiceProvider = (InternalTimeServiceManager.Provider)Preconditions.checkNotNull((Object)timerServiceProvider);
    }

    public Collection<Tuple2<String, DistributedCache.DistributedCacheEntry>> getUserArtifacts() {
        return this.userArtifacts;
    }

    public void setUserArtifacts(Collection<Tuple2<String, DistributedCache.DistributedCacheEntry>> userArtifacts) {
        this.userArtifacts = (Collection)Preconditions.checkNotNull(userArtifacts);
    }

    public TimeCharacteristic getTimeCharacteristic() {
        return this.timeCharacteristic;
    }

    public void setTimeCharacteristic(TimeCharacteristic timeCharacteristic) {
        this.timeCharacteristic = timeCharacteristic;
    }

    public GlobalStreamExchangeMode getGlobalStreamExchangeMode() {
        return this.globalExchangeMode;
    }

    public void setGlobalStreamExchangeMode(GlobalStreamExchangeMode globalExchangeMode) {
        this.globalExchangeMode = globalExchangeMode;
    }

    public void setSlotSharingGroupResource(Map<String, ResourceProfile> slotSharingGroupResources) {
        this.slotSharingGroupResources.putAll(slotSharingGroupResources);
    }

    public Optional<ResourceProfile> getSlotSharingGroupResource(String groupId) {
        return Optional.ofNullable(this.slotSharingGroupResources.get(groupId));
    }

    public boolean hasFineGrainedResource() {
        return this.slotSharingGroupResources.values().stream().anyMatch(resourceProfile -> !resourceProfile.equals((Object)ResourceProfile.UNKNOWN));
    }

    public void setAllVerticesInSameSlotSharingGroupByDefault(boolean allVerticesInSameSlotSharingGroupByDefault) {
        this.allVerticesInSameSlotSharingGroupByDefault = allVerticesInSameSlotSharingGroupByDefault;
    }

    public boolean isAllVerticesInSameSlotSharingGroupByDefault() {
        return this.allVerticesInSameSlotSharingGroupByDefault;
    }

    public boolean isEnableCheckpointsAfterTasksFinish() {
        return this.enableCheckpointsAfterTasksFinish;
    }

    public void setEnableCheckpointsAfterTasksFinish(boolean enableCheckpointsAfterTasksFinish) {
        this.enableCheckpointsAfterTasksFinish = enableCheckpointsAfterTasksFinish;
    }

    public boolean isChainingEnabled() {
        return this.chaining;
    }

    public boolean isChainingOfOperatorsWithDifferentMaxParallelismEnabled() {
        return this.chainingOfOperatorsWithDifferentMaxParallelism;
    }

    public boolean isIterative() {
        return !this.vertexIDtoLoopTimeout.isEmpty();
    }

    public <IN, OUT> void addSource(Integer vertexID, @Nullable String slotSharingGroup, @Nullable String coLocationGroup, SourceOperatorFactory<OUT> operatorFactory, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        this.addOperator(vertexID, slotSharingGroup, coLocationGroup, operatorFactory, inTypeInfo, outTypeInfo, operatorName, SourceOperatorStreamTask.class);
        this.sources.add(vertexID);
    }

    public <IN, OUT> void addLegacySource(Integer vertexID, @Nullable String slotSharingGroup, @Nullable String coLocationGroup, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        this.addOperator(vertexID, slotSharingGroup, coLocationGroup, operatorFactory, inTypeInfo, outTypeInfo, operatorName);
        this.sources.add(vertexID);
    }

    public <IN, OUT> void addSink(Integer vertexID, @Nullable String slotSharingGroup, @Nullable String coLocationGroup, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        this.addOperator(vertexID, slotSharingGroup, coLocationGroup, operatorFactory, inTypeInfo, outTypeInfo, operatorName);
        if (operatorFactory instanceof OutputFormatOperatorFactory) {
            this.setOutputFormat(vertexID, ((OutputFormatOperatorFactory)operatorFactory).getOutputFormat());
        }
        this.sinks.add(vertexID);
    }

    public <IN, OUT> void addOperator(Integer vertexID, @Nullable String slotSharingGroup, @Nullable String coLocationGroup, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        Class invokableClass = operatorFactory.isStreamSource() ? SourceStreamTask.class : OneInputStreamTask.class;
        this.addOperator(vertexID, slotSharingGroup, coLocationGroup, operatorFactory, inTypeInfo, outTypeInfo, operatorName, invokableClass);
    }

    private <IN, OUT> void addOperator(Integer vertexID, @Nullable String slotSharingGroup, @Nullable String coLocationGroup, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName, Class<? extends TaskInvokable> invokableClass) {
        this.addNode(vertexID, slotSharingGroup, coLocationGroup, invokableClass, operatorFactory, operatorName);
        this.setSerializers(vertexID, this.createSerializer(inTypeInfo), null, this.createSerializer(outTypeInfo));
        if (operatorFactory.isOutputTypeConfigurable() && outTypeInfo != null) {
            operatorFactory.setOutputType(outTypeInfo, this.executionConfig);
        }
        if (operatorFactory.isInputTypeConfigurable()) {
            operatorFactory.setInputType(inTypeInfo, this.executionConfig);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Vertex: {}", (Object)vertexID);
        }
    }

    public <IN1, IN2, OUT> void addCoOperator(Integer vertexID, String slotSharingGroup, @Nullable String coLocationGroup, StreamOperatorFactory<OUT> taskOperatorFactory, TypeInformation<IN1> in1TypeInfo, TypeInformation<IN2> in2TypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        Class<TwoInputStreamTask> vertexClass = TwoInputStreamTask.class;
        this.addNode(vertexID, slotSharingGroup, coLocationGroup, vertexClass, taskOperatorFactory, operatorName);
        TypeSerializer<OUT> outSerializer = this.createSerializer(outTypeInfo);
        this.setSerializers(vertexID, in1TypeInfo.createSerializer(this.executionConfig), in2TypeInfo.createSerializer(this.executionConfig), outSerializer);
        if (taskOperatorFactory.isOutputTypeConfigurable()) {
            taskOperatorFactory.setOutputType(outTypeInfo, this.executionConfig);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CO-TASK: {}", (Object)vertexID);
        }
    }

    public <OUT> void addMultipleInputOperator(Integer vertexID, String slotSharingGroup, @Nullable String coLocationGroup, StreamOperatorFactory<OUT> operatorFactory, List<TypeInformation<?>> inTypeInfos, TypeInformation<OUT> outTypeInfo, String operatorName) {
        Class<MultipleInputStreamTask> vertexClass = MultipleInputStreamTask.class;
        this.addNode(vertexID, slotSharingGroup, coLocationGroup, vertexClass, operatorFactory, operatorName);
        this.setSerializers(vertexID, inTypeInfos, this.createSerializer(outTypeInfo));
        if (operatorFactory.isOutputTypeConfigurable()) {
            operatorFactory.setOutputType(outTypeInfo, this.executionConfig);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CO-TASK: {}", (Object)vertexID);
        }
    }

    protected StreamNode addNode(Integer vertexID, @Nullable String slotSharingGroup, @Nullable String coLocationGroup, Class<? extends TaskInvokable> vertexClass, StreamOperatorFactory<?> operatorFactory, String operatorName) {
        if (this.streamNodes.containsKey(vertexID)) {
            throw new RuntimeException("Duplicate vertexID " + vertexID);
        }
        StreamNode vertex = new StreamNode(vertexID, slotSharingGroup, coLocationGroup, operatorFactory, operatorName, vertexClass);
        this.streamNodes.put(vertexID, vertex);
        return vertex;
    }

    public void addVirtualSideOutputNode(Integer originalId, Integer virtualId, OutputTag outputTag) {
        if (this.virtualSideOutputNodes.containsKey(virtualId)) {
            throw new IllegalStateException("Already has virtual output node with id " + virtualId);
        }
        for (Tuple2<Integer, OutputTag> tag : this.virtualSideOutputNodes.values()) {
            if (!((Integer)tag.f0).equals(originalId) || !((OutputTag)tag.f1).getId().equals(outputTag.getId()) || ((OutputTag)tag.f1).getTypeInfo().equals((Object)outputTag.getTypeInfo())) continue;
            throw new IllegalArgumentException("Trying to add a side output for the same side-output id with a different type. This is not allowed. Side-output ID: " + ((OutputTag)tag.f1).getId());
        }
        this.virtualSideOutputNodes.put(virtualId, (Tuple2<Integer, OutputTag>)new Tuple2((Object)originalId, (Object)outputTag));
    }

    public void addVirtualPartitionNode(Integer originalId, Integer virtualId, StreamPartitioner<?> partitioner, StreamExchangeMode exchangeMode) {
        if (this.virtualPartitionNodes.containsKey(virtualId)) {
            throw new IllegalStateException("Already has virtual partition node with id " + virtualId);
        }
        this.virtualPartitionNodes.put(virtualId, new Tuple3((Object)originalId, partitioner, (Object)exchangeMode));
    }

    public String getSlotSharingGroup(Integer id) {
        if (this.virtualSideOutputNodes.containsKey(id)) {
            Integer mappedId = (Integer)this.virtualSideOutputNodes.get((Object)id).f0;
            return this.getSlotSharingGroup(mappedId);
        }
        if (this.virtualPartitionNodes.containsKey(id)) {
            Integer mappedId = (Integer)this.virtualPartitionNodes.get((Object)id).f0;
            return this.getSlotSharingGroup(mappedId);
        }
        StreamNode node = this.getStreamNode(id);
        return node.getSlotSharingGroup();
    }

    public void addEdge(Integer upStreamVertexID, Integer downStreamVertexID, int typeNumber) {
        this.addEdge(upStreamVertexID, downStreamVertexID, typeNumber, null);
    }

    public void addEdge(Integer upStreamVertexID, Integer downStreamVertexID, int typeNumber, IntermediateDataSetID intermediateDataSetId) {
        this.addEdgeInternal(upStreamVertexID, downStreamVertexID, typeNumber, null, new ArrayList<String>(), null, null, intermediateDataSetId);
    }

    private void addEdgeInternal(Integer upStreamVertexID, Integer downStreamVertexID, int typeNumber, StreamPartitioner<?> partitioner, List<String> outputNames, OutputTag outputTag, StreamExchangeMode exchangeMode, IntermediateDataSetID intermediateDataSetId) {
        if (this.virtualSideOutputNodes.containsKey(upStreamVertexID)) {
            int virtualId = upStreamVertexID;
            upStreamVertexID = (Integer)this.virtualSideOutputNodes.get((Object)Integer.valueOf((int)virtualId)).f0;
            if (outputTag == null) {
                outputTag = (OutputTag)this.virtualSideOutputNodes.get((Object)Integer.valueOf((int)virtualId)).f1;
            }
            this.addEdgeInternal(upStreamVertexID, downStreamVertexID, typeNumber, partitioner, null, outputTag, exchangeMode, intermediateDataSetId);
        } else if (this.virtualPartitionNodes.containsKey(upStreamVertexID)) {
            int virtualId = upStreamVertexID;
            upStreamVertexID = (Integer)this.virtualPartitionNodes.get((Object)Integer.valueOf((int)virtualId)).f0;
            if (partitioner == null) {
                partitioner = (StreamPartitioner)this.virtualPartitionNodes.get((Object)Integer.valueOf((int)virtualId)).f1;
            }
            exchangeMode = (StreamExchangeMode)((Object)this.virtualPartitionNodes.get((Object)Integer.valueOf((int)virtualId)).f2);
            this.addEdgeInternal(upStreamVertexID, downStreamVertexID, typeNumber, partitioner, outputNames, outputTag, exchangeMode, intermediateDataSetId);
        } else {
            this.createActualEdge(upStreamVertexID, downStreamVertexID, typeNumber, partitioner, outputTag, exchangeMode, intermediateDataSetId);
        }
    }

    private void createActualEdge(Integer upStreamVertexID, Integer downStreamVertexID, int typeNumber, StreamPartitioner<?> partitioner, OutputTag outputTag, StreamExchangeMode exchangeMode, IntermediateDataSetID intermediateDataSetId) {
        StreamNode upstreamNode = this.getStreamNode(upStreamVertexID);
        StreamNode downstreamNode = this.getStreamNode(downStreamVertexID);
        if (partitioner == null && upstreamNode.getParallelism() == downstreamNode.getParallelism()) {
            partitioner = this.dynamic ? new ForwardForUnspecifiedPartitioner() : new ForwardPartitioner();
        } else if (partitioner == null) {
            partitioner = new RebalancePartitioner();
        }
        if (partitioner instanceof ForwardPartitioner && upstreamNode.getParallelism() != downstreamNode.getParallelism()) {
            if (partitioner instanceof ForwardForConsecutiveHashPartitioner) {
                partitioner = ((ForwardForConsecutiveHashPartitioner)partitioner).getHashPartitioner();
            } else {
                throw new UnsupportedOperationException("Forward partitioning does not allow change of parallelism. Upstream operation: " + upstreamNode + " parallelism: " + upstreamNode.getParallelism() + ", downstream operation: " + downstreamNode + " parallelism: " + downstreamNode.getParallelism() + " You must use another partitioning strategy, such as broadcast, rebalance, shuffle or global.");
            }
        }
        if (exchangeMode == null) {
            exchangeMode = StreamExchangeMode.UNDEFINED;
        }
        int uniqueId = this.getStreamEdges(upstreamNode.getId(), downstreamNode.getId()).size();
        StreamEdge edge = new StreamEdge(upstreamNode, downstreamNode, typeNumber, partitioner, outputTag, exchangeMode, uniqueId, intermediateDataSetId);
        this.getStreamNode(edge.getSourceId()).addOutEdge(edge);
        this.getStreamNode(edge.getTargetId()).addInEdge(edge);
    }

    public void setParallelism(Integer vertexID, int parallelism) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setParallelism(parallelism);
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setParallelism(Integer vertexId, int parallelism, boolean parallelismConfigured) {
        if (this.getStreamNode(vertexId) != null) {
            this.getStreamNode(vertexId).setParallelism(parallelism, parallelismConfigured);
        }
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setMaxParallelism(int vertexID, int maxParallelism) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setMaxParallelism(maxParallelism);
        }
    }

    public void setResources(int vertexID, ResourceSpec minResources, ResourceSpec preferredResources) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setResources(minResources, preferredResources);
        }
    }

    public void setManagedMemoryUseCaseWeights(int vertexID, Map<ManagedMemoryUseCase, Integer> operatorScopeUseCaseWeights, Set<ManagedMemoryUseCase> slotScopeUseCases) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setManagedMemoryUseCaseWeights(operatorScopeUseCaseWeights, slotScopeUseCases);
        }
    }

    public void setOneInputStateKey(Integer vertexID, KeySelector<?, ?> keySelector, TypeSerializer<?> keySerializer) {
        StreamNode node = this.getStreamNode(vertexID);
        node.setStatePartitioners(keySelector);
        node.setStateKeySerializer(keySerializer);
    }

    public void setTwoInputStateKey(Integer vertexID, KeySelector<?, ?> keySelector1, KeySelector<?, ?> keySelector2, TypeSerializer<?> keySerializer) {
        StreamNode node = this.getStreamNode(vertexID);
        node.setStatePartitioners(keySelector1, keySelector2);
        node.setStateKeySerializer(keySerializer);
    }

    public void setMultipleInputStateKey(Integer vertexID, List<KeySelector<?, ?>> keySelectors, TypeSerializer<?> keySerializer) {
        StreamNode node = this.getStreamNode(vertexID);
        node.setStatePartitioners((KeySelector[])keySelectors.stream().toArray(KeySelector[]::new));
        node.setStateKeySerializer(keySerializer);
    }

    public void setBufferTimeout(Integer vertexID, long bufferTimeout) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setBufferTimeout(bufferTimeout);
        }
    }

    public void setSerializers(Integer vertexID, TypeSerializer<?> in1, TypeSerializer<?> in2, TypeSerializer<?> out) {
        StreamNode vertex = this.getStreamNode(vertexID);
        vertex.setSerializersIn(in1, in2);
        vertex.setSerializerOut(out);
    }

    private <OUT> void setSerializers(Integer vertexID, List<TypeInformation<?>> inTypeInfos, TypeSerializer<OUT> out) {
        StreamNode vertex = this.getStreamNode(vertexID);
        vertex.setSerializersIn((TypeSerializer[])inTypeInfos.stream().map(typeInfo -> typeInfo.createSerializer(this.executionConfig)).toArray(TypeSerializer[]::new));
        vertex.setSerializerOut(out);
    }

    public void setInputFormat(Integer vertexID, InputFormat<?, ?> inputFormat) {
        this.getStreamNode(vertexID).setInputFormat(inputFormat);
    }

    public void setOutputFormat(Integer vertexID, OutputFormat<?> outputFormat) {
        this.getStreamNode(vertexID).setOutputFormat(outputFormat);
    }

    public void setTransformationUID(Integer nodeId, String transformationId) {
        StreamNode node = this.streamNodes.get(nodeId);
        if (node != null) {
            node.setTransformationUID(transformationId);
        }
    }

    void setTransformationUserHash(Integer nodeId, String nodeHash) {
        StreamNode node = this.streamNodes.get(nodeId);
        if (node != null) {
            node.setUserHash(nodeHash);
        }
    }

    public StreamNode getStreamNode(Integer vertexID) {
        return this.streamNodes.get(vertexID);
    }

    protected Collection<? extends Integer> getVertexIDs() {
        return this.streamNodes.keySet();
    }

    @VisibleForTesting
    public List<StreamEdge> getStreamEdges(int sourceId) {
        return this.getStreamNode(sourceId).getOutEdges();
    }

    @VisibleForTesting
    public List<StreamEdge> getStreamEdges(int sourceId, int targetId) {
        ArrayList<StreamEdge> result = new ArrayList<StreamEdge>();
        for (StreamEdge edge : this.getStreamNode(sourceId).getOutEdges()) {
            if (edge.getTargetId() != targetId) continue;
            result.add(edge);
        }
        return result;
    }

    @Deprecated
    @VisibleForTesting
    public List<StreamEdge> getStreamEdgesOrThrow(int sourceId, int targetId) {
        List<StreamEdge> result = this.getStreamEdges(sourceId, targetId);
        if (result.isEmpty()) {
            throw new RuntimeException("No such edge in stream graph: " + sourceId + " -> " + targetId);
        }
        return result;
    }

    public Collection<Integer> getSourceIDs() {
        return this.sources;
    }

    public Collection<Integer> getSinkIDs() {
        return this.sinks;
    }

    public Collection<StreamNode> getStreamNodes() {
        return this.streamNodes.values();
    }

    public Set<Tuple2<Integer, StreamOperatorFactory<?>>> getAllOperatorFactory() {
        HashSet operatorSet = new HashSet();
        for (StreamNode vertex : this.streamNodes.values()) {
            operatorSet.add(new Tuple2((Object)vertex.getId(), vertex.getOperatorFactory()));
        }
        return operatorSet;
    }

    public String getBrokerID(Integer vertexID) {
        return this.vertexIDtoBrokerID.get(vertexID);
    }

    public long getLoopTimeout(Integer vertexID) {
        return this.vertexIDtoLoopTimeout.get(vertexID);
    }

    public Tuple2<StreamNode, StreamNode> createIterationSourceAndSink(int loopId, int sourceId, int sinkId, long timeout, int parallelism, int maxParallelism, ResourceSpec minResources, ResourceSpec preferredResources) {
        String coLocationGroup = "IterationCoLocationGroup-" + loopId;
        StreamNode source = this.addNode(sourceId, null, coLocationGroup, StreamIterationHead.class, null, "IterationSource-" + loopId);
        this.sources.add(source.getId());
        this.setParallelism(source.getId(), parallelism);
        this.setMaxParallelism(source.getId(), maxParallelism);
        this.setResources(source.getId(), minResources, preferredResources);
        StreamNode sink = this.addNode(sinkId, null, coLocationGroup, StreamIterationTail.class, null, "IterationSink-" + loopId);
        this.sinks.add(sink.getId());
        this.setParallelism(sink.getId(), parallelism);
        this.setMaxParallelism(sink.getId(), parallelism);
        ResourceSpec tailResources = minResources.equals((Object)ResourceSpec.UNKNOWN) ? ResourceSpec.UNKNOWN : ResourceSpec.ZERO;
        this.setResources(sink.getId(), tailResources, tailResources);
        this.iterationSourceSinkPairs.add((Tuple2<StreamNode, StreamNode>)new Tuple2((Object)source, (Object)sink));
        this.vertexIDtoBrokerID.put(source.getId(), "broker-" + loopId);
        this.vertexIDtoBrokerID.put(sink.getId(), "broker-" + loopId);
        this.vertexIDtoLoopTimeout.put(source.getId(), timeout);
        this.vertexIDtoLoopTimeout.put(sink.getId(), timeout);
        return new Tuple2((Object)source, (Object)sink);
    }

    public Set<Tuple2<StreamNode, StreamNode>> getIterationSourceSinkPairs() {
        return this.iterationSourceSinkPairs;
    }

    public StreamNode getSourceVertex(StreamEdge edge) {
        return this.streamNodes.get(edge.getSourceId());
    }

    public StreamNode getTargetVertex(StreamEdge edge) {
        return this.streamNodes.get(edge.getTargetId());
    }

    private void removeEdge(StreamEdge edge) {
        this.getSourceVertex(edge).getOutEdges().remove(edge);
        this.getTargetVertex(edge).getInEdges().remove(edge);
    }

    private void removeVertex(StreamNode toRemove) {
        HashSet<StreamEdge> edgesToRemove = new HashSet<StreamEdge>();
        edgesToRemove.addAll(toRemove.getInEdges());
        edgesToRemove.addAll(toRemove.getOutEdges());
        for (StreamEdge edge : edgesToRemove) {
            this.removeEdge(edge);
        }
        this.streamNodes.remove(toRemove.getId());
    }

    @VisibleForTesting
    public JobGraph getJobGraph() {
        return this.getJobGraph(Thread.currentThread().getContextClassLoader(), null);
    }

    public JobGraph getJobGraph(ClassLoader userClassLoader, @Nullable JobID jobID) {
        return StreamingJobGraphGenerator.createJobGraph(userClassLoader, this, jobID);
    }

    public String getStreamingPlanAsJSON() {
        try {
            return new JSONGenerator(this).getJSON();
        }
        catch (Exception e) {
            throw new RuntimeException("JSON plan creation failed", e);
        }
    }

    private <T> TypeSerializer<T> createSerializer(TypeInformation<T> typeInfo) {
        return typeInfo != null && !(typeInfo instanceof MissingTypeInfo) ? typeInfo.createSerializer(this.executionConfig) : null;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public boolean isAutoParallelismEnabled() {
        return this.autoParallelismEnabled;
    }

    public void setAutoParallelismEnabled(boolean autoParallelismEnabled) {
        this.autoParallelismEnabled = autoParallelismEnabled;
    }

    public PipelineOptions.VertexDescriptionMode getVertexDescriptionMode() {
        return this.descriptionMode;
    }

    public void setVertexDescriptionMode(PipelineOptions.VertexDescriptionMode mode) {
        this.descriptionMode = mode;
    }

    public void setVertexNameIncludeIndexPrefix(boolean includePrefix) {
        this.vertexNameIncludeIndexPrefix = includePrefix;
    }

    public boolean isVertexNameIncludeIndexPrefix() {
        return this.vertexNameIncludeIndexPrefix;
    }

    public void registerJobStatusHook(JobStatusHook hook) {
        Preconditions.checkNotNull((Object)hook, (String)"Registering a null JobStatusHook is not allowed. ");
        if (!this.jobStatusHooks.contains(hook)) {
            this.jobStatusHooks.add(hook);
        }
    }

    public List<JobStatusHook> getJobStatusHooks() {
        return this.jobStatusHooks;
    }

    public void setSupportsConcurrentExecutionAttempts(Integer vertexId, boolean supportsConcurrentExecutionAttempts) {
        StreamNode streamNode = this.getStreamNode(vertexId);
        if (streamNode != null) {
            streamNode.setSupportsConcurrentExecutionAttempts(supportsConcurrentExecutionAttempts);
        }
    }
}

