/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

public class CreateTableOperation
implements CreateOperation {
    private final ObjectIdentifier tableIdentifier;
    private CatalogTable catalogTable;
    private boolean ignoreIfExists;
    private boolean isTemporary;

    public CreateTableOperation(ObjectIdentifier tableIdentifier, CatalogTable catalogTable, boolean ignoreIfExists, boolean isTemporary) {
        this.tableIdentifier = tableIdentifier;
        this.catalogTable = catalogTable;
        this.ignoreIfExists = ignoreIfExists;
        this.isTemporary = isTemporary;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogTable", this.catalogTable.toProperties());
        params.put("identifier", this.tableIdentifier);
        params.put("ignoreIfExists", this.ignoreIfExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("CREATE TABLE", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

