/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class DayTimeIntervalType
extends LogicalType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_DAY_PRECISION = 1;
    public static final int MAX_DAY_PRECISION = 6;
    public static final int DEFAULT_DAY_PRECISION = 2;
    public static final int MIN_FRACTIONAL_PRECISION = 0;
    public static final int MAX_FRACTIONAL_PRECISION = 9;
    public static final int DEFAULT_FRACTIONAL_PRECISION = 6;
    private static final String DAY_FORMAT = "INTERVAL DAY(%1$d)";
    private static final String DAY_TO_HOUR_FORMAT = "INTERVAL DAY(%1$d) TO HOUR";
    private static final String DAY_TO_MINUTE_FORMAT = "INTERVAL DAY(%1$d) TO MINUTE";
    private static final String DAY_TO_SECOND_FORMAT = "INTERVAL DAY(%1$d) TO SECOND(%2$d)";
    private static final String HOUR_FORMAT = "INTERVAL HOUR";
    private static final String HOUR_TO_MINUTE_FORMAT = "INTERVAL HOUR TO MINUTE";
    private static final String HOUR_TO_SECOND_FORMAT = "INTERVAL HOUR TO SECOND(%2$d)";
    private static final String MINUTE_FORMAT = "INTERVAL MINUTE";
    private static final String MINUTE_TO_SECOND_FORMAT = "INTERVAL MINUTE TO SECOND(%2$d)";
    private static final String SECOND_FORMAT = "INTERVAL SECOND(%2$d)";
    private static final Set<String> NULL_OUTPUT_CONVERSION = DayTimeIntervalType.conversionSet(Duration.class.getName(), Long.class.getName());
    private static final Set<String> NOT_NULL_INPUT_OUTPUT_CONVERSION = DayTimeIntervalType.conversionSet(Duration.class.getName(), Long.class.getName(), Long.TYPE.getName());
    private static final Class<?> DEFAULT_CONVERSION = Duration.class;
    private final DayTimeResolution resolution;
    private final int dayPrecision;
    private final int fractionalPrecision;

    public DayTimeIntervalType(boolean isNullable, DayTimeResolution resolution, int dayPrecision, int fractionalPrecision) {
        super(isNullable, LogicalTypeRoot.INTERVAL_DAY_TIME);
        Preconditions.checkNotNull((Object)((Object)resolution));
        if (this.needsDefaultDayPrecision(resolution) && dayPrecision != 2) {
            throw new ValidationException(String.format("Day precision of sub-day intervals must be equal to the default precision %d.", 2));
        }
        if (this.needsDefaultFractionalPrecision(resolution) && fractionalPrecision != 6) {
            throw new ValidationException(String.format("Fractional precision of super-second intervals must be equal to the default precision %d.", 6));
        }
        if (dayPrecision < 1 || dayPrecision > 6) {
            throw new ValidationException(String.format("Day precision of day-time intervals must be between %d and %d (both inclusive).", 1, 6));
        }
        if (fractionalPrecision < 0 || fractionalPrecision > 9) {
            throw new ValidationException(String.format("Fractional precision of day-time intervals must be between %d and %d (both inclusive).", 0, 9));
        }
        this.resolution = resolution;
        this.dayPrecision = dayPrecision;
        this.fractionalPrecision = fractionalPrecision;
    }

    public DayTimeIntervalType(DayTimeResolution resolution, int dayPrecision, int fractionalPrecision) {
        this(true, resolution, dayPrecision, fractionalPrecision);
    }

    public DayTimeIntervalType(DayTimeResolution resolution) {
        this(resolution, 2, 6);
    }

    public DayTimeResolution getResolution() {
        return this.resolution;
    }

    public int getDayPrecision() {
        return this.dayPrecision;
    }

    public int getFractionalPrecision() {
        return this.fractionalPrecision;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new DayTimeIntervalType(isNullable, this.resolution, this.dayPrecision, this.fractionalPrecision);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(this.getResolutionFormat(), this.dayPrecision, this.fractionalPrecision);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        if (this.isNullable()) {
            return NULL_OUTPUT_CONVERSION.contains(clazz.getName());
        }
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DayTimeIntervalType that = (DayTimeIntervalType)o;
        return this.dayPrecision == that.dayPrecision && this.fractionalPrecision == that.fractionalPrecision && this.resolution == that.resolution;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.resolution, this.dayPrecision, this.fractionalPrecision});
    }

    private boolean needsDefaultDayPrecision(DayTimeResolution resolution) {
        switch (resolution) {
            case HOUR: 
            case HOUR_TO_MINUTE: 
            case HOUR_TO_SECOND: 
            case MINUTE: 
            case MINUTE_TO_SECOND: 
            case SECOND: {
                return true;
            }
        }
        return false;
    }

    private boolean needsDefaultFractionalPrecision(DayTimeResolution resolution) {
        switch (resolution) {
            case HOUR: 
            case HOUR_TO_MINUTE: 
            case MINUTE: 
            case DAY: 
            case DAY_TO_HOUR: 
            case DAY_TO_MINUTE: {
                return true;
            }
        }
        return false;
    }

    private String getResolutionFormat() {
        switch (this.resolution) {
            case DAY: {
                return DAY_FORMAT;
            }
            case DAY_TO_HOUR: {
                return DAY_TO_HOUR_FORMAT;
            }
            case DAY_TO_MINUTE: {
                return DAY_TO_MINUTE_FORMAT;
            }
            case DAY_TO_SECOND: {
                return DAY_TO_SECOND_FORMAT;
            }
            case HOUR: {
                return HOUR_FORMAT;
            }
            case HOUR_TO_MINUTE: {
                return HOUR_TO_MINUTE_FORMAT;
            }
            case HOUR_TO_SECOND: {
                return HOUR_TO_SECOND_FORMAT;
            }
            case MINUTE: {
                return MINUTE_FORMAT;
            }
            case MINUTE_TO_SECOND: {
                return MINUTE_TO_SECOND_FORMAT;
            }
            case SECOND: {
                return SECOND_FORMAT;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static enum DayTimeResolution {
        DAY,
        DAY_TO_HOUR,
        DAY_TO_MINUTE,
        DAY_TO_SECOND,
        HOUR,
        HOUR_TO_MINUTE,
        HOUR_TO_SECOND,
        MINUTE,
        MINUTE_TO_SECOND,
        SECOND;

    }
}

