/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.WatermarkGenerator;

@Internal
public class GeneratedWatermarkGeneratorSupplier
implements WatermarkGeneratorSupplier<RowData> {
    private static final long serialVersionUID = 1L;
    private final GeneratedWatermarkGenerator generatedWatermarkGenerator;

    public GeneratedWatermarkGeneratorSupplier(GeneratedWatermarkGenerator generatedWatermarkGenerator) {
        this.generatedWatermarkGenerator = generatedWatermarkGenerator;
    }

    public org.apache.flink.api.common.eventtime.WatermarkGenerator<RowData> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
        ArrayList<Object> references = new ArrayList<Object>(Arrays.asList(this.generatedWatermarkGenerator.getReferences()));
        references.add(context);
        WatermarkGenerator innerWatermarkGenerator = (WatermarkGenerator)((Object)new GeneratedWatermarkGenerator(this.generatedWatermarkGenerator.getClassName(), this.generatedWatermarkGenerator.getCode(), references.toArray()).newInstance(Thread.currentThread().getContextClassLoader()));
        try {
            innerWatermarkGenerator.open(new Configuration());
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to instantiate generated watermark generator.", e);
        }
        return new DefaultWatermarkGenerator(innerWatermarkGenerator);
    }

    public static class DefaultWatermarkGenerator
    implements org.apache.flink.api.common.eventtime.WatermarkGenerator<RowData> {
        private static final long serialVersionUID = 1L;
        private final WatermarkGenerator innerWatermarkGenerator;
        private Long currentWatermark = Long.MIN_VALUE;

        public DefaultWatermarkGenerator(WatermarkGenerator watermarkGenerator) {
            this.innerWatermarkGenerator = watermarkGenerator;
        }

        public void onEvent(RowData event, long eventTimestamp, WatermarkOutput output) {
            try {
                Long watermark = this.innerWatermarkGenerator.currentWatermark(event);
                if (watermark != null) {
                    this.currentWatermark = watermark;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Generated WatermarkGenerator fails to generate for row: %s.", event), e);
            }
        }

        public void onPeriodicEmit(WatermarkOutput output) {
            output.emitWatermark(new Watermark(this.currentWatermark.longValue()));
        }
    }
}

