/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AMRMClientAsyncReflector {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMClientAsyncReflector.class);
    static final AMRMClientAsyncReflector INSTANCE = new AMRMClientAsyncReflector();
    private static final String UPDATE_BLOCKLIST_METHOD = "updateBlacklist";
    private static final String SYNC_CLIENT = "client";
    private final Optional<Method> asyncClientUpdateBlocklistMethod = AMRMClientAsyncReflector.tryGetMethod(AMRMClientAsync.class, "updateBlacklist", List.class, List.class);
    private final Optional<Method> syncClientUpdateBlocklistMethod = AMRMClientAsyncReflector.tryGetMethod(AMRMClient.class, "updateBlacklist", List.class, List.class);
    private final Optional<Field> syncClientField = AMRMClientAsyncReflector.tryGetField(AMRMClientAsync.class, "client");

    private AMRMClientAsyncReflector() {
    }

    private static <T> Optional<Method> tryGetMethod(Class<T> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return Optional.of(clazz.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} does not support method {} in this YARN version.", (Object)clazz.getCanonicalName(), (Object)methodName);
            }
            return Optional.empty();
        }
    }

    private static <T> Optional<Field> tryGetField(Class<T> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return Optional.of(field);
        }
        catch (NoSuchFieldException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} does not have field {} in this YARN version.", (Object)clazz.getCanonicalName(), (Object)fieldName);
            }
            return Optional.empty();
        }
    }

    public void tryUpdateBlockList(AMRMClientAsync<AMRMClient.ContainerRequest> asyncClient, List<String> blocklistAdditions, List<String> blocklistRemovals) {
        block4: {
            try {
                if (this.asyncClientUpdateBlocklistMethod.isPresent()) {
                    this.asyncClientUpdateBlocklistMethod.get().invoke(asyncClient, blocklistAdditions, blocklistRemovals);
                    break block4;
                }
                if (this.syncClientUpdateBlocklistMethod.isPresent() && this.syncClientField.isPresent()) {
                    Object syncClient = this.syncClientField.get().get(asyncClient);
                    this.syncClientUpdateBlocklistMethod.get().invoke(syncClient, blocklistAdditions, blocklistRemovals);
                    break block4;
                }
                throw new UnsupportedOperationException(String.format("Neither %s nor %s support method %s", asyncClient.getClass().getCanonicalName(), this.syncClientField.isPresent() ? this.syncClientField.get().get(asyncClient).getClass().getCanonicalName() : null, UPDATE_BLOCKLIST_METHOD));
            }
            catch (Throwable throwable) {
                LOG.warn("Failed to update blocklist, blocklistAdditions " + blocklistAdditions + ", blocklistRemovals " + blocklistRemovals, throwable);
            }
        }
    }
}

