/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import org.apache.geronimo.crypto.asn1.ASN1Encodable;
import org.apache.geronimo.crypto.asn1.ASN1EncodableVector;
import org.apache.geronimo.crypto.asn1.ASN1Sequence;
import org.apache.geronimo.crypto.asn1.DERInteger;
import org.apache.geronimo.crypto.asn1.DERObject;
import org.apache.geronimo.crypto.asn1.DERSequence;

public class DHParameter
extends ASN1Encodable {
    DERInteger p;
    DERInteger g;
    DERInteger l;

    public DHParameter(BigInteger p, BigInteger g, int l) {
        this.p = new DERInteger(p);
        this.g = new DERInteger(g);
        this.l = l != 0 ? new DERInteger(l) : null;
    }

    public DHParameter(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.p = (DERInteger)e.nextElement();
        this.g = (DERInteger)e.nextElement();
        this.l = e.hasMoreElements() ? (DERInteger)e.nextElement() : null;
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public BigInteger getL() {
        if (this.l == null) {
            return null;
        }
        return this.l.getPositiveValue();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.p);
        v.add(this.g);
        if (this.getL() != null) {
            v.add(this.l);
        }
        return new DERSequence(v);
    }
}

