/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.api;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hcatalog.api.HCatAddPartitionDesc;
import org.apache.hcatalog.api.HCatClientHMSImpl;
import org.apache.hcatalog.api.HCatCreateDBDesc;
import org.apache.hcatalog.api.HCatCreateTableDesc;
import org.apache.hcatalog.api.HCatDatabase;
import org.apache.hcatalog.api.HCatPartition;
import org.apache.hcatalog.api.HCatTable;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.schema.HCatFieldSchema;

public abstract class HCatClient {
    public static final String HCAT_CLIENT_IMPL_CLASS = "hcat.client.impl.class";

    public static HCatClient create(Configuration conf) throws HCatException {
        HCatClient client = null;
        String className = conf.get(HCAT_CLIENT_IMPL_CLASS, HCatClientHMSImpl.class.getName());
        try {
            Class<HCatClient> clientClass = Class.forName(className, true, JavaUtils.getClassLoader()).asSubclass(HCatClient.class);
            client = clientClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new HCatException("ClassNotFoundException while creating client class.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new HCatException("InstantiationException while creating client class.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HCatException("IllegalAccessException while creating client class.", (Throwable)e);
        }
        if (client != null) {
            client.initialize(conf);
        }
        return client;
    }

    abstract void initialize(Configuration var1) throws HCatException;

    public abstract List<String> listDatabaseNamesByPattern(String var1) throws HCatException;

    public abstract HCatDatabase getDatabase(String var1) throws HCatException;

    public abstract void createDatabase(HCatCreateDBDesc var1) throws HCatException;

    public abstract void dropDatabase(String var1, boolean var2, DropDBMode var3) throws HCatException;

    public abstract List<String> listTableNamesByPattern(String var1, String var2) throws HCatException;

    public abstract HCatTable getTable(String var1, String var2) throws HCatException;

    public abstract void createTable(HCatCreateTableDesc var1) throws HCatException;

    public abstract void updateTableSchema(String var1, String var2, List<HCatFieldSchema> var3) throws HCatException;

    public abstract void createTableLike(String var1, String var2, String var3, boolean var4, boolean var5, String var6) throws HCatException;

    public abstract void dropTable(String var1, String var2, boolean var3) throws HCatException;

    public abstract void renameTable(String var1, String var2, String var3) throws HCatException;

    public abstract List<HCatPartition> getPartitions(String var1, String var2) throws HCatException;

    public abstract List<HCatPartition> getPartitions(String var1, String var2, Map<String, String> var3) throws HCatException;

    public abstract HCatPartition getPartition(String var1, String var2, Map<String, String> var3) throws HCatException;

    public abstract void addPartition(HCatAddPartitionDesc var1) throws HCatException;

    public abstract int addPartitions(List<HCatAddPartitionDesc> var1) throws HCatException;

    public abstract void dropPartitions(String var1, String var2, Map<String, String> var3, boolean var4) throws HCatException;

    public abstract List<HCatPartition> listPartitionsByFilter(String var1, String var2, String var3) throws HCatException;

    public abstract void markPartitionForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws HCatException;

    public abstract boolean isPartitionMarkedForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws HCatException;

    public abstract String getDelegationToken(String var1, String var2) throws HCatException;

    public abstract long renewDelegationToken(String var1) throws HCatException;

    public abstract void cancelDelegationToken(String var1) throws HCatException;

    public abstract String getMessageBusTopicName(String var1, String var2) throws HCatException;

    public abstract void close() throws HCatException;

    public static enum DropDBMode {
        RESTRICT,
        CASCADE;

    }
}

