/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.clock;

import java.util.Calendar;
import java.util.Date;
import org.apache.isis.applib.ApplicationException;
import org.apache.isis.applib.Defaults;
import org.apache.isis.applib.clock.SystemClock;
import org.joda.time.DateTime;

public abstract class Clock {
    private static Clock instance;
    private static boolean isReplaceable;

    public static final Clock getInstance() {
        if (!Clock.isInitialized()) {
            instance = new SystemClock();
            isReplaceable = false;
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static long getTime() {
        return Clock.getInstance().time();
    }

    @Deprecated
    public static Calendar getTimeAsCalendar() {
        return Clock.getInstance().timeAsCalendar();
    }

    @Deprecated
    public static Date getTimeAsDate() {
        return new Date(Clock.getTime());
    }

    public static DateTime getTimeAsDateTime() {
        return new DateTime(Clock.getTime(), Defaults.getTimeZone());
    }

    private static void ensureReplaceable() {
        if (!isReplaceable && instance != null) {
            throw new ApplicationException("Clock already set up");
        }
    }

    protected static boolean remove() {
        Clock.ensureReplaceable();
        if (instance == null) {
            return false;
        }
        instance = null;
        return true;
    }

    protected Clock() {
        Clock.ensureReplaceable();
        instance = this;
    }

    public final Calendar timeAsCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(Clock.getTime());
        return cal;
    }

    protected abstract long time();

    static {
        isReplaceable = true;
    }
}

