/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.math.BigDecimal;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.value.Magnitude;

@Value(semanticsProviderName="org.apache.isis.core.progmodel.facets.value.money.MoneyValueSemanticsProvider")
public class Money
extends Magnitude<Money> {
    private static final long serialVersionUID = 1L;
    private static final int[] cents = new int[]{1, 10, 100, 100};
    private final long amount;
    private final String currency;

    public Money(double amount, String currency) {
        this.assertCurrencySet(currency);
        this.currency = currency.toUpperCase();
        this.amount = Math.round(amount * (double)this.centFactor());
    }

    public Money(long amount, String currency) {
        this.assertCurrencySet(currency);
        this.currency = currency.toUpperCase();
        this.amount = amount * (long)this.centFactor();
    }

    private void assertCurrencySet(String currency) {
        if (currency == null || currency.equals("")) {
            throw new IllegalArgumentException("Currency must be specified");
        }
        if (currency.length() != 3) {
            throw new IllegalArgumentException("Invalid currency code '" + currency + "'");
        }
    }

    public Money add(Money money) {
        this.assertSameCurrency(money);
        return this.newMoney(this.amount + money.amount);
    }

    private void assertSameCurrency(Money money) {
        if (!money.getCurrency().equals(this.getCurrency())) {
            throw new IllegalArgumentException("Not the same currency: " + this.getCurrency() + " & " + money.getCurrency());
        }
    }

    private int centFactor() {
        return cents[this.getFractionalDigits()];
    }

    public double doubleValue() {
        return (double)this.amount / (double)this.centFactor();
    }

    public float floatValue() {
        return this.amount;
    }

    public BigDecimal getAmount() {
        return BigDecimal.valueOf(this.amount, this.getFractionalDigits());
    }

    public String getCurrency() {
        return this.currency;
    }

    private int getFractionalDigits() {
        return 2;
    }

    public boolean hasSameCurrency(Money money) {
        return this.currency.equals(money.currency);
    }

    public int intValue() {
        return (int)this.amount;
    }

    @Override
    public boolean isEqualTo(Money magnitude) {
        if (!this.hasSameCurrency(magnitude)) {
            throw new IllegalArgumentException("Parameter must be of type Money and have the same currency");
        }
        return magnitude.amount == this.amount;
    }

    public boolean isGreaterThanZero() {
        return this.amount > 0L;
    }

    @Override
    public boolean isLessThan(Money magnitude) {
        if (!this.hasSameCurrency(magnitude)) {
            throw new IllegalArgumentException("Parameter must be of type Money and have the same currency");
        }
        return this.amount < magnitude.amount;
    }

    public boolean isLessThanZero() {
        return this.amount < 0L;
    }

    public boolean isZero() {
        return this.amount == 0L;
    }

    public long longValue() {
        return this.amount;
    }

    private Money newMoney(long amount) {
        return new Money((double)amount / ((double)this.centFactor() * 1.0), this.currency);
    }

    public Money subtract(Money money) {
        this.assertSameCurrency(money);
        return this.newMoney(this.amount - money.amount);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other.getClass() == this.getClass() && this.equals((Money)other);
    }

    public boolean equals(Money other) {
        return other.currency.equals(this.currency) && other.amount == this.amount;
    }

    public int hashCode() {
        return (int)this.amount;
    }

    public String toString() {
        return (double)this.amount / ((double)this.centFactor() * 1.0) + " " + this.currency;
    }
}

