/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.progmodel.wrapper.metamodel.internal;

import java.util.Collection;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.progmodel.wrapper.applib.WrapperFactory;
import org.apache.isis.progmodel.wrapper.metamodel.internal.CgLibProxy;
import org.apache.isis.progmodel.wrapper.metamodel.internal.CollectionInvocationHandler;
import org.apache.isis.progmodel.wrapper.metamodel.internal.DomainObjectInvocationHandler;
import org.apache.isis.progmodel.wrapper.metamodel.internal.MapInvocationHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class Proxy {
    public static <T> T proxy(T domainObject, WrapperFactory wrapperFactory, WrapperFactory.ExecutionMode mode, AuthenticationSessionProvider authenticationSessionProvider, SpecificationLookup specificationLookup, AdapterMap adapterManager, ObjectPersistor objectPersistor) {
        Ensure.ensureThatArg((Object)wrapperFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authenticationSessionProvider, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)specificationLookup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)adapterManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)objectPersistor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        DomainObjectInvocationHandler<T> invocationHandler = new DomainObjectInvocationHandler<T>(domainObject, wrapperFactory, mode, authenticationSessionProvider, specificationLookup, adapterManager, objectPersistor);
        CgLibProxy<T> cglibProxy = new CgLibProxy<T>(invocationHandler);
        return cglibProxy.proxy();
    }

    public static <T, E> Collection<E> proxy(Collection<E> collectionToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, OneToManyAssociation otma) {
        CollectionInvocationHandler<T, Collection<E>> collectionInvocationHandler = new CollectionInvocationHandler<T, Collection<E>>(collectionToProxy, collectionName, handler, otma);
        collectionInvocationHandler.setResolveObjectChangedEnabled(handler.isResolveObjectChangedEnabled());
        CgLibProxy cglibProxy = new CgLibProxy(collectionInvocationHandler);
        return (Collection)cglibProxy.proxy();
    }

    public static <T, P, Q> Map<P, Q> proxy(Map<P, Q> collectionToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, OneToManyAssociation otma) {
        MapInvocationHandler<T, Map<P, Q>> mapInvocationHandler = new MapInvocationHandler<T, Map<P, Q>>(collectionToProxy, collectionName, handler, otma);
        mapInvocationHandler.setResolveObjectChangedEnabled(handler.isResolveObjectChangedEnabled());
        CgLibProxy cglibProxy = new CgLibProxy(mapInvocationHandler);
        return (Map)cglibProxy.proxy();
    }
}

