/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.progmodel.wrapper.metamodel.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.events.ActionArgumentEvent;
import org.apache.isis.applib.events.ActionInvocationEvent;
import org.apache.isis.applib.events.ActionUsabilityEvent;
import org.apache.isis.applib.events.ActionVisibilityEvent;
import org.apache.isis.applib.events.CollectionAccessEvent;
import org.apache.isis.applib.events.CollectionAddToEvent;
import org.apache.isis.applib.events.CollectionMethodEvent;
import org.apache.isis.applib.events.CollectionRemoveFromEvent;
import org.apache.isis.applib.events.CollectionUsabilityEvent;
import org.apache.isis.applib.events.CollectionVisibilityEvent;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.applib.events.ObjectTitleEvent;
import org.apache.isis.applib.events.ObjectValidityEvent;
import org.apache.isis.applib.events.PropertyAccessEvent;
import org.apache.isis.applib.events.PropertyModifyEvent;
import org.apache.isis.applib.events.PropertyUsabilityEvent;
import org.apache.isis.applib.events.PropertyVisibilityEvent;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.ObjectPersistorAware;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.metamodel.spec.SpecificationLookupAware;
import org.apache.isis.progmodel.wrapper.applib.WrapperFactory;
import org.apache.isis.progmodel.wrapper.applib.WrapperObject;
import org.apache.isis.progmodel.wrapper.applib.listeners.InteractionListener;
import org.apache.isis.progmodel.wrapper.metamodel.internal.InteractionEventDispatcher;
import org.apache.isis.progmodel.wrapper.metamodel.internal.InteractionEventDispatcherTypeSafe;
import org.apache.isis.progmodel.wrapper.metamodel.internal.Proxy;

public class WrapperFactoryDefault
implements WrapperFactory,
AuthenticationSessionProviderAware,
SpecificationLookupAware,
AdapterMapAware,
ObjectPersistorAware {
    private final List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    private final Map<Class<? extends InteractionEvent>, InteractionEventDispatcher> dispatchersByEventClass = new HashMap<Class<? extends InteractionEvent>, InteractionEventDispatcher>();
    private AuthenticationSessionProvider authenticationSessionProvider;
    private SpecificationLookup specificationLookup;
    private AdapterMap adapterManager;
    private ObjectPersistor objectPersistor;

    public WrapperFactoryDefault() {
        this.dispatchersByEventClass.put(ObjectTitleEvent.class, new InteractionEventDispatcherTypeSafe<ObjectTitleEvent>(){

            @Override
            public void dispatchTypeSafe(ObjectTitleEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.objectTitleRead(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<PropertyVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyVisibilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.propertyVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<PropertyUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyUsabilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.propertyUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyAccessEvent.class, new InteractionEventDispatcherTypeSafe<PropertyAccessEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyAccessEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.propertyAccessed(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyModifyEvent.class, new InteractionEventDispatcherTypeSafe<PropertyModifyEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyModifyEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.propertyModified(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<CollectionVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionVisibilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<CollectionUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionUsabilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionAccessEvent.class, new InteractionEventDispatcherTypeSafe<CollectionAccessEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionAccessEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionAccessed(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionAddToEvent.class, new InteractionEventDispatcherTypeSafe<CollectionAddToEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionAddToEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionAddedTo(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionRemoveFromEvent.class, new InteractionEventDispatcherTypeSafe<CollectionRemoveFromEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionRemoveFromEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionRemovedFrom(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<ActionVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(ActionVisibilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.actionVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<ActionUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(ActionUsabilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.actionUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionArgumentEvent.class, new InteractionEventDispatcherTypeSafe<ActionArgumentEvent>(){

            @Override
            public void dispatchTypeSafe(ActionArgumentEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.actionArgument(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionInvocationEvent.class, new InteractionEventDispatcherTypeSafe<ActionInvocationEvent>(){

            @Override
            public void dispatchTypeSafe(ActionInvocationEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.actionInvoked(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ObjectValidityEvent.class, new InteractionEventDispatcherTypeSafe<ObjectValidityEvent>(){

            @Override
            public void dispatchTypeSafe(ObjectValidityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.objectPersisted(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionMethodEvent.class, new InteractionEventDispatcherTypeSafe<CollectionMethodEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionMethodEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionMethodInvoked(interactionEvent);
                }
            }
        });
    }

    public <T> T wrap(T domainObject) {
        return this.wrap(domainObject, WrapperFactory.ExecutionMode.EXECUTE);
    }

    public <T> T wrap(T domainObject, WrapperFactory.ExecutionMode mode) {
        if (this.isWrapper(domainObject)) {
            return domainObject;
        }
        return Proxy.proxy(domainObject, this, mode, this.authenticationSessionProvider, this.specificationLookup, this.adapterManager, this.objectPersistor);
    }

    public boolean isWrapper(Object possibleWrapper) {
        return possibleWrapper instanceof WrapperObject;
    }

    public List<InteractionListener> getListeners() {
        return this.listeners;
    }

    public boolean addInteractionListener(InteractionListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeInteractionListener(InteractionListener listener) {
        return this.listeners.remove(listener);
    }

    public void notifyListeners(InteractionEvent interactionEvent) {
        InteractionEventDispatcher dispatcher = this.dispatchersByEventClass.get(interactionEvent.getClass());
        if (dispatcher == null) {
            throw new RuntimeException("Unknown InteractionEvent - register into dispatchers map");
        }
        dispatcher.dispatch(interactionEvent);
    }

    public void setAuthenticationSessionProvider(AuthenticationSessionProvider authenticationSessionProvider) {
        this.authenticationSessionProvider = authenticationSessionProvider;
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterManager = adapterMap;
    }

    public void setSpecificationLookup(SpecificationLookup specificationLookup) {
        this.specificationLookup = specificationLookup;
    }

    public void setObjectPersistor(ObjectPersistor objectPersistor) {
        this.objectPersistor = objectPersistor;
    }
}

